/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.juneau.commons.utils.AssertionUtils;

public class FileReaderBuilder {
    private File file;
    private Charset cs = Charset.defaultCharset();
    private boolean allowNoFile;

    public static FileReaderBuilder create() {
        return new FileReaderBuilder();
    }

    public static FileReaderBuilder create(File file) {
        return new FileReaderBuilder().file(file);
    }

    public FileReaderBuilder allowNoFile() {
        this.allowNoFile = true;
        return this;
    }

    public Reader build() throws FileNotFoundException {
        if (this.allowNoFile && (this.file == null || !this.file.exists())) {
            return new StringReader("");
        }
        AssertionUtils.assertArgNotNull("file", this.file);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.cs != null ? this.cs : Charset.defaultCharset());
    }

    public FileReaderBuilder charset(Charset cs) {
        this.cs = cs;
        return this;
    }

    public FileReaderBuilder charset(String cs) {
        this.cs = Charset.forName(AssertionUtils.assertArgNotNull("cs", cs));
        return this;
    }

    public FileReaderBuilder file(File value) {
        this.file = value;
        return this;
    }

    public FileReaderBuilder file(String path) {
        this.file = new File(path);
        return this;
    }
}

