/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.converter;

import org.apache.juneau.BeanSession;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.objecttools.MatcherFactory;
import org.apache.juneau.objecttools.ObjectPaginator;
import org.apache.juneau.objecttools.ObjectSearcher;
import org.apache.juneau.objecttools.ObjectSorter;
import org.apache.juneau.objecttools.ObjectViewer;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.converter.RestConverter;
import org.apache.juneau.rest.httppart.RequestQueryParams;

public class Queryable
implements RestConverter {
    public static final String SWAGGER_PARAMS = "{\n\tin:'query',\n\tname:'s',\n\tdescription:'Search.\n\t\tKey/value pairs representing column names and search tokens.\n\t\t\\'*\\' and \\'?\\' can be used as meta-characters in string fields.\n\t\t\\'>\\', \\'>=\\', \\'<\\', and \\'<=\\' can be used as limits on numeric and date fields.\n\t\tDate fields can be matched with partial dates (e.g. \\'2018\\' to match any date in the year 2018).',\n\ttype:'array',\n\tcollectionFormat:'csv',\n\texamples:{example:'?s=Bill*,birthDate>2000'}\n},{\n\tin:'query',\n\tname:'v',\n\tdescription:'View.\n\t\tColumn names to display.',\n\ttype:'array',\n\tcollectionFormat:'csv',\n\texamples:{example:'?v=name,birthDate'}\n},{\n\tin:'query',\n\tname:'o',\n\tdescription:'Order by.\n\t\tColumns to sort by.\n\t\tColumn names can be suffixed with \\'+\\' or \\'-\\' to indicate ascending or descending order.\n\t\tThe default is ascending order.',\n\ttype:'array',\n\tcollectionFormat:'csv',\n\texamples:{example:'?o=name,birthDate-'}\n},{\n\tin:'query',\n\tname:'p',\n\tdescription:'Position.\n\t\tOnly return rows starting at the specified index position (zero-indexed).\n\t\tDefault is 0',\n\ttype:'integer',\n\texamples:{example:'?p=100'}\n},{\n\tin:'query',\n\tname:'l',\n\tdescription:'Limit.\n\t\tOnly return the specified number of rows.\n\t\tDefault is 0 (meaning return all rows).',\n\ttype:'integer',\n\texamples:{example:'?l=100'}\n}";

    @Override
    public Object convert(RestRequest req, Object o) {
        if (o == null) {
            return null;
        }
        Value v = Value.of((Object)o);
        RequestQueryParams params = req.getQueryParams();
        BeanSession bs = req.getBeanSession();
        params.getSearchArgs().ifPresent(x -> v.set(ObjectSearcher.create((MatcherFactory[])new MatcherFactory[0]).run(bs, v.get(), x)));
        params.getSortArgs().ifPresent(x -> v.set(ObjectSorter.create().run(bs, v.get(), x)));
        params.getViewArgs().ifPresent(x -> v.set(ObjectViewer.create().run(bs, v.get(), x)));
        params.getPageArgs().ifPresent(x -> v.set(ObjectPaginator.create().run(bs, v.get(), x)));
        return v.get();
    }
}

