/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.juneau.MediaRange;
import org.apache.juneau.MediaRanges;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.header.BasicStringHeader;

public class BasicMediaRangesHeader
extends BasicStringHeader {
    private static final long serialVersionUID = 1L;
    private final String stringValue;
    private final MediaRanges value;
    private final Supplier<MediaRanges> supplier;

    public static BasicMediaRangesHeader of(String name, MediaRanges value) {
        return value == null ? null : new BasicMediaRangesHeader(name, value);
    }

    public static BasicMediaRangesHeader of(String name, String value) {
        return value == null ? null : new BasicMediaRangesHeader(name, value);
    }

    public BasicMediaRangesHeader(String name, MediaRanges value) {
        super(name, Utils.s((Object)value));
        this.stringValue = null;
        this.value = value;
        this.supplier = null;
    }

    public BasicMediaRangesHeader(String name, String value) {
        super(name, value);
        this.stringValue = value;
        this.value = BasicMediaRangesHeader.parse(value);
        this.supplier = null;
    }

    public BasicMediaRangesHeader(String name, Supplier<MediaRanges> value) {
        super(name, (String)null);
        this.stringValue = null;
        this.value = null;
        this.supplier = value;
    }

    public Optional<MediaRanges> asMediaRanges() {
        return Utils.opt((Object)this.value());
    }

    public MediaRange getRange(int index) {
        MediaRanges x = this.value();
        return x == null ? null : x.getRange(index);
    }

    @Override
    public String getValue() {
        return Utils.nn((Object)this.stringValue) ? this.stringValue : Utils.s((Object)this.value());
    }

    public boolean hasSubtypePart(String part) {
        MediaRanges x = this.value();
        return x == null ? false : x.hasSubtypePart(part);
    }

    public int match(List<? extends MediaType> mediaTypes) {
        MediaRanges x = this.value();
        return x == null ? -1 : x.match(mediaTypes);
    }

    public MediaRanges orElse(MediaRanges other) {
        MediaRanges x = this.value();
        return Utils.nn((Object)x) ? x : other;
    }

    public MediaRanges toMediaRanges() {
        return this.value();
    }

    private static MediaRanges parse(String value) {
        return value == null ? null : MediaRanges.of((String)value);
    }

    private MediaRanges value() {
        if (Utils.nn(this.supplier)) {
            return this.supplier.get();
        }
        return this.value;
    }
}

