/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class UnionSet<T>
implements Set<T> {
    private final Set<T> largeSet;
    private final Set<T> smallSet;
    private int size = -1;

    public UnionSet(Set<T> s1, Set<T> s2) {
        Objects.requireNonNull(s1);
        Objects.requireNonNull(s2);
        if (s1.size() > s2.size()) {
            this.largeSet = s1;
            this.smallSet = s2;
        } else {
            this.largeSet = s2;
            this.smallSet = s1;
        }
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = this.largeSet.size();
            for (T item : this.smallSet) {
                if (this.largeSet.contains(item)) continue;
                ++this.size;
            }
        }
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.largeSet.isEmpty() && this.smallSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.largeSet.contains(o) || this.smallSet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<T> largeSetIterator;
            private final Iterator<T> smallSetIterator;
            private T next;
            {
                this.largeSetIterator = UnionSet.this.largeSet.iterator();
                this.smallSetIterator = UnionSet.this.smallSet.iterator();
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.largeSetIterator.hasNext()) {
                    this.next = this.largeSetIterator.next();
                    return true;
                }
                while (this.smallSetIterator.hasNext()) {
                    this.next = this.smallSetIterator.next();
                    if (UnionSet.this.largeSet.contains(this.next)) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        for (T item : this.largeSet) {
            array[index] = item;
            ++index;
        }
        for (T item : this.smallSet) {
            if (this.largeSet.contains(item)) continue;
            array[index] = item;
            ++index;
        }
        return array;
    }

    @Override
    public <U> U[] toArray(U[] array) {
        int size = this.size();
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        int index = 0;
        for (T item : this.largeSet) {
            array[index] = item;
            ++index;
        }
        for (T item : this.smallSet) {
            if (this.largeSet.contains(item)) continue;
            array[index] = item;
            ++index;
        }
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    public boolean add(T t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set set = (Set)o;
        if (set.size() != this.size()) {
            return false;
        }
        return this.containsAll(set);
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (T item : this.largeSet) {
            h += item.hashCode();
        }
        for (T item : this.smallSet) {
            if (this.largeSet.contains(item)) continue;
            h += item.hashCode();
        }
        return h;
    }

    public String toString() {
        return "UnionSet(largeSet=" + String.valueOf(this.largeSet) + ", smallSet=" + String.valueOf(this.smallSet) + ")";
    }
}

