/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.errors.SchemaBuilderException;

public class SchemaBuilder
implements Schema {
    private static final String TYPE_FIELD = "type";
    private static final String OPTIONAL_FIELD = "optional";
    private static final String DEFAULT_FIELD = "default";
    private static final String NAME_FIELD = "name";
    private static final String VERSION_FIELD = "version";
    private static final String DOC_FIELD = "doc";
    private final Schema.Type type;
    private Boolean optional = null;
    private Object defaultValue = null;
    private Map<String, Field> fields = null;
    private Schema keySchema = null;
    private Schema valueSchema = null;
    private String name;
    private Integer version;
    private String doc;
    private Map<String, String> parameters;

    public SchemaBuilder(Schema.Type type) {
        if (null == type) {
            throw new SchemaBuilderException("type cannot be null");
        }
        this.type = type;
        if (type == Schema.Type.STRUCT) {
            this.fields = new LinkedHashMap<String, Field>();
        }
    }

    @Override
    public boolean isOptional() {
        return this.optional != null && this.optional != false;
    }

    public SchemaBuilder optional() {
        SchemaBuilder.checkCanSet(OPTIONAL_FIELD, this.optional, true);
        this.optional = true;
        return this;
    }

    public SchemaBuilder required() {
        SchemaBuilder.checkCanSet(OPTIONAL_FIELD, this.optional, false);
        this.optional = false;
        return this;
    }

    @Override
    public Object defaultValue() {
        return this.defaultValue;
    }

    public SchemaBuilder defaultValue(Object value) {
        SchemaBuilder.checkCanSet(DEFAULT_FIELD, this.defaultValue, value);
        SchemaBuilder.checkNotNull(TYPE_FIELD, (Object)this.type, DEFAULT_FIELD);
        try {
            ConnectSchema.validateValue(this, value);
        }
        catch (DataException e) {
            throw new SchemaBuilderException("Invalid default value", (Throwable)((Object)e));
        }
        this.defaultValue = value;
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    public SchemaBuilder name(String name) {
        SchemaBuilder.checkCanSet(NAME_FIELD, this.name, name);
        this.name = name;
        return this;
    }

    @Override
    public Integer version() {
        return this.version;
    }

    public SchemaBuilder version(Integer version) {
        SchemaBuilder.checkCanSet(VERSION_FIELD, this.version, version);
        this.version = version;
        return this;
    }

    @Override
    public String doc() {
        return this.doc;
    }

    public SchemaBuilder doc(String doc) {
        SchemaBuilder.checkCanSet(DOC_FIELD, this.doc, doc);
        this.doc = doc;
        return this;
    }

    @Override
    public Map<String, String> parameters() {
        return this.parameters == null ? null : Collections.unmodifiableMap(this.parameters);
    }

    public SchemaBuilder parameter(String propertyName, String propertyValue) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        this.parameters.put(propertyName, propertyValue);
        return this;
    }

    public SchemaBuilder parameters(Map<String, String> props) {
        if (props.isEmpty()) {
            return this;
        }
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        this.parameters.putAll(props);
        return this;
    }

    @Override
    public Schema.Type type() {
        return this.type;
    }

    public static SchemaBuilder type(Schema.Type type) {
        return new SchemaBuilder(type);
    }

    public static SchemaBuilder int8() {
        return new SchemaBuilder(Schema.Type.INT8);
    }

    public static SchemaBuilder int16() {
        return new SchemaBuilder(Schema.Type.INT16);
    }

    public static SchemaBuilder int32() {
        return new SchemaBuilder(Schema.Type.INT32);
    }

    public static SchemaBuilder int64() {
        return new SchemaBuilder(Schema.Type.INT64);
    }

    public static SchemaBuilder float32() {
        return new SchemaBuilder(Schema.Type.FLOAT32);
    }

    public static SchemaBuilder float64() {
        return new SchemaBuilder(Schema.Type.FLOAT64);
    }

    public static SchemaBuilder bool() {
        return new SchemaBuilder(Schema.Type.BOOLEAN);
    }

    public static SchemaBuilder string() {
        return new SchemaBuilder(Schema.Type.STRING);
    }

    public static SchemaBuilder bytes() {
        return new SchemaBuilder(Schema.Type.BYTES);
    }

    public static SchemaBuilder struct() {
        return new SchemaBuilder(Schema.Type.STRUCT);
    }

    public SchemaBuilder field(String fieldName, Schema fieldSchema) {
        if (this.type != Schema.Type.STRUCT) {
            throw new SchemaBuilderException("Cannot create fields on type " + String.valueOf((Object)this.type));
        }
        if (null == fieldName || fieldName.isEmpty()) {
            throw new SchemaBuilderException("fieldName cannot be null.");
        }
        if (null == fieldSchema) {
            throw new SchemaBuilderException("fieldSchema for field " + fieldName + " cannot be null.");
        }
        int fieldIndex = this.fields.size();
        if (this.fields.containsKey(fieldName)) {
            throw new SchemaBuilderException("Cannot create field because of field name duplication " + fieldName);
        }
        this.fields.put(fieldName, new Field(fieldName, fieldIndex, fieldSchema));
        return this;
    }

    @Override
    public List<Field> fields() {
        if (this.type != Schema.Type.STRUCT) {
            throw new DataException("Cannot list fields on non-struct type");
        }
        return new ArrayList<Field>(this.fields.values());
    }

    @Override
    public Field field(String fieldName) {
        if (this.type != Schema.Type.STRUCT) {
            throw new DataException("Cannot look up fields on non-struct type");
        }
        return this.fields.get(fieldName);
    }

    public static SchemaBuilder array(Schema valueSchema) {
        if (null == valueSchema) {
            throw new SchemaBuilderException("valueSchema cannot be null.");
        }
        SchemaBuilder builder = new SchemaBuilder(Schema.Type.ARRAY);
        builder.valueSchema = valueSchema;
        return builder;
    }

    public static SchemaBuilder map(Schema keySchema, Schema valueSchema) {
        if (null == keySchema) {
            throw new SchemaBuilderException("keySchema cannot be null.");
        }
        if (null == valueSchema) {
            throw new SchemaBuilderException("valueSchema cannot be null.");
        }
        SchemaBuilder builder = new SchemaBuilder(Schema.Type.MAP);
        builder.keySchema = keySchema;
        builder.valueSchema = valueSchema;
        return builder;
    }

    static SchemaBuilder arrayOfNull() {
        return new SchemaBuilder(Schema.Type.ARRAY);
    }

    static SchemaBuilder mapOfNull() {
        return new SchemaBuilder(Schema.Type.MAP);
    }

    static SchemaBuilder mapWithNullKeys(Schema valueSchema) {
        SchemaBuilder result = new SchemaBuilder(Schema.Type.MAP);
        result.valueSchema = valueSchema;
        return result;
    }

    static SchemaBuilder mapWithNullValues(Schema keySchema) {
        SchemaBuilder result = new SchemaBuilder(Schema.Type.MAP);
        result.keySchema = keySchema;
        return result;
    }

    @Override
    public Schema keySchema() {
        return this.keySchema;
    }

    @Override
    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Schema build() {
        return new ConnectSchema(this.type, this.isOptional(), this.defaultValue, this.name, this.version, this.doc, this.parameters == null ? null : Collections.unmodifiableMap(this.parameters), this.fields == null ? null : Collections.unmodifiableList(new ArrayList<Field>(this.fields.values())), this.keySchema, this.valueSchema);
    }

    @Override
    public Schema schema() {
        return this.build();
    }

    private static void checkCanSet(String fieldName, Object fieldVal, Object val) {
        if (fieldVal != null && fieldVal != val) {
            throw new SchemaBuilderException("Invalid SchemaBuilder call: " + fieldName + " has already been set.");
        }
    }

    private static void checkNotNull(String fieldName, Object val, String fieldToSet) {
        if (val == null) {
            throw new SchemaBuilderException("Invalid SchemaBuilder call: " + fieldName + " must be specified to set " + fieldToSet);
        }
    }
}

