/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.server.common.TransactionVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rusA\u0002%J\u0011\u0003IuJ\u0002\u0004R\u0013\"\u0005\u0011J\u0015\u0005\u00063\u0006!\ta\u0017\u0005\u00069\u0006!\t!\u0018\u0005\bM\u0006\t\n\u0011\"\u0001h\r\u0015\t\u0016\nA%v\u0011!aXA!b\u0001\n\u0003i\b\"CA\n\u000b\t\u0005\t\u0015!\u0003\u007f\u0011)\t)\"\u0002BA\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u00033)!\u00111A\u0005\u0002\u0005m\u0001\"CA\u0014\u000b\t\u0005\t\u0015)\u0003j\u0011)\tI#\u0002BA\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003W)!\u00111A\u0005\u0002\u00055\u0002\"CA\u0019\u000b\t\u0005\t\u0015)\u0003j\u0011)\t\u0019$\u0002BA\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003k)!\u00111A\u0005\u0002\u0005]\u0002\"CA\u001e\u000b\t\u0005\t\u0015)\u0003j\u0011%\u0011WA!a\u0001\n\u0003\ti\u0004\u0003\u0006\u0002@\u0015\u0011\t\u0019!C\u0001\u0003\u0003B\u0011\"!\u0012\u0006\u0005\u0003\u0005\u000b\u0015B2\t\u0015\u0005\u001dSA!a\u0001\n\u0003\ti\u0004\u0003\u0006\u0002J\u0015\u0011\t\u0019!C\u0001\u0003\u0017B\u0011\"a\u0014\u0006\u0005\u0003\u0005\u000b\u0015B2\t\u0015\u0005ESA!a\u0001\n\u0003\t\u0019\u0006\u0003\u0006\u0002\\\u0015\u0011\t\u0019!C\u0001\u0003;B!\"!\u0019\u0006\u0005\u0003\u0005\u000b\u0015BA+\u0011)\t\u0019'\u0002BA\u0002\u0013\u0005\u0011Q\r\u0005\u000b\u0003[*!\u00111A\u0005\u0002\u0005=\u0004BCA:\u000b\t\u0005\t\u0015)\u0003\u0002h!Q\u0011QO\u0003\u0003\u0006\u0004%\t!a\u001e\t\u0015\u0005}UA!A!\u0002\u0013\tI\b\u0003\u0006\u0002\"\u0016\u0011\t\u0019!C\u0001\u0003/A!\"a)\u0006\u0005\u0003\u0007I\u0011AAS\u0011%\tI+\u0002B\u0001B\u0003&\u0011\u000e\u0003\u0006\u00024\u0016\u0011\t\u0019!C\u0001\u0003/A!\"!.\u0006\u0005\u0003\u0007I\u0011AA\\\u0011%\tY,\u0002B\u0001B\u0003&\u0011\u000e\u0003\u0006\u0002@\u0016\u0011\t\u0019!C\u0001\u0003\u0003D!\"!5\u0006\u0005\u0003\u0007I\u0011AAj\u0011)\t9.\u0002B\u0001B\u0003&\u00111\u0019\u0005\u00073\u0016!\t!!7\t\u0013\u0005UX\u00011A\u0005\u0002\u0005]\b\"CA\u0000\u000b\u0001\u0007I\u0011\u0001B\u0001\u0011!\u0011)!\u0002Q!\n\u0005e\b\"\u0003B\u0004\u000b\u0001\u0007I\u0011\u0001B\u0005\u0011%\u0011Y!\u0002a\u0001\n\u0003\u0011i\u0001C\u0004\u0003\u0012\u0015\u0001\u000b\u0015\u00020\t\u0015\tMQA1A\u0005\u0002%\u0013)\u0002\u0003\u0005\u00030\u0015\u0001\u000b\u0011\u0002B\f\u0011\u001d\u0011\t$\u0002C\u0001\u0005gAqAa\u0016\u0006\t\u0003\u0011I\u0006C\u0004\u0003f\u0015!\tAa\u001a\t\u000f\t5T\u0001\"\u0001\u0003p!9!qO\u0003\u0005\u0002\t=\u0004b\u0002B=\u000b\u0011\u0005!1\u0010\u0005\b\u0005S+A\u0011\u0001BV\u0011\u001d\u0011I,\u0002C\u0001\u0005wCqAa4\u0006\t\u0003\u0011\t\u000eC\u0004\u0003b\u0016!\tAa9\t\u000f\t\u001dX\u0001\"\u0001\u0003p!9!\u0011^\u0003\u0005\u0002\t%\u0001b\u0002Bv\u000b\u0011%!\u0011\u0002\u0005\b\u0005[,A\u0011\u0002Bx\u0011\u001d\u0011i/\u0002C\u0005\u0007#Aqaa\n\u0006\t\u0003\u0019I\u0003C\u0004\u00040\u0015!Ia!\r\t\u000f\rUR\u0001\"\u0003\u00048!911H\u0003\u0005\n\ru\u0002bBB\"\u000b\u0011\u0005!\u0011\u0002\u0005\b\u0007\u000b*A\u0011IB$\u0011\u001d\u0019I%\u0002C!\u0007\u0017Bqa!\u0015\u0006\t\u0003\u001a\u0019&A\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018M\u0003\u0002K\u0017\u0006YAO]1og\u0006\u001cG/[8o\u0015\taU*A\u0006d_>\u0014H-\u001b8bi>\u0014(\"\u0001(\u0002\u000b-\fgm[1\u0011\u0005A\u000bQ\"A%\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0014\u0005\u0005\u0019\u0006C\u0001+X\u001b\u0005)&\"\u0001,\u0002\u000bM\u001c\u0017\r\\1\n\u0005a+&AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005y\u0015\u0001E5t\u000bB|7\r[#yQ\u0006,8\u000f^3e)\tq\u0016\r\u0005\u0002U?&\u0011\u0001-\u0016\u0002\b\u0005>|G.Z1o\u0011\u0015\u00117\u00011\u0001d\u00035\u0001(o\u001c3vG\u0016\u0014X\t]8dQB\u0011A\u000bZ\u0005\u0003KV\u0013Qa\u00155peR\fA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'F\u0001iU\tIG\u000e\u0005\u0002UU&\u00111.\u0016\u0002\u0005\u0019>twmK\u0001n!\tq7/D\u0001p\u0015\t\u0001\u0018/A\u0005v]\u000eDWmY6fI*\u0011!/V\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001;p\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\n\u0004\u000bM3\bCA<{\u001b\u0005A(BA=N\u0003\u0015)H/\u001b7t\u0013\tY\bPA\u0004M_\u001e<\u0017N\\4\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\u0012A \t\u0004\u007f\u00065a\u0002BA\u0001\u0003\u0013\u00012!a\u0001V\u001b\t\t)AC\u0002\u0002\bi\u000ba\u0001\u0010:p_Rt\u0014bAA\u0006+\u00061\u0001K]3eK\u001aLA!a\u0004\u0002\u0012\t11\u000b\u001e:j]\u001eT1!a\u0003V\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#\u0007%\u0001\u0006qe>$WoY3s\u0013\u0012,\u0012![\u0001\u000faJ|G-^2fe&#w\fJ3r)\u0011\ti\"a\t\u0011\u0007Q\u000by\"C\u0002\u0002\"U\u0013A!\u00168ji\"A\u0011QE\u0005\u0002\u0002\u0003\u0007\u0011.A\u0002yIE\n1\u0002\u001d:pIV\u001cWM]%eA\u0005\u0011\u0002O]3wS>,8\u000f\u0015:pIV\u001cWM]%e\u0003Y\u0001(/\u001a<j_V\u001c\bK]8ek\u000e,'/\u00133`I\u0015\fH\u0003BA\u000f\u0003_A\u0001\"!\n\r\u0003\u0003\u0005\r![\u0001\u0014aJ,g/[8vgB\u0013x\u000eZ;dKJLE\rI\u0001\u000f]\u0016DH\u000f\u0015:pIV\u001cWM]%e\u0003IqW\r\u001f;Qe>$WoY3s\u0013\u0012|F%Z9\u0015\t\u0005u\u0011\u0011\b\u0005\t\u0003Ky\u0011\u0011!a\u0001S\u0006ya.\u001a=u!J|G-^2fe&#\u0007%F\u0001d\u0003E\u0001(o\u001c3vG\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0005\u0003;\t\u0019\u0005\u0003\u0005\u0002&I\t\t\u00111\u0001d\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002\n\u0011\u0003\\1tiB\u0013x\u000eZ;dKJ,\u0005o\\2i\u0003Ua\u0017m\u001d;Qe>$WoY3s\u000bB|7\r[0%KF$B!!\b\u0002N!A\u0011QE\u000b\u0002\u0002\u0003\u00071-\u0001\nmCN$\bK]8ek\u000e,'/\u00129pG\"\u0004\u0013\u0001\u0004;y]RKW.Z8vi6\u001bXCAA+!\r!\u0016qK\u0005\u0004\u00033*&aA%oi\u0006\u0001B\u000f\u001f8US6,w.\u001e;Ng~#S-\u001d\u000b\u0005\u0003;\ty\u0006C\u0005\u0002&a\t\t\u00111\u0001\u0002V\u0005iA\u000f\u001f8US6,w.\u001e;Ng\u0002\nQa\u001d;bi\u0016,\"!a\u001a\u0011\u0007A\u000bI'C\u0002\u0002l%\u0013\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0002\u0013M$\u0018\r^3`I\u0015\fH\u0003BA\u000f\u0003cB\u0011\"!\n\u001c\u0003\u0003\u0005\r!a\u001a\u0002\rM$\u0018\r^3!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cXCAA=!\u0019\tY(!\"\u0002\n6\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)A\u0004nkR\f'\r\\3\u000b\u0007\u0005\rU+\u0001\u0006d_2dWm\u0019;j_:LA!a\"\u0002~\t\u00191+\u001a;\u0011\t\u0005-\u00151T\u0007\u0003\u0003\u001bSA!a$\u0002\u0012\u000611m\\7n_:T1ATAJ\u0015\u0011\t)*a&\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI*A\u0002pe\u001eLA!!(\u0002\u000e\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\:!\u0003E!\bP\\*uCJ$H+[7fgR\fW\u000e]\u0001\u0016ibt7\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\u0011\ti\"a*\t\u0011\u0005\u0015\u0002%!AA\u0002%\f!\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7qA!\u001a\u0011%!,\u0011\u0007Q\u000by+C\u0002\u00022V\u0013\u0001B^8mCRLG.Z\u0001\u0017ibtG*Y:u+B$\u0017\r^3US6,7\u000f^1na\u0006QB\u000f\u001f8MCN$X\u000b\u001d3bi\u0016$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011QDA]\u0011!\t)cIA\u0001\u0002\u0004I\u0017a\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9!Q\r!\u0013QV\u0001\u0019G2LWM\u001c;Ue\u0006t7/Y2uS>tg+\u001a:tS>tWCAAb!\u0011\t)-!4\u000e\u0005\u0005\u001d'\u0002BAH\u0003\u0013TA!a3\u0002\u0012\u000611/\u001a:wKJLA!a4\u0002H\n\u0011BK]1og\u0006\u001cG/[8o-\u0016\u00148/[8o\u0003q\u0019G.[3oiR\u0013\u0018M\\:bGRLwN\u001c,feNLwN\\0%KF$B!!\b\u0002V\"I\u0011Q\u0005\u0014\u0002\u0002\u0003\u0007\u00111Y\u0001\u001aG2LWM\u001c;Ue\u0006t7/Y2uS>tg+\u001a:tS>t\u0007\u0005\u0006\u000e\u0002\\\u0006u\u0017q\\Aq\u0003G\f)/a:\u0002j\u0006-\u0018Q^Ax\u0003c\f\u0019\u0010\u0005\u0002Q\u000b!)A\u0010\u000ba\u0001}\"1\u0011Q\u0003\u0015A\u0002%Da!!\u000b)\u0001\u0004I\u0007BBA\u001aQ\u0001\u0007\u0011\u000eC\u0003cQ\u0001\u00071\r\u0003\u0004\u0002H!\u0002\ra\u0019\u0005\b\u0003#B\u0003\u0019AA+\u0011\u001d\t\u0019\u0007\u000ba\u0001\u0003OBq!!\u001e)\u0001\u0004\tI\b\u0003\u0005\u0002\"\"\u0002\n\u00111\u0001j\u0011\u0019\t\u0019\f\u000ba\u0001S\"9\u0011q\u0018\u0015A\u0002\u0005\r\u0017\u0001\u00049f]\u0012LgnZ*uCR,WCAA}!\u0015!\u00161`A4\u0013\r\ti0\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002!A,g\u000eZ5oON#\u0018\r^3`I\u0015\fH\u0003BA\u000f\u0005\u0007A\u0011\"!\n+\u0003\u0003\u0005\r!!?\u0002\u001bA,g\u000eZ5oON#\u0018\r^3!\u0003MA\u0017m\u001d$bS2,G-\u00129pG\"4UM\\2f+\u0005q\u0016a\u00065bg\u001a\u000b\u0017\u000e\\3e\u000bB|7\r\u001b$f]\u000e,w\fJ3r)\u0011\tiBa\u0004\t\u0011\u0005\u0015R&!AA\u0002y\u000bA\u0003[1t\r\u0006LG.\u001a3Fa>\u001c\u0007NR3oG\u0016\u0004\u0013\u0001\u00027pG.,\"Aa\u0006\u0011\t\te!1F\u0007\u0003\u00057QAA!\b\u0003 \u0005)An\\2lg*!!\u0011\u0005B\u0012\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0005K\u00119#\u0001\u0003vi&d'B\u0001B\u0015\u0003\u0011Q\u0017M^1\n\t\t5\"1\u0004\u0002\u000e%\u0016,g\u000e\u001e:b]RdunY6\u0002\u000b1|7m\u001b\u0011\u0002\r%tGj\\2l+\u0011\u0011)Da\u000f\u0015\t\t]\"Q\n\t\u0005\u0005s\u0011Y\u0004\u0004\u0001\u0005\u000f\tu\u0012G1\u0001\u0003@\t\tA+\u0005\u0003\u0003B\t\u001d\u0003c\u0001+\u0003D%\u0019!QI+\u0003\u000f9{G\u000f[5oOB\u0019AK!\u0013\n\u0007\t-SKA\u0002B]fD\u0001Ba\u00142\t\u0003\u0007!\u0011K\u0001\u0004MVt\u0007#\u0002+\u0003T\t]\u0012b\u0001B++\nAAHY=oC6,g(A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003;\u0011Y\u0006C\u0004\u0003^I\u0002\rAa\u0018\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0004\u0003b\t\r\u0014\u0011R\u0007\u0003\u0003\u0003KA!a\"\u0002\u0002\u0006y!/Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0003\u0002\u001e\t%\u0004b\u0002B6g\u0001\u0007\u0011\u0011R\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0003A\u0001(/\u001a9be\u0016tu\u000e\u0016:b]NLG\u000f\u0006\u0002\u0003rA\u0019\u0001Ka\u001d\n\u0007\tU\u0014J\u0001\nUq:$&/\u00198tSRlU\r^1eCR\f\u0017!\u00079sKB\f'/\u001a$f]\u000e,\u0007K]8ek\u000e,'/\u00129pG\"\fQ\u0004\u001d:fa\u0006\u0014X-\u00138de\u0016lWM\u001c;Qe>$WoY3s\u000bB|7\r\u001b\u000b\t\u0005{\u0012YJa(\u0003&BA!q\u0010BE\u0005\u001f\u0013\tH\u0004\u0003\u0003\u0002\n\u0015e\u0002BA\u0002\u0005\u0007K\u0011AV\u0005\u0004\u0005\u000f+\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005\u0017\u0013iI\u0001\u0004FSRDWM\u001d\u0006\u0004\u0005\u000f+\u0006\u0003\u0002BI\u0005/k!Aa%\u000b\t\tU\u0015QR\u0001\taJ|Go\\2pY&!!\u0011\u0014BJ\u0005\u0019)%O]8sg\"9!Q\u0014\u001cA\u0002\u0005U\u0013a\u00048foRCh\u000eV5nK>,H/T:\t\u000f\t\u0005f\u00071\u0001\u0003$\u0006)R\r\u001f9fGR,G\r\u0015:pIV\u001cWM]#q_\u000eD\u0007\u0003\u0002+\u0002|\u000eDaAa*7\u0001\u0004I\u0017aD;qI\u0006$X\rV5nKN$\u0018-\u001c9\u00023A\u0014X\r]1sKB\u0013x\u000eZ;dKJLEMU8uCRLwN\u001c\u000b\u000b\u0005c\u0012iK!-\u00034\nU\u0006B\u0002BXo\u0001\u0007\u0011.A\u0007oK^\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\b\u0005;;\u0004\u0019AA+\u0011\u0019\u00119k\u000ea\u0001S\"1!qW\u001cA\u0002y\u000bqB]3d_J$G*Y:u\u000bB|7\r[\u0001\u0015aJ,\u0007/\u0019:f\u0003\u0012$\u0007+\u0019:uSRLwN\\:\u0015\u0011\tE$Q\u0018Bf\u0005\u001bDqAa09\u0001\u0004\u0011\t-\u0001\u000bbI\u0012,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005\u0007\u0014I-!#\u000e\u0005\t\u0015'\u0002\u0002Bd\u0003\u0003\u000b\u0011\"[7nkR\f'\r\\3\n\t\u0005\u001d%Q\u0019\u0005\u0007\u0005OC\u0004\u0019A5\t\u000f\u0005}\u0006\b1\u0001\u0002D\u0006!\u0002O]3qCJ,\u0017IY8si>\u00138i\\7nSR$BB!\u001d\u0003T\n]'\u0011\u001cBn\u0005;DqA!6:\u0001\u0004\t9'\u0001\u0005oK^\u001cF/\u0019;f\u0011\u001d\ty,\u000fa\u0001\u0003\u0007Da!a\r:\u0001\u0004I\u0007B\u0002BTs\u0001\u0007\u0011\u000e\u0003\u0004\u0003`f\u0002\rAX\u0001\u0011]>\u0004\u0016M\u001d;ji&|g.\u00113eK\u0012\fq\u0002\u001d:fa\u0006\u0014XmQ8na2,G/\u001a\u000b\u0005\u0005c\u0012)\u000f\u0003\u0004\u0003(j\u0002\r![\u0001\faJ,\u0007/\u0019:f\t\u0016\fG-\u0001\rjgB\u0013x\u000eZ;dKJ,\u0005o\\2i\u000bbD\u0017-^:uK\u0012\fQ\u0003[1t!\u0016tG-\u001b8h)J\fgn]1di&|g.A\nqe\u0016\u0004\u0018M]3Ue\u0006t7/\u001b;j_:$v\u000e\u0006\u000b\u0003r\tE(Q\u001fB}\u0005{\u001c\ta!\u0002\u0004\n\r51q\u0002\u0005\b\u0005gt\u0004\u0019AA4\u00031)\b\u000fZ1uK\u0012\u001cF/\u0019;f\u0011\u0019\u00119P\u0010a\u0001S\u0006\tR\u000f\u001d3bi\u0016$\u0007K]8ek\u000e,'/\u00133\t\r\tmh\b1\u0001d\u00031)\b\u000fZ1uK\u0012,\u0005o\\2i\u0011\u0019\u0011yP\u0010a\u0001G\u0006\u0001R\u000f\u001d3bi\u0016$G*Y:u\u000bB|7\r\u001b\u0005\b\u0007\u0007q\u0004\u0019AA+\u0003M)\b\u000fZ1uK\u0012$\u0006P\u001c+j[\u0016|W\u000f^'t\u0011\u001d\u00199A\u0010a\u0001\u0005\u0003\fa#\u001e9eCR,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0007\u0007\u0017q\u0004\u0019A5\u00021U\u0004H-\u0019;fIRChn\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0004\u0003(z\u0002\r!\u001b\u0005\b\u0003\u007fs\u0004\u0019AAb)Y\u0011\tha\u0005\u0004\u0016\r]1\u0011DB\u000e\u0007;\u0019yb!\t\u0004$\r\u0015\u0002b\u0002Bz\u007f\u0001\u0007\u0011q\r\u0005\u0007\u0005o|\u0004\u0019A5\t\r\u0005Mr\b1\u0001j\u0011\u0019\u0011Yp\u0010a\u0001G\"1!q` A\u0002\rDqaa\u0001@\u0001\u0004\t)\u0006C\u0004\u0004\b}\u0002\rA!1\t\r\r-q\b1\u0001j\u0011\u0019\u00119k\u0010a\u0001S\"9\u0011qX A\u0002\u0005\r\u0017\u0001F2p[BdW\r^3Ue\u0006t7/\u001b;j_:$v\u000e\u0006\u0003\u0002\u001e\r-\u0002bBB\u0017\u0001\u0002\u0007!\u0011O\u0001\u0010iJ\fgn]5u\u001b\u0016$\u0018\rZ1uC\u0006\u0011b/\u00197jIB\u0013x\u000eZ;dKJ,\u0005o\\2i)\rq61\u0007\u0005\b\u0007[\t\u0005\u0019\u0001B9\u0003Y1\u0018\r\\5e!J|G-^2fe\u0016\u0003xn\u00195Ck6\u0004Hc\u00010\u0004:!91Q\u0006\"A\u0002\tE\u0014a\u0007;ie><8\u000b^1uKR\u0013\u0018M\\:ji&|gNR1jYV\u0014X\r\u0006\u0003\u0002\u001e\r}\u0002bBB!\u0007\u0002\u0007!\u0011O\u0001\u0013ibtGK]1og&$X*\u001a;bI\u0006$\u0018-A\u000eqK:$\u0017N\\4Ue\u0006t7/\u001b;j_:Le\u000e\u0015:pOJ,7o]\u0001\ti>\u001cFO]5oOR\ta0\u0001\u0004fcV\fGn\u001d\u000b\u0004=\u000e5\u0003bBB(\r\u0002\u0007!qI\u0001\u0005i\"\fG/\u0001\u0005iCND7i\u001c3f)\t\t)\u0006K\u0002\u0006\u0007/\u00022a^B-\u0013\r\u0019Y\u0006\u001f\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private long previousProducerId;
    private long nextProducerId;
    private short producerEpoch;
    private short lastProducerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private TransactionVersion clientTransactionVersion;
    private Option<TransactionState> pendingState;
    private boolean hasFailedEpochFence;
    private final ReentrantLock lock;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$10() {
        return -1L;
    }

    public static boolean isEpochExhausted(short producerEpoch) {
        return TransactionMetadata$.MODULE$.isEpochExhausted(producerEpoch);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public long previousProducerId() {
        return this.previousProducerId;
    }

    public void previousProducerId_$eq(long x$1) {
        this.previousProducerId = x$1;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public short lastProducerEpoch() {
        return this.lastProducerEpoch;
    }

    public void lastProducerEpoch_$eq(short x$1) {
        this.lastProducerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public TransactionVersion clientTransactionVersion() {
        return this.clientTransactionVersion;
    }

    public void clientTransactionVersion_$eq(TransactionVersion x$1) {
        this.clientTransactionVersion = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public boolean hasFailedEpochFence() {
        return this.hasFailedEpochFence;
    }

    public void hasFailedEpochFence_$eq(boolean x$1) {
        this.hasFailedEpochFence = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        Object object;
        ReentrantLock inLock_lock = this.lock();
        inLock_lock.lock();
        try {
            object = fun.apply();
        }
        finally {
            inLock_lock.unlock();
        }
        return (T)object;
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null || !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null || !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException("Transaction metadata's current state is " + this.state() + ", and its pending state is " + this.pendingState() + " while trying to remove partitions whose txn marker has been sent, this is not expected");
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.previousProducerId(), this.nextProducerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp(), this.clientTransactionVersion());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException("Cannot fence producer with epoch equal to Short.MaxValue since this would overflow");
        }
        short bumpedEpoch = this.hasFailedEpochFence() ? this.producerEpoch() : (short)(this.producerEpoch() + 1);
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), bumpedEpoch, (short)-1, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp(), this.clientTransactionVersion());
    }

    public Either<Errors, TxnTransitMetadata> prepareIncrementProducerEpoch(int newTxnTimeoutMs, Option<Object> expectedProducerEpoch, long updateTimestamp) {
        Tuple2 tuple2;
        Right right;
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException("Cannot allocate any more producer epochs for producerId " + this.producerId());
        }
        short bumpedEpoch = (short)(this.producerEpoch() + 1);
        if (None$.MODULE$.equals(expectedProducerEpoch)) {
            right = new Right((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)-1)));
        } else if (expectedProducerEpoch instanceof Some) {
            short expectedEpoch = BoxesRunTime.unboxToShort((Object)((Some)expectedProducerEpoch).value());
            if (this.producerEpoch() == -1 || expectedEpoch == this.producerEpoch()) {
                right = new Right((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)bumpedEpoch), (Object)BoxesRunTime.boxToShort((short)this.producerEpoch())));
            } else if (expectedEpoch == this.lastProducerEpoch()) {
                right = new Right((Object)new Tuple2((Object)BoxesRunTime.boxToShort((short)this.producerEpoch()), (Object)BoxesRunTime.boxToShort((short)this.lastProducerEpoch())));
            } else {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Expected producer epoch " + expectedEpoch + " does not match current producer epoch " + this.producerEpoch() + " or previous producer epoch " + this.lastProducerEpoch());
                right = new Left((Object)Errors.PRODUCER_FENCED);
            }
        } else {
            throw new MatchError(expectedProducerEpoch);
        }
        Right epochBumpResult = right;
        if (epochBumpResult instanceof Right && (tuple2 = (Tuple2)epochBumpResult.value()) != null) {
            short nextEpoch = BoxesRunTime.unboxToShort((Object)tuple2._1());
            short lastEpoch = BoxesRunTime.unboxToShort((Object)tuple2._2());
            return new Right((Object)this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), nextEpoch, lastEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp, this.clientTransactionVersion()));
        }
        if (epochBumpResult instanceof Left) {
            Errors err = (Errors)((Left)epochBumpResult).value();
            return new Left((Object)err);
        }
        throw new MatchError((Object)epochBumpResult);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp, boolean recordLastEpoch) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, recordLastEpoch ? (short)this.producerEpoch() : (short)-1, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp, this.clientTransactionVersion());
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp, TransactionVersion clientTransactionVersion) {
        TransactionState transactionState = this.state();
        long newTxnStartTimestamp = (Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState))) ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), newTxnStartTimestamp, updateTimestamp, clientTransactionVersion);
    }

    /*
     * WARNING - void declaration
     */
    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, TransactionVersion clientTransactionVersion, long nextProducerId, long updateTimestamp, boolean noPartitionAdded) {
        void var8_7;
        short s;
        short s2;
        if (clientTransactionVersion.supportsEpochBump()) {
            s2 = (short)(this.producerEpoch() + 1);
            s = this.producerEpoch();
        } else {
            s2 = this.producerEpoch();
            s = this.lastProducerEpoch();
        }
        short s3 = s;
        short updatedProducerEpoch = s2;
        long newTxnStartTimestamp = noPartitionAdded ? updateTimestamp : this.txnStartTimestamp();
        return this.prepareTransitionTo(newState, this.producerId(), nextProducerId, (short)var8_7, s3, this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), newTxnStartTimestamp, updateTimestamp, clientTransactionVersion);
    }

    /*
     * WARNING - void declaration
     */
    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        void var5_5;
        short s;
        long l;
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        CompleteAbort$ newState = transactionState != null && transactionState.equals(prepareCommit$) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        this.hasFailedEpochFence_$eq(false);
        if (this.clientTransactionVersion().supportsEpochBump() && this.nextProducerId() != -1L) {
            l = this.nextProducerId();
            s = (short)0;
        } else {
            l = this.producerId();
            s = this.producerEpoch();
        }
        short s2 = s;
        long updatedProducerId = l;
        return this.prepareTransitionTo(newState, (long)var5_5, -1L, s2, this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp, this.clientTransactionVersion());
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.lastProducerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp(), this.clientTransactionVersion());
    }

    public boolean isProducerEpochExhausted() {
        return TransactionMetadata$.MODULE$.isEpochExhausted(this.producerEpoch());
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        return Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState updatedState, long updatedProducerId, short updatedEpoch, short updatedLastEpoch, int updatedTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> updatedTopicPartitions, long updatedTxnStartTimestamp, long updateTimestamp, TransactionVersion clientTransactionVersion) {
        return this.prepareTransitionTo(updatedState, updatedProducerId, -1L, updatedEpoch, updatedLastEpoch, updatedTxnTimeoutMs, updatedTopicPartitions, updatedTxnStartTimestamp, updateTimestamp, clientTransactionVersion);
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState updatedState, long updatedProducerId, long nextProducerId, short updatedEpoch, short updatedLastEpoch, int updatedTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> updatedTopicPartitions, long updatedTxnStartTimestamp, long updateTimestamp, TransactionVersion clientTransactionVersion) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException("Preparing transaction state transition to " + updatedState + " while it already a pending state " + this.pendingState().get());
        }
        if (updatedProducerId < 0L) {
            throw new IllegalArgumentException("Illegal new producer id " + updatedProducerId);
        }
        TransactionState transactionState = updatedState;
        Dead$ dead$ = Dead$.MODULE$;
        if (!(transactionState != null && transactionState.equals(dead$) || updatedEpoch >= 0)) {
            throw new IllegalArgumentException("Illegal new producer epoch " + updatedEpoch);
        }
        if (updatedState.validPreviousStates().contains((Object)this.state())) {
            TxnTransitMetadata transitMetadata = new TxnTransitMetadata(updatedProducerId, this.producerId(), nextProducerId, updatedEpoch, updatedLastEpoch, updatedTxnTimeoutMs, updatedState, updatedTopicPartitions, updatedTxnStartTimestamp, updateTimestamp, clientTransactionVersion);
            this.debug((Function0<String>)(Function0 & Serializable)() -> "TransactionalId " + this.transactionalId() + " prepare transition from " + this.state() + " to " + transitMetadata);
            this.pendingState_$eq((Option<TransactionState>)new Some((Object)updatedState));
            return transitMetadata;
        }
        throw new IllegalStateException("Preparing transaction state transition to " + updatedState + " failed since the target state " + updatedState + " is not a valid previous state of the current state " + this.state());
    }

    /*
     * Unable to fully structure code
     */
    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        block19: {
            block21: {
                block20: {
                    block18: {
                        v0 = toState = (TransactionState)this.pendingState().getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$1(kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()Lscala/runtime/Nothing$;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
                        var3_3 = transitMetadata.txnState();
                        if (v0 == null ? var3_3 != null : v0.equals(var3_3) == false) {
                            this.throwStateTransitionFailure(transitMetadata);
                            return;
                        }
                        if (!Empty$.MODULE$.equals(toState)) break block18;
                        if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                            this.throwStateTransitionFailure(transitMetadata);
                        } else {
                            this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                            this.producerEpoch_$eq(transitMetadata.producerEpoch());
                            this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                            this.producerId_$eq(transitMetadata.producerId());
                            this.previousProducerId_$eq(transitMetadata.prevProducerId());
                        }
                        break block19;
                    }
                    if (!Ongoing$.MODULE$.equals(toState)) break block20;
                    if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs()) {
                        this.throwStateTransitionFailure(transitMetadata);
                    } else {
                        this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                        this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
                    }
                    break block19;
                }
                if (!(PrepareAbort$.MODULE$.equals(toState) != false ? true : PrepareCommit$.MODULE$.equals(toState) != false)) break block21;
                v1 = toState;
                var5_4 = PrepareAbort$.MODULE$;
                if (v1 == null || !v1.equals(var5_4) || !transitMetadata.clientTransactionVersion().supportsEpochBump()) ** GOTO lbl-1000
                v2 = this.state();
                var6_5 = Empty$.MODULE$;
                if (v2 != null && v2.equals(var6_5)) ** GOTO lbl-1000
                v3 = this.state();
                var7_6 = CompleteCommit$.MODULE$;
                if (v3 != null && v3.equals(var7_6)) ** GOTO lbl-1000
                v4 = this.state();
                var8_7 = CompleteAbort$.MODULE$;
                if (v4 != null && v4.equals(var8_7)) lbl-1000:
                // 3 sources

                {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = false;
                }
                allowedEmptyAbort = v5;
                v6 = validTimestamp = this.txnStartTimestamp() == transitMetadata.txnStartTimestamp() || allowedEmptyAbort != false;
                if (!(this.validProducerEpoch(transitMetadata) && this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) && this.txnTimeoutMs() == transitMetadata.txnTimeoutMs() && validTimestamp)) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else if (transitMetadata.clientTransactionVersion().supportsEpochBump()) {
                    this.producerEpoch_$eq(transitMetadata.producerEpoch());
                    this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                    this.nextProducerId_$eq(transitMetadata.nextProducerId());
                    this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                }
                break block19;
            }
            if (CompleteAbort$.MODULE$.equals(toState) != false ? true : CompleteCommit$.MODULE$.equals(toState) != false) {
                if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                } else {
                    this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                    this.topicPartitions().clear();
                    if (transitMetadata.clientTransactionVersion().supportsEpochBump()) {
                        this.producerEpoch_$eq(transitMetadata.producerEpoch());
                        this.lastProducerEpoch_$eq(transitMetadata.lastProducerEpoch());
                        this.previousProducerId_$eq(transitMetadata.prevProducerId());
                        this.producerId_$eq(transitMetadata.producerId());
                        this.nextProducerId_$eq(transitMetadata.nextProducerId());
                    }
                }
            } else if (PrepareEpochFence$.MODULE$.equals(toState)) {
                this.throwStateTransitionFailure(transitMetadata);
            } else {
                if (Dead$.MODULE$.equals(toState)) {
                    throw new IllegalStateException("TransactionalId " + this.transactionalId() + " is trying to complete a transition to " + toState + ". This means that the transactionalId was being expired, and the only acceptable completion of this operation is to remove the transaction metadata from the cache, not to persist the " + toState + " in the log.");
                }
                throw new MatchError((Object)toState);
            }
        }
        this.debug((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$completeTransitionTo$3(kafka.coordinator.transaction.TransactionMetadata kafka.coordinator.transaction.TxnTransitMetadata ), ()Ljava/lang/String;)((TransactionMetadata)this, (TxnTransitMetadata)transitMetadata));
        this.clientTransactionVersion_$eq(transitMetadata.clientTransactionVersion());
        this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
        this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
        this.state_$eq(toState);
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        boolean isAtLeastTransactionsV2 = transitMetadata.clientTransactionVersion().supportsEpochBump();
        TransactionState txnState = transitMetadata.txnState();
        short transitProducerEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        short transitLastProducerEpoch = transitMetadata.lastProducerEpoch();
        if (isAtLeastTransactionsV2 && (CompleteCommit$.MODULE$.equals(txnState) ? true : CompleteAbort$.MODULE$.equals(txnState)) && transitProducerEpoch == (short)0) {
            return transitLastProducerEpoch == this.lastProducerEpoch() && transitMetadata.prevProducerId() == this.producerId();
        }
        if (isAtLeastTransactionsV2 && (PrepareCommit$.MODULE$.equals(txnState) ? true : PrepareAbort$.MODULE$.equals(txnState))) {
            return transitLastProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
        }
        return transitProducerEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable)() -> this.toString() + "'s transition to " + txnTransitMetadata + " failed: this should not happen");
        throw new IllegalStateException("TransactionalId " + this.transactionalId() + " failed transition to state " + txnTransitMetadata + " due to unexpected metadata");
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return "TransactionMetadata(transactionalId=" + this.transactionalId() + ", producerId=" + this.producerId() + ", previousProducerId=" + this.previousProducerId() + ", nextProducerId=" + this.nextProducerId() + ", producerEpoch=" + this.producerEpoch() + ", lastProducerEpoch=" + this.lastProducerEpoch() + ", txnTimeoutMs=" + this.txnTimeoutMs() + ", state=" + this.state() + ", pendingState=" + this.pendingState() + ", topicPartitions=" + this.topicPartitions() + ", txnStartTimestamp=" + this.txnStartTimestamp() + ", txnLastUpdateTimestamp=" + this.txnLastUpdateTimestamp() + ", clientTransactionVersion=" + this.clientTransactionVersion() + ")";
    }

    public boolean equals(Object that) {
        if (that instanceof TransactionMetadata) {
            TransactionMetadata transactionMetadata = (TransactionMetadata)that;
            String string = this.transactionalId();
            String string2 = transactionMetadata.transactionalId();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (this.producerId() == transactionMetadata.producerId() && this.producerEpoch() == transactionMetadata.producerEpoch() && this.lastProducerEpoch() == transactionMetadata.lastProducerEpoch() && this.txnTimeoutMs() == transactionMetadata.txnTimeoutMs() && this.state().equals(transactionMetadata.state()) && this.topicPartitions().equals(transactionMetadata.topicPartitions()) && this.txnStartTimestamp() == transactionMetadata.txnStartTimestamp() && this.txnLastUpdateTimestamp() == transactionMetadata.txnLastUpdateTimestamp()) {
                    TransactionVersion transactionVersion = this.clientTransactionVersion();
                    TransactionVersion transactionVersion2 = transactionMetadata.clientTransactionVersion();
                    if (!(transactionVersion != null ? !transactionVersion.equals(transactionVersion2) : transactionVersion2 != null)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp()), this.clientTransactionVersion()}))).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.hashCode()))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(a, b) -> 31 * a + b));
    }

    public static final /* synthetic */ Nothing$ $anonfun$completeTransitionTo$1(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        $this.fatal((Function0<String>)(Function0 & Serializable)() -> $this + "'s transition to " + transitMetadata$2 + " failed since pendingState is not defined: this should not happen");
        throw new IllegalStateException("TransactionalId " + $this.transactionalId() + " completing transaction state transition while it does not have a pending state");
    }

    public static final /* synthetic */ String $anonfun$completeTransitionTo$3(TransactionMetadata $this, TxnTransitMetadata transitMetadata$2) {
        return "TransactionalId " + $this.transactionalId() + " complete transition from " + $this.state() + " to " + transitMetadata$2;
    }

    public TransactionMetadata(String transactionalId, long producerId, long previousProducerId, long nextProducerId, short producerEpoch, short lastProducerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp, TransactionVersion clientTransactionVersion) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.previousProducerId = previousProducerId;
        this.nextProducerId = nextProducerId;
        this.producerEpoch = producerEpoch;
        this.lastProducerEpoch = lastProducerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        this.clientTransactionVersion = clientTransactionVersion;
        this.pendingState = None$.MODULE$;
        this.hasFailedEpochFence = false;
        this.lock = new ReentrantLock();
    }
}

