/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import kafka.log.remote.RemoteLogManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicRemoteLogConfig$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import scala.Function0;
import scala.Predef$;
import scala.collection.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00114A\u0001D\u0007\u0001%!Aa\u0002\u0001B\u0001B\u0003%1\u0005C\u0003'\u0001\u0011\u0005q\u0005C\u0003+\u0001\u0011\u00053\u0006C\u0003>\u0001\u0011\u0005c\bC\u0003H\u0001\u0011\u0005\u0003\nC\u0003M\u0001\u0011%QjB\u0003V\u001b!\u0005aKB\u0003\r\u001b!\u0005q\u000bC\u0003'\u0011\u0011\u0005\u0001\fC\u0004Z\u0011\t\u0007I\u0011\u0001.\t\r\rD\u0001\u0015!\u0003\\\u0005Y!\u0015P\\1nS\u000e\u0014V-\\8uK2{wmQ8oM&<'B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0019\u0012$\b\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iYR\"A\u0007\n\u0005qi!\u0001\u0006\"s_.,'OU3d_:4\u0017nZ;sC\ndW\r\u0005\u0002\u001fC5\tqD\u0003\u0002!\u001f\u0005)Q\u000f^5mg&\u0011!e\b\u0002\b\u0019><w-\u001b8h!\tQB%\u0003\u0002&\u001b\tY1*\u00194lC\n\u0013xn[3s\u0003\u0019a\u0014N\\5u}Q\u0011\u0001&\u000b\t\u00035\u0001AQA\u0004\u0002A\u0002\r\nQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/F\u0001-!\ri\u0003GM\u0007\u0002])\u0011q&F\u0001\u000bG>dG.Z2uS>t\u0017BA\u0019/\u0005\r\u0019V\r\u001e\t\u0003gir!\u0001\u000e\u001d\u0011\u0005U*R\"\u0001\u001c\u000b\u0005]\n\u0012A\u0002\u001fs_>$h(\u0003\u0002:+\u00051\u0001K]3eK\u001aL!a\u000f\u001f\u0003\rM#(/\u001b8h\u0015\tIT#A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R\u0011qH\u0011\t\u0003)\u0001K!!Q\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0007\u0012\u0001\r\u0001R\u0001\n]\u0016<8i\u001c8gS\u001e\u0004\"AG#\n\u0005\u0019k!aC&bM.\f7i\u001c8gS\u001e\f1B]3d_:4\u0017nZ;sKR\u0019q(S&\t\u000b)+\u0001\u0019\u0001#\u0002\u0013=dGmQ8oM&<\u0007\"B\"\u0006\u0001\u0004!\u0015\u0001C4fiZ\u000bG.^3\u0015\u00079\u000b6\u000b\u0005\u0002\u0015\u001f&\u0011\u0001+\u0006\u0002\u0005\u0019>tw\rC\u0003S\r\u0001\u0007A)\u0001\u0004d_:4\u0017n\u001a\u0005\u0006)\u001a\u0001\rAM\u0001\u0005]\u0006lW-\u0001\fEs:\fW.[2SK6|G/\u001a'pO\u000e{gNZ5h!\tQ\u0002b\u0005\u0002\t'Q\ta+A\u000bSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0003m\u00032!\f\u0019]!\ti&-D\u0001_\u0015\ty\u0006-\u0001\u0003mC:<'\"A1\u0002\t)\fg/Y\u0005\u0003wy\u000baCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\t")
public class DynamicRemoteLogConfig
implements BrokerReconfigurable,
Logging {
    private final KafkaBroker server;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicRemoteLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicRemoteLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        newConfig.values().forEach((k, v) -> {
            long oldValue;
            long newValue;
            if (("remote.log.index.file.cache.total.size.bytes".equals(k) || "remote.log.manager.copy.max.bytes.per.second".equals(k) || "remote.log.manager.fetch.max.bytes.per.second".equals(k)) && (newValue = BoxesRunTime.unboxToLong((Object)v)) != (oldValue = this.getValue($this.server.config(), (String)k)) && newValue <= 0L) {
                String errorMsg = "Dynamic remote log manager config update validation failed for " + k + "=" + v;
                throw new ConfigException(errorMsg + ", value should be at least 1");
            }
            if ("remote.log.reader.threads".equals(k) || "remote.log.manager.copier.thread.pool.size".equals(k) || "remote.log.manager.expiration.thread.pool.size".equals(k)) {
                int newValue2 = BoxesRunTime.unboxToInt((Object)v);
                Integer oldValue2 = $this.server.config().getInt((String)k);
                if (!BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)newValue2), (Object)oldValue2)) {
                    String errorMsg = "Dynamic thread count update validation failed for " + k + "=" + v;
                    if (newValue2 <= 0) {
                        throw new ConfigException(errorMsg + ", value should be at least 1");
                    }
                    if (newValue2 < Predef$.MODULE$.Integer2int(oldValue2) / 2) {
                        throw new ConfigException(errorMsg + ", value should be at least half the current value " + oldValue2);
                    }
                    if (newValue2 > Predef$.MODULE$.Integer2int(oldValue2) * 2) {
                        throw new ConfigException(errorMsg + ", value should not be greater than double the current value " + oldValue2);
                    }
                    return;
                }
                return;
            }
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        if (this.server.remoteLogManagerOpt().nonEmpty()) {
            RemoteLogManager remoteLogManager = (RemoteLogManager)this.server.remoteLogManagerOpt().get();
            if (DynamicRemoteLogConfig.isChangedLongValue$1("remote.log.index.file.cache.total.size.bytes", oldConfig, newConfig)) {
                String oldLongValue$1_k = "remote.log.index.file.cache.total.size.bytes";
                Object var18_4 = null;
                long oldValue = Predef$.MODULE$.Long2long(oldConfig.getLong(oldLongValue$1_k));
                String newLongValue$1_k = "remote.log.index.file.cache.total.size.bytes";
                Object var19_6 = null;
                long newValue = Predef$.MODULE$.Long2long(newConfig.getLong(newLongValue$1_k));
                remoteLogManager.resizeCacheSize(newValue);
                this.info((Function0<String>)(Function0 & Serializable)() -> "Dynamic remote log manager config: remote.log.index.file.cache.total.size.bytes updated, old value: " + oldValue + ", new value: " + newValue);
            }
            if (DynamicRemoteLogConfig.isChangedLongValue$1("remote.log.manager.copy.max.bytes.per.second", oldConfig, newConfig)) {
                String oldLongValue$1_k = "remote.log.manager.copy.max.bytes.per.second";
                Object var20_8 = null;
                long oldValue = Predef$.MODULE$.Long2long(oldConfig.getLong(oldLongValue$1_k));
                String newLongValue$1_k = "remote.log.manager.copy.max.bytes.per.second";
                Object var21_10 = null;
                long newValue = Predef$.MODULE$.Long2long(newConfig.getLong(newLongValue$1_k));
                remoteLogManager.updateCopyQuota(newValue);
                this.info((Function0<String>)(Function0 & Serializable)() -> "Dynamic remote log manager config: remote.log.manager.copy.max.bytes.per.second updated, old value: " + oldValue + ", new value: " + newValue);
            }
            if (DynamicRemoteLogConfig.isChangedLongValue$1("remote.log.manager.fetch.max.bytes.per.second", oldConfig, newConfig)) {
                String oldLongValue$1_k = "remote.log.manager.fetch.max.bytes.per.second";
                Object var22_12 = null;
                long oldValue = Predef$.MODULE$.Long2long(oldConfig.getLong(oldLongValue$1_k));
                String newLongValue$1_k = "remote.log.manager.fetch.max.bytes.per.second";
                Object var23_14 = null;
                long newValue = Predef$.MODULE$.Long2long(newConfig.getLong(newLongValue$1_k));
                remoteLogManager.updateFetchQuota(newValue);
                this.info((Function0<String>)(Function0 & Serializable)() -> "Dynamic remote log manager config: remote.log.manager.fetch.max.bytes.per.second updated, old value: " + oldValue + ", new value: " + newValue);
            }
            RemoteLogManagerConfig newRLMConfig = newConfig.remoteLogManagerConfig();
            RemoteLogManagerConfig oldRLMConfig = oldConfig.remoteLogManagerConfig();
            if (newRLMConfig.remoteLogManagerCopierThreadPoolSize() != oldRLMConfig.remoteLogManagerCopierThreadPoolSize()) {
                remoteLogManager.resizeCopierThreadPool(newRLMConfig.remoteLogManagerCopierThreadPoolSize());
            }
            if (newRLMConfig.remoteLogManagerExpirationThreadPoolSize() != oldRLMConfig.remoteLogManagerExpirationThreadPoolSize()) {
                remoteLogManager.resizeExpirationThreadPool(newRLMConfig.remoteLogManagerExpirationThreadPoolSize());
            }
            if (newRLMConfig.remoteLogReaderThreads() != oldRLMConfig.remoteLogReaderThreads()) {
                remoteLogManager.resizeReaderThreadPool(newRLMConfig.remoteLogReaderThreads());
                return;
            }
            return;
        }
    }

    private long getValue(KafkaConfig config, String name) {
        block8: {
            switch (name == null ? 0 : name.hashCode()) {
                case -446082792: {
                    if ("remote.log.manager.copy.max.bytes.per.second".equals(name)) {
                        break;
                    }
                    break block8;
                }
                case 594927576: {
                    if ("remote.log.index.file.cache.total.size.bytes".equals(name)) {
                        break;
                    }
                    break block8;
                }
                case 673126969: {
                    if ("remote.log.manager.fetch.max.bytes.per.second".equals(name)) {
                        break;
                    }
                    break block8;
                }
                default: {
                    break block8;
                }
            }
            return Predef$.MODULE$.Long2long(config.getLong(name));
        }
        throw new IllegalStateException("Unexpected dynamic remote log manager config " + name);
    }

    private static final long oldLongValue$1(String k, KafkaConfig oldConfig$4) {
        return Predef$.MODULE$.Long2long(oldConfig$4.getLong(k));
    }

    private static final long newLongValue$1(String k, KafkaConfig newConfig$7) {
        return Predef$.MODULE$.Long2long(newConfig$7.getLong(k));
    }

    private static final boolean isChangedLongValue$1(String k, KafkaConfig oldConfig$4, KafkaConfig newConfig$7) {
        return Predef$.MODULE$.Long2long(oldConfig$4.getLong(k)) != Predef$.MODULE$.Long2long(newConfig$7.getLong(k));
    }

    public DynamicRemoteLogConfig(KafkaBroker server) {
        this.server = server;
    }
}

