/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.server.auth.UserAuthFactory;
import org.apache.sshd.server.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.auth.pubkey.UserAuthPublicKeyFactory;

public class UserAuthFactoriesFactory {
    public static final String PASSWORD_METHOD = "password";
    public static final String PUBLICKEY_METHOD = "publickey";
    public static final String KEYBOARD_INTERACTIVE_METHOD = "keyboard-interactive";
    private Set<String> methodSet;
    private List<UserAuthFactory> factories;

    public void setAuthMethods(String[] methods) {
        this.methodSet = new HashSet<String>();
        this.factories = new ArrayList<UserAuthFactory>();
        for (String am : methods) {
            if (PASSWORD_METHOD.equals(am)) {
                this.factories.add((UserAuthFactory)new UserAuthPasswordFactory());
            } else if (KEYBOARD_INTERACTIVE_METHOD.equals(am)) {
                this.factories.add((UserAuthFactory)new UserAuthKeyboardInteractiveFactory());
            } else if (PUBLICKEY_METHOD.equals(am)) {
                this.factories.add((UserAuthFactory)new UserAuthPublicKeyFactory());
            } else {
                throw new IllegalArgumentException("Invalid authentication method " + am + " specified");
            }
            this.methodSet.add(am);
        }
    }

    public List<UserAuthFactory> getFactories() {
        return this.factories;
    }

    public boolean isPublickeyEnabled() {
        return this.methodSet.contains(PUBLICKEY_METHOD);
    }

    public boolean isPasswordEnabled() {
        return this.methodSet.contains(PASSWORD_METHOD);
    }

    public boolean isKeyboardInteractive() {
        return this.methodSet.contains(KEYBOARD_INTERACTIVE_METHOD);
    }
}

