/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.beeline;

import com.google.common.base.Optional;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.beeline.BeeLine;
import org.apache.hive.beeline.Rows;

class BufferedRows
extends Rows {
    private final List<Rows.Row> list = new ArrayList<Rows.Row>();
    private final Iterator<Rows.Row> iterator;
    private int columnCount = this.rsMeta.getColumnCount();
    private int maxColumnWidth;

    BufferedRows(BeeLine beeLine, ResultSet rs) throws SQLException {
        this(beeLine, rs, (Optional<Integer>)Optional.absent());
    }

    BufferedRows(BeeLine beeLine, ResultSet rs, Optional<Integer> limit) throws SQLException {
        super(beeLine, rs);
        this.list.add(new Rows.Row(this, this.columnCount));
        int numRowsBuffered = 0;
        int maxRowsBuffered = (Integer)limit.or((Object)Integer.MAX_VALUE);
        while (numRowsBuffered++ < maxRowsBuffered && rs.next()) {
            this.list.add(new Rows.Row(this, this.columnCount, rs));
        }
        this.iterator = this.list.iterator();
        this.maxColumnWidth = beeLine.getOpts().getMaxColumnWidth();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.iterator.next();
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    void normalizeWidths() {
        if (!this.list.isEmpty()) {
            int[] max = new int[this.columnCount];
            for (Rows.Row row : this.list) {
                for (int j = 0; j < this.columnCount; ++j) {
                    max[j] = Math.min(Math.max(max[j], row.sizes[j] + 1), this.maxColumnWidth);
                }
                row.sizes = max;
            }
        }
    }
}

