/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.couchdb;

import java.util.Map;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.nosql.AbstractNoSqlConnection;
import org.apache.logging.log4j.core.appender.nosql.DefaultNoSqlObject;
import org.apache.logging.log4j.core.appender.nosql.NoSqlObject;
import org.apache.logging.log4j.util.Strings;
import org.lightcouch.CouchDbClient;
import org.lightcouch.Response;

public final class CouchDbConnection
extends AbstractNoSqlConnection<Map<String, Object>, DefaultNoSqlObject> {
    private final CouchDbClient client;

    public CouchDbConnection(CouchDbClient client) {
        this.client = client;
    }

    public DefaultNoSqlObject createObject() {
        return new DefaultNoSqlObject();
    }

    public DefaultNoSqlObject[] createList(int length) {
        return new DefaultNoSqlObject[length];
    }

    public void insertObject(NoSqlObject<Map<String, Object>> object) {
        try {
            Response response = this.client.save(object.unwrap());
            if (Strings.isNotEmpty((CharSequence)response.getError())) {
                throw new AppenderLoggingException("Failed to write log event to CouchDB due to error: " + response.getError() + '.');
            }
        }
        catch (Exception e) {
            throw new AppenderLoggingException("Failed to write log event to CouchDB due to error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void closeImpl() {
        this.client.shutdown();
    }
}

