/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;

public class ParentsChildrenBlockJoinQuery
extends Query {
    private final BitSetProducer parentFilter;
    private final Query parentQuery;
    private final Query childQuery;
    private final int childLimitPerParent;
    private final BinaryOperator<Float> scoreCombiner;
    public static final int DEFAULT_CHILD_LIMIT_PER_PARENT = Integer.MAX_VALUE;

    public ParentsChildrenBlockJoinQuery(BitSetProducer parentFilter, Query parentQuery, Query childQuery, int childLimitPerParent) {
        this(parentFilter, parentQuery, childQuery, childLimitPerParent, Float::sum);
    }

    public ParentsChildrenBlockJoinQuery(BitSetProducer parentFilter, Query parentQuery, Query childQuery, int childLimitPerParent, BinaryOperator<Float> scoreCombiner) {
        if (childLimitPerParent <= 0) {
            throw new IllegalArgumentException("childLimitPerParent must be > 0, got " + childLimitPerParent);
        }
        this.parentFilter = parentFilter;
        this.parentQuery = parentQuery;
        this.childQuery = childQuery;
        this.childLimitPerParent = childLimitPerParent;
        this.scoreCombiner = scoreCombiner;
    }

    public ParentsChildrenBlockJoinQuery(BitSetProducer parentFilter, Query parentQuery, Query childQuery) {
        this(parentFilter, parentQuery, childQuery, Integer.MAX_VALUE);
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return new ParentsChildrenBlockJoinWeight(this, this.parentFilter, this.parentQuery.createWeight(searcher, scoreMode, boost), this.childQuery.createWeight(searcher, scoreMode, boost), this.childLimitPerParent, scoreMode.needsScores(), this.scoreCombiner);
    }

    public Query getParentQuery() {
        return this.parentQuery;
    }

    public Query getChildQuery() {
        return this.childQuery;
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(indexSearcher);
        Query childRewrite = this.childQuery.rewrite(indexSearcher);
        if (parentRewrite != this.parentQuery || childRewrite != this.childQuery) {
            return new ParentsChildrenBlockJoinQuery(this.parentFilter, parentRewrite, childRewrite, this.childLimitPerParent);
        }
        return super.rewrite(indexSearcher);
    }

    public String toString(String field) {
        return "ParentsChildrenBlockJoinQuery(parentQuery=" + String.valueOf(this.parentQuery) + ", childQuery=" + String.valueOf(this.childQuery) + ")";
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((ParentsChildrenBlockJoinQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(ParentsChildrenBlockJoinQuery other) {
        return this.parentFilter.equals(other.parentFilter) && this.parentQuery.equals((Object)other.parentQuery) && this.childQuery.equals((Object)other.childQuery) && this.childLimitPerParent == other.childLimitPerParent && this.scoreCombiner.equals(other.scoreCombiner);
    }

    public int hashCode() {
        int prime = 31;
        int hash = this.classHash();
        hash = 31 * hash + this.parentFilter.hashCode();
        hash = 31 * hash + this.parentQuery.hashCode();
        hash = 31 * hash + this.childQuery.hashCode();
        hash = 31 * hash + this.childLimitPerParent;
        hash = 31 * hash + this.scoreCombiner.hashCode();
        return hash;
    }

    static class ParentsChildrenBlockJoinWeight
    extends Weight {
        private final BitSetProducer parentFilter;
        private final Weight parentWeight;
        private final Weight childWeight;
        private final int childLimitPerParent;
        private final boolean doScores;
        private final BinaryOperator<Float> scoreCombiner;
        private final Set<LeafReaderContext> seenContexts = new HashSet<LeafReaderContext>();

        public ParentsChildrenBlockJoinWeight(Query query, BitSetProducer parentFilter, Weight parentWeight, Weight childWeight, int childLimitPerParent, boolean doScores, BinaryOperator<Float> scoreCombiner) {
            super(query);
            this.parentFilter = parentFilter;
            this.parentWeight = parentWeight;
            this.childWeight = childWeight;
            this.childLimitPerParent = childLimitPerParent;
            this.doScores = doScores;
            this.scoreCombiner = scoreCombiner;
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            ParentsChildrenBlockJoinScorer scorer = (ParentsChildrenBlockJoinScorer)this.scorer(context);
            if (scorer != null && scorer.iterator().advance(doc) == doc) {
                int parentDoc = scorer.getParentDoc();
                int childDoc = scorer.docID();
                return Explanation.match((Number)Float.valueOf(scorer.score()), (String)String.format(Locale.ROOT, "Score based on parent document %d and child document %d ", parentDoc + context.docBase, childDoc + context.docBase), (Explanation[])new Explanation[]{this.parentWeight.explain(context, parentDoc), this.childWeight.explain(context, childDoc)});
            }
            return Explanation.noMatch((String)"Not a match", (Explanation[])new Explanation[0]);
        }

        public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
            if (!this.seenContexts.add(context)) {
                throw new IllegalStateException("ParentsChildrenBlockJoinQuery does not support intraSegment concurrency. Context " + String.valueOf(context) + " was already seen.");
            }
            final BitSet parentBits = this.parentFilter.getBitSet(context);
            if (parentBits == null) {
                return null;
            }
            final ScorerSupplier parentScorerSupplier = this.parentWeight.scorerSupplier(context);
            final ScorerSupplier childScorerSupplier = this.childWeight.scorerSupplier(context);
            if (parentScorerSupplier == null || childScorerSupplier == null) {
                return null;
            }
            return new ScorerSupplier(){
                private long cost = -1L;

                public Scorer get(long leadCost) throws IOException {
                    Scorer parentScorer = parentScorerSupplier.get(leadCost);
                    Scorer childScorer = childScorerSupplier.get(leadCost);
                    return new ParentsChildrenBlockJoinScorer(parentBits, parentScorer, childScorer, childLimitPerParent, doScores, scoreCombiner);
                }

                public long cost() {
                    if (this.cost == -1L) {
                        long parentCost = parentScorerSupplier.cost();
                        long childCost = childScorerSupplier.cost();
                        this.cost = Math.min(parentCost * (long)childLimitPerParent, childCost);
                    }
                    return this.cost;
                }

                public void setTopLevelScoringClause() throws IOException {
                    parentScorerSupplier.setTopLevelScoringClause();
                    childScorerSupplier.setTopLevelScoringClause();
                }
            };
        }

        public boolean isCacheable(LeafReaderContext ctx) {
            return this.parentWeight.isCacheable(ctx) && this.childWeight.isCacheable(ctx);
        }

        public Matches matches(LeafReaderContext context, int doc) throws IOException {
            Matches parentMatch = this.parentWeight.matches(context, doc);
            Matches childMatch = this.childWeight.matches(context, doc);
            if (parentMatch == null && childMatch == null) {
                return null;
            }
            ArrayList<Matches> subMatches = new ArrayList<Matches>();
            if (parentMatch != null) {
                subMatches.add(parentMatch);
            }
            if (childMatch != null) {
                subMatches.add(childMatch);
            }
            return MatchesUtils.fromSubMatches(subMatches);
        }
    }

    static class ParentsChildrenBlockJoinScorer
    extends Scorer {
        private final BitSet parentBits;
        private final Scorer parentScorer;
        private final DocIdSetIterator parentIt;
        private final Scorer childScorer;
        private final DocIdSetIterator childIt;
        private final int childLimitPerParent;
        private final boolean doScores;
        private final BinaryOperator<Float> scoreCombiner;
        private float parentScore;
        private float childScore;
        private int parentDoc = 0;
        private int childDoc = -1;
        private int childDocCount = 0;

        public ParentsChildrenBlockJoinScorer(BitSet parentBits, Scorer parentScorer, Scorer childScorer, int childLimitPerParent, boolean doScores, BinaryOperator<Float> scoreCombiner) {
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.parentIt = parentScorer.iterator();
            this.childScorer = childScorer;
            this.childIt = childScorer.iterator();
            this.childLimitPerParent = childLimitPerParent;
            this.doScores = doScores;
            this.scoreCombiner = scoreCombiner;
        }

        public Collection<Scorable.ChildScorable> getChildren() {
            return Arrays.asList(new Scorable.ChildScorable((Scorable)this.parentScorer, "BLOCK_JOIN"), new Scorable.ChildScorable((Scorable)this.childScorer, "BLOCK_JOIN"));
        }

        public DocIdSetIterator iterator() {
            return new DocIdSetIterator(){

                public int docID() {
                    return childDoc;
                }

                public int nextDoc() throws IOException {
                    if (childDocCount < childLimitPerParent) {
                        childDoc = childIt.nextDoc();
                    }
                    if (childDocCount >= childLimitPerParent || childDoc >= parentDoc) {
                        childDocCount = 0;
                        parentDoc = parentIt.nextDoc();
                        if (parentDoc == 0) {
                            parentDoc = parentIt.nextDoc();
                        }
                        this.validateParentDoc();
                    }
                    this.alignParentAndChildIterator();
                    if (this.exhausted()) {
                        parentDoc = Integer.MAX_VALUE;
                        childDoc = Integer.MAX_VALUE;
                        return childDoc;
                    }
                    if (doScores) {
                        childScore = childScorer.score();
                        parentScore = parentScorer.score();
                    }
                    ++childDocCount;
                    return childDoc;
                }

                public int advance(int target) throws IOException {
                    if (target <= childDoc) {
                        return childDoc;
                    }
                    childDoc = childIt.advance(target);
                    if (childDocCount >= childLimitPerParent || childDoc >= parentDoc) {
                        childDocCount = 0;
                        parentDoc = childDoc <= parentDoc ? parentIt.nextDoc() : parentIt.advance(childDoc);
                        this.validateParentDoc();
                        this.alignParentAndChildIterator();
                    }
                    if (this.exhausted()) {
                        parentDoc = Integer.MAX_VALUE;
                        childDoc = Integer.MAX_VALUE;
                        return childDoc;
                    }
                    if (doScores) {
                        childScore = childScorer.score();
                        parentScore = parentScorer.score();
                    }
                    ++childDocCount;
                    return childDoc;
                }

                private void alignParentAndChildIterator() throws IOException {
                    int firstChild;
                    while (!(this.exhausted() || childDoc >= (firstChild = parentBits.prevSetBit(parentDoc - 1) + 1) && childDoc < parentDoc)) {
                        if (childDoc < firstChild) {
                            childDoc = childIt.advance(firstChild);
                            continue;
                        }
                        parentDoc = childDoc == parentDoc ? parentIt.nextDoc() : parentIt.advance(childDoc);
                        this.validateParentDoc();
                    }
                }

                public long cost() {
                    if (childLimitPerParent == Integer.MAX_VALUE) {
                        return childIt.cost();
                    }
                    return Math.min(childIt.cost(), parentIt.cost() * (long)childLimitPerParent);
                }

                private boolean exhausted() {
                    return childIt.docID() == Integer.MAX_VALUE || parentIt.docID() == Integer.MAX_VALUE;
                }
            };
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException("Parent query must not match any docs besides parent filter. Combine them as must (+) and must-not (-) clauses to find a problem doc. docID=" + this.parentDoc);
            }
        }

        public int docID() {
            return this.childDoc;
        }

        public float score() throws IOException {
            if (this.doScores) {
                return ((Float)this.scoreCombiner.apply(Float.valueOf(this.parentScore), Float.valueOf(this.childScore))).floatValue();
            }
            return 1.0f;
        }

        public float getMaxScore(int upTo) throws IOException {
            return Float.POSITIVE_INFINITY;
        }

        int getParentDoc() {
            return this.parentDoc;
        }
    }
}

