/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.geoapi.temporal.Period;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gml.GMLAdapter;
import org.apache.sis.internal.jaxb.gml.TimePeriodBound;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.internal.xml.LegacyNamespaces;

@XmlRootElement(name="TimePeriod")
@XmlType(propOrder={"begin", "end"})
public final class TimePeriod
extends GMLAdapter {
    @XmlElements(value={@XmlElement(type=TimePeriodBound.GML3.class, name="beginPosition"), @XmlElement(type=TimePeriodBound.GML2.class, name="begin")})
    TimePeriodBound begin;
    @XmlElements(value={@XmlElement(type=TimePeriodBound.GML3.class, name="endPosition"), @XmlElement(type=TimePeriodBound.GML2.class, name="end")})
    TimePeriodBound end;

    public TimePeriod() {
    }

    public TimePeriod(Period period) {
        super(period);
        if (period != null) {
            if (Context.isGMLVersion(Context.current(), LegacyNamespaces.VERSION_3_0)) {
                this.begin = new TimePeriodBound.GML3(period.getBeginning(), "before");
                this.end = new TimePeriodBound.GML3(period.getEnding(), "after");
            } else {
                this.begin = new TimePeriodBound.GML2(period.getBeginning());
                this.end = new TimePeriodBound.GML2(period.getEnding());
            }
        }
    }

    public String toString() {
        return Strings.range(this.getClass(), this.begin, this.end);
    }
}

