/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.transformationconnmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.CacheKeyFactory;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorManager;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorFactory;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;

public class TransformationConnectorManager
extends BaseTable
implements ITransformationConnectorManager {
    public static final String _rcsid = "@(#)$Id$";
    protected static final String descriptionField = "description";
    protected static final String classNameField = "classname";
    protected IThreadContext threadContext;

    public TransformationConnectorManager(IThreadContext threadContext, IDBInterface database) throws ManifoldCFException {
        super(database, "transformationconnectors");
        this.threadContext = threadContext;
    }

    @Override
    public void install() throws ManifoldCFException {
        block3: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(descriptionField, new ColumnDescription("VARCHAR(255)", false, false, null, null, false));
                map.put(classNameField, new ColumnDescription("VARCHAR(255)", true, false, null, null, false));
                this.performCreate(map, null);
            }
            IndexDescription descriptionIndex = new IndexDescription(true, new String[]{descriptionField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (descriptionIndex != null && id.equals((Object)descriptionIndex)) {
                    descriptionIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (descriptionIndex == null) break block3;
            this.performAddIndex(null, descriptionIndex);
        }
    }

    @Override
    public void deinstall() throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        this.beginTransaction();
        try {
            IResultSet set = this.performQuery("SELECT classname FROM " + this.getTableName(), null, null, null);
            int i = 0;
            while (i < set.getRowCount()) {
                IResultRow row = set.getRow(i++);
                String className = row.getValue(classNameField).toString();
                TransformationConnectorFactory.deinstall(this.threadContext, className);
            }
            this.performDrop(invKeys);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void registerConnector(String description, String className) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        this.beginTransaction();
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add(className);
            IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE classname=? FOR UPDATE", params, null, null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(descriptionField, description);
            if (set.getRowCount() == 0) {
                map.put(classNameField, className);
                this.performInsert(map, invKeys);
            } else {
                this.performUpdate(map, "WHERE classname=?", params, invKeys);
            }
            TransformationConnectorFactory.install(this.threadContext, className);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void unregisterConnector(String className) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        this.beginTransaction();
        try {
            TransformationConnectorFactory.deinstall(this.threadContext, className);
            this.removeConnector(className);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void removeConnector(String className) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        ArrayList<String> list = new ArrayList<String>();
        list.add(className);
        this.performDelete("WHERE classname=?", list, invKeys);
    }

    @Override
    public IResultSet getConnectors() throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        return this.performQuery("SELECT description AS description,classname AS classname FROM " + this.getTableName() + " ORDER BY description ASC", null, invKeys, null);
    }

    @Override
    public String getDescription(String className) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        ArrayList<String> list = new ArrayList<String>();
        list.add(className);
        IResultSet set = this.performQuery("SELECT description FROM " + this.getTableName() + " WHERE classname=?", list, invKeys, null);
        if (set.getRowCount() == 0) {
            return null;
        }
        IResultRow row = set.getRow(0);
        return row.getValue(descriptionField).toString();
    }

    @Override
    public boolean isInstalled(String className) throws ManifoldCFException {
        StringSet invKeys = new StringSet(this.getCacheKey());
        ArrayList<String> list = new ArrayList<String>();
        list.add(className);
        IResultSet set = this.performQuery("SELECT * FROM " + this.getTableName() + " WHERE classname=?", list, invKeys, null);
        return set.getRowCount() > 0;
    }

    protected String getCacheKey() {
        return CacheKeyFactory.makeTableKey(null, (String)this.getTableName(), (String)this.getDBInterface().getDatabaseName());
    }
}

