/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.factory;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.ArrayUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.fit.factory.ResourceCreationSpecifierFactory;
import org.apache.uima.fit.internal.ExtendedExternalResourceDescription_impl;
import org.apache.uima.fit.internal.ReflectionUtil;
import org.apache.uima.fit.internal.ResourceList;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ExternalResourceDependency;
import org.apache.uima.resource.ExternalResourceDescription;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ParameterizedDataResource;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.SharedResourceObject;
import org.apache.uima.resource.impl.ConfigurableDataResourceSpecifier_impl;
import org.apache.uima.resource.impl.ConfigurableDataResource_impl;
import org.apache.uima.resource.impl.ExternalResourceDependency_impl;
import org.apache.uima.resource.impl.ExternalResourceDescription_impl;
import org.apache.uima.resource.impl.FileResourceSpecifier_impl;
import org.apache.uima.resource.impl.Parameter_impl;
import org.apache.uima.resource.metadata.ExternalResourceBinding;
import org.apache.uima.resource.metadata.ResourceManagerConfiguration;
import org.apache.uima.resource.metadata.ResourceMetaData;
import org.apache.uima.resource.metadata.impl.ExternalResourceBinding_impl;
import org.apache.uima.resource.metadata.impl.ResourceManagerConfiguration_impl;
import org.apache.uima.resource.metadata.impl.ResourceMetaData_impl;
import org.apache.uima.util.InvalidXMLException;

public final class ExternalResourceFactory {
    public static final String PARAM_RESOURCE_NAME = "__UIMAFIT_RESOURCE_NAME__";
    public static final String PREFIX_SEPARATOR = "##";
    private static final AtomicLong DISAMBIGUATOR = new AtomicLong();

    private ExternalResourceFactory() {
    }

    public static boolean isExternalResourceField(Field field) {
        return ReflectionUtil.isAnnotationPresent(field, ExternalResource.class);
    }

    public static ExternalResourceDescription createExternalResourceDescription(Class<? extends Resource> aInterface, Object ... aParams) {
        return ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aInterface.getName()), aInterface, aParams);
    }

    public static ExternalResourceDescription createExternalResourceDescription(String aName, Class<? extends Resource> aInterface, Object ... aParams) {
        CustomResourceSpecifier spec;
        ConfigurationParameterFactory.ensureParametersComeInPairs(aParams);
        ArrayList<ExternalResourceBinding> bindings = new ArrayList<ExternalResourceBinding>();
        ArrayList<ExternalResourceDescription> descs = new ArrayList<ExternalResourceDescription>();
        for (Map.Entry<String, ExternalResourceDescription> res : ExternalResourceFactory.extractExternalResourceParameters(aParams).entrySet()) {
            bindings.add(ExternalResourceFactory.createExternalResourceBinding(res.getKey(), res.getValue()));
            descs.add(res.getValue());
        }
        if (ConfigurableDataResource_impl.class.isAssignableFrom(aInterface)) {
            ConfigurationParameterFactory.ConfigurationData cfg = ConfigurationParameterFactory.createConfigurationData(aParams);
            ResourceMetaData_impl meta = new ResourceMetaData_impl();
            ConfigurationParameterFactory.ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(aInterface);
            ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
            ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, cfg.configurationParameters, cfg.configurationValues);
            ConfigurableDataResourceSpecifier_impl spec1 = new ConfigurableDataResourceSpecifier_impl();
            spec1.setUrl("");
            spec1.setMetaData((ResourceMetaData)meta);
            spec = spec1;
        } else {
            ArrayList<Parameter_impl> params = new ArrayList<Parameter_impl>();
            if (aParams != null) {
                for (int i = 0; i < aParams.length / 2; ++i) {
                    if (ExternalResourceFactory.getExternalResourceParameterType(aParams[i * 2 + 1]) != ResourceValueType.NO_RESOURCE) continue;
                    Parameter_impl param = new Parameter_impl();
                    param.setName((String)aParams[i * 2]);
                    param.setValue((String)aParams[i * 2 + 1]);
                    params.add(param);
                }
            }
            CustomResourceSpecifier spec1 = UIMAFramework.getResourceSpecifierFactory().createCustomResourceSpecifier();
            spec1.setResourceClassName(aInterface.getName());
            spec1.setParameters(params.toArray(new Parameter[params.size()]));
            spec = spec1;
        }
        ExtendedExternalResourceDescription_impl extRes = new ExtendedExternalResourceDescription_impl();
        extRes.setName(aName);
        extRes.setResourceSpecifier((ResourceSpecifier)spec);
        extRes.setExternalResourceBindings(bindings);
        extRes.setExternalResources(descs);
        return extRes;
    }

    public static ExternalResourceDescription createExternalResourceDescription(Class<? extends SharedResourceObject> aInterface, String aUrl, Object ... aParams) {
        return ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aInterface.getName()), aInterface, aUrl, aParams);
    }

    public static ExternalResourceDescription createExternalResourceDescription(Class<? extends SharedResourceObject> aInterface, URL aUrl, Object ... aParams) {
        return ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aInterface.getName()), aInterface, aUrl.toString(), aParams);
    }

    public static ExternalResourceDescription createExternalResourceDescription(Class<? extends SharedResourceObject> aInterface, File aFile, Object ... aParams) {
        try {
            return ExternalResourceFactory.createExternalResourceDescription(aInterface, aFile.toURI().toURL(), aParams);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File converts to illegal URL [" + aFile + "]");
        }
    }

    public static ExternalResourceDescription createExternalResourceDescription(String aName, Class<? extends SharedResourceObject> aInterface, String aUrl, Object ... aParams) {
        ArrayList<ExternalResourceBinding> bindings = new ArrayList<ExternalResourceBinding>();
        ArrayList<ExternalResourceDescription> descs = new ArrayList<ExternalResourceDescription>();
        for (Map.Entry<String, ExternalResourceDescription> res : ExternalResourceFactory.extractExternalResourceParameters(aParams).entrySet()) {
            bindings.add(ExternalResourceFactory.createExternalResourceBinding(res.getKey(), res.getValue()));
            descs.add(res.getValue());
        }
        ConfigurationParameterFactory.ConfigurationData cfg = ConfigurationParameterFactory.createConfigurationData(aParams);
        ResourceMetaData_impl meta = new ResourceMetaData_impl();
        ConfigurationParameterFactory.ConfigurationData reflectedConfigurationData = ConfigurationParameterFactory.createConfigurationData(aInterface);
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, reflectedConfigurationData.configurationParameters, reflectedConfigurationData.configurationValues);
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceMetaData)meta, cfg.configurationParameters, cfg.configurationValues);
        ConfigurableDataResourceSpecifier_impl spec = new ConfigurableDataResourceSpecifier_impl();
        spec.setUrl(aUrl);
        spec.setMetaData((ResourceMetaData)meta);
        ExtendedExternalResourceDescription_impl extRes = new ExtendedExternalResourceDescription_impl();
        extRes.setName(aName);
        extRes.setResourceSpecifier((ResourceSpecifier)spec);
        extRes.setImplementationName(aInterface.getName());
        extRes.setExternalResourceBindings(bindings);
        extRes.setExternalResources(descs);
        return extRes;
    }

    public static ExternalResourceDescription createExternalResourceDescription(String aName, String aUrl) {
        ExternalResourceDescription_impl extRes = new ExternalResourceDescription_impl();
        extRes.setName(aName);
        FileResourceSpecifier_impl frs = new FileResourceSpecifier_impl();
        frs.setFileUrl(aUrl);
        extRes.setResourceSpecifier((ResourceSpecifier)frs);
        return extRes;
    }

    public static ExternalResourceBinding createExternalResourceBinding(String aKey, ExternalResourceDescription aResource) {
        return ExternalResourceFactory.createExternalResourceBinding(aKey, aResource.getName());
    }

    public static ExternalResourceBinding createExternalResourceBinding(String aKey, String aResourceKey) {
        ExternalResourceBinding_impl extResBind = new ExternalResourceBinding_impl();
        extResBind.setResourceName(aResourceKey);
        extResBind.setKey(aKey);
        return extResBind;
    }

    public static ExternalResourceDependency createExternalResourceDependency(Field field) {
        Class<Object> api;
        ExternalResource era = ReflectionUtil.getAnnotation(field, ExternalResource.class);
        String key = era.key();
        if (key.length() == 0) {
            key = field.getName();
        }
        if ((api = era.api()) == Resource.class) {
            api = Resource.class.isAssignableFrom(field.getType()) || SharedResourceObject.class.isAssignableFrom(field.getType()) ? field.getType() : Object.class;
        }
        return ExternalResourceFactory.createExternalResourceDependency(key, api, !era.mandatory(), era.description());
    }

    public static ExternalResourceDependency createExternalResourceDependency(String aKey, Class<?> aInterface, boolean aOptional, String aDescription) {
        ExternalResourceDependency_impl dep = new ExternalResourceDependency_impl();
        dep.setInterfaceName(aInterface.getName());
        dep.setKey(aKey);
        dep.setOptional(aOptional);
        dep.setDescription(aDescription);
        return dep;
    }

    public static ExternalResourceDependency[] createExternalResourceDependencies(Class<?> cls) throws ResourceInitializationException {
        HashMap<String, ExternalResourceDependency> depMap = new HashMap<String, ExternalResourceDependency>();
        ExternalResourceFactory.createExternalResourceDependencies(cls, cls, depMap);
        Collection deps = depMap.values();
        return deps.toArray(new ExternalResourceDependency[deps.size()]);
    }

    private static <T> void createExternalResourceDependencies(Class<?> baseCls, Class<?> cls, Map<String, ExternalResourceDependency> dependencies) throws ResourceInitializationException {
        if (cls.getSuperclass() != null) {
            ExternalResourceFactory.createExternalResourceDependencies(baseCls, cls.getSuperclass(), dependencies);
        }
        for (Field field : cls.getDeclaredFields()) {
            if (!ReflectionUtil.isAnnotationPresent(field, ExternalResource.class)) continue;
            ExternalResourceDependency dep = ExternalResourceFactory.createExternalResourceDependency(field);
            if (dependencies.containsKey(dep.getKey())) {
                throw new ResourceInitializationException((Throwable)new IllegalStateException("Key [" + dep.getKey() + "] may only be used on a single field."));
            }
            dependencies.put(dep.getKey(), dep);
        }
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, URL aUrl) throws InvalidXMLException {
        ExternalResourceFactory.bindResource(aDesc, aKey, aUrl.toString());
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, File aFile) throws InvalidXMLException {
        try {
            ExternalResourceFactory.bindResource(aDesc, aKey, aFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("File converts to illegal URL [" + aFile + "]");
        }
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, String aUrl) throws InvalidXMLException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createExternalResourceDescription(aKey, aUrl);
        ExternalResourceFactory.bindResource(aDesc, aKey, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, Class<? extends Resource> aRes, String ... aParams) throws InvalidXMLException, ClassNotFoundException {
        ExternalResourceFactory.bindResource(aDesc, aRes, aRes, aParams);
    }

    public static void bindResource(ResourceSpecifier aDesc, Class<?> aApi, Class<? extends Resource> aRes, String ... aParams) throws InvalidXMLException, ClassNotFoundException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, (Object[])aParams);
        ExternalResourceFactory.bindResource(aDesc, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, Class<? extends SharedResourceObject> aRes, String aUrl, Object ... aParams) throws InvalidXMLException, ClassNotFoundException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, aUrl, aParams);
        ExternalResourceFactory.bind((AnalysisEngineDescription)aDesc, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, Class<?> aApi, Class<? extends SharedResourceObject> aRes, String aUrl, Object ... aParams) throws InvalidXMLException {
        ExternalResourceFactory.bindResource(aDesc, aApi.getName(), aRes, aUrl, aParams);
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, Class<? extends SharedResourceObject> aRes, String aUrl, Object ... aParams) throws InvalidXMLException {
        ExternalResourceDescription extRes = ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, aUrl, aParams);
        ExternalResourceFactory.bind((AnalysisEngineDescription)aDesc, aKey, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, Class<? extends Resource> aRes, String ... aParams) throws InvalidXMLException {
        if (ParameterizedDataResource.class.isAssignableFrom(aRes)) {
            ExternalResourceFactory.createDependency(aDesc, aKey, DataResource.class);
        }
        ExternalResourceDescription extRes = ExternalResourceFactory.createExternalResourceDescription(ExternalResourceFactory.uniqueResourceKey(aRes.getName()), aRes, (Object[])aParams);
        ExternalResourceFactory.bindResource(aDesc, aKey, extRes);
    }

    public static void bindResource(ResourceSpecifier aDesc, ExternalResourceDescription aResDesc) throws InvalidXMLException, ClassNotFoundException {
        if (aDesc instanceof AnalysisEngineDescription) {
            ExternalResourceFactory.bind((AnalysisEngineDescription)aDesc, aResDesc);
        }
    }

    public static void bindResource(ResourceSpecifier aDesc, String aKey, ExternalResourceDescription aResDesc) throws InvalidXMLException {
        if (aDesc instanceof AnalysisEngineDescription) {
            ExternalResourceFactory.bind((AnalysisEngineDescription)aDesc, aKey, aResDesc);
        }
    }

    public static void createDependencyAndBind(ResourceSpecifier aDesc, String aKey, Class<? extends Resource> aImpl, String ... aParams) throws InvalidXMLException {
        Class api = ParameterizedDataResource.class.isAssignableFrom(aImpl) ? DataResource.class : aImpl;
        ExternalResourceFactory.createDependencyAndBind(aDesc, aKey, aImpl, api, aParams);
    }

    public static void createDependencyAndBind(ResourceSpecifier aDesc, String aKey, Class<? extends Resource> aImpl, Class<?> aApi, String ... aParams) throws InvalidXMLException {
        ExternalResourceFactory.createDependency(aDesc, aKey, aApi);
        ExternalResourceFactory.bindResource(aDesc, aKey, aImpl, aParams);
    }

    public static void createDependency(ResourceSpecifier aDesc, String aKey, Class<?> aApi) {
        Object[] deps = ExternalResourceFactory.getExternalResourceDependencies(aDesc);
        if (deps == null) {
            deps = new ExternalResourceDependency[]{};
        }
        boolean found = false;
        for (ExternalResourceDependency externalResourceDependency : deps) {
            if (!externalResourceDependency.getKey().equals(aKey)) continue;
            found = true;
            break;
        }
        if (!found) {
            ExternalResourceFactory.setExternalResourceDependencies(aDesc, (ExternalResourceDependency[])ArrayUtils.add((Object[])deps, (Object)ExternalResourceFactory.createExternalResourceDependency(aKey, aApi, false, null)));
        }
    }

    private static void setExternalResourceDependencies(ResourceSpecifier aDesc, ExternalResourceDependency[] aDependencies) {
        if (aDesc instanceof CollectionReaderDescription) {
            ((CollectionReaderDescription)aDesc).setExternalResourceDependencies(aDependencies);
        } else if (aDesc instanceof AnalysisEngineDescription) {
            ((AnalysisEngineDescription)aDesc).setExternalResourceDependencies(aDependencies);
        } else {
            throw new IllegalArgumentException("Resource specified cannot have external resource dependencies");
        }
    }

    private static ExternalResourceDependency[] getExternalResourceDependencies(ResourceSpecifier aDesc) {
        if (aDesc instanceof CollectionReaderDescription) {
            return ((CollectionReaderDescription)aDesc).getExternalResourceDependencies();
        }
        if (aDesc instanceof AnalysisEngineDescription) {
            return ((AnalysisEngineDescription)aDesc).getExternalResourceDependencies();
        }
        throw new IllegalArgumentException("Resource specified cannot have external resource dependencies");
    }

    public static void createDependencyAndBind(AnalysisEngineDescription aDesc, String aKey, Class<? extends SharedResourceObject> aImpl, String aUrl, Object ... aParams) throws InvalidXMLException {
        if (aDesc.getExternalResourceDependency(aKey) == null) {
            Object[] deps = aDesc.getExternalResourceDependencies();
            if (deps == null) {
                deps = new ExternalResourceDependency[]{};
            }
            aDesc.setExternalResourceDependencies((ExternalResourceDependency[])ArrayUtils.add((Object[])deps, (Object)ExternalResourceFactory.createExternalResourceDependency(aKey, aImpl, false, null)));
        }
        ExternalResourceFactory.bindResource((ResourceSpecifier)aDesc, aKey, aImpl, aUrl, aParams);
    }

    private static void bind(AnalysisEngineDescription aDesc, ExternalResourceDescription aResDesc) throws InvalidXMLException, ClassNotFoundException {
        if (!aDesc.isPrimitive()) {
            for (Object delegate : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
                ExternalResourceFactory.bindResource((ResourceSpecifier)delegate, aResDesc);
            }
        }
        Class<?> resClass = Class.forName(ExternalResourceFactory.getImplementationName(aResDesc));
        for (ExternalResourceDependency dep : aDesc.getExternalResourceDependencies()) {
            Class<?> apiClass = Class.forName(dep.getInterfaceName());
            if (apiClass.equals(Object.class) || !apiClass.isAssignableFrom(resClass)) continue;
            ExternalResourceFactory.bindExternalResource((ResourceCreationSpecifier)aDesc, dep.getKey(), aResDesc);
        }
    }

    private static void bind(AnalysisEngineDescription aDesc, String aKey, ExternalResourceDescription aResDesc) throws InvalidXMLException {
        if (!aDesc.isPrimitive()) {
            for (Object delegate : aDesc.getDelegateAnalysisEngineSpecifiers().values()) {
                ExternalResourceFactory.bindResource((ResourceSpecifier)delegate, aKey, aResDesc);
            }
        }
        for (ExternalResourceDependency dep : aDesc.getExternalResourceDependencies()) {
            if (!aKey.equals(dep.getKey())) continue;
            ExternalResourceFactory.bindExternalResource((ResourceCreationSpecifier)aDesc, aKey, aResDesc);
        }
    }

    public static void bindExternalResource(ResourceManagerConfiguration aResMgrCfg, String aBindTo, ExternalResourceDescription aRes) {
        HashMap<String, ExternalResourceBinding> bindings = new HashMap<String, ExternalResourceBinding>();
        for (ExternalResourceBinding b : aResMgrCfg.getExternalResourceBindings()) {
            bindings.put(b.getKey(), b);
        }
        HashMap<String, ExternalResourceDescription> resources = new HashMap<String, ExternalResourceDescription>();
        for (ExternalResourceDescription r : aResMgrCfg.getExternalResources()) {
            resources.put(r.getName(), r);
        }
        ExternalResourceBinding extResBind = ExternalResourceFactory.createExternalResourceBinding(aBindTo, aRes);
        bindings.put(extResBind.getKey(), extResBind);
        resources.put(aRes.getName(), aRes);
        ExternalResourceFactory.bindNestedResources(aRes, bindings, resources);
        aResMgrCfg.setExternalResourceBindings(bindings.values().toArray(new ExternalResourceBinding[bindings.size()]));
        aResMgrCfg.setExternalResources(resources.values().toArray(new ExternalResourceDescription[resources.size()]));
    }

    public static void bindExternalResource(ExternalResourceDescription aRes, String aBindTo, ExternalResourceDescription aNestedRes) {
        if (!(aRes instanceof ExtendedExternalResourceDescription_impl)) {
            throw new IllegalArgumentException("Nested resources are only supported on instances of [" + ExtendedExternalResourceDescription_impl.class.getName() + "] which" + "can be created with uimaFIT's createExternalResourceDescription() methods.");
        }
        ExtendedExternalResourceDescription_impl extRes = (ExtendedExternalResourceDescription_impl)aRes;
        HashMap<String, ExternalResourceBinding> bindings = new HashMap<String, ExternalResourceBinding>();
        for (ExternalResourceBinding externalResourceBinding : extRes.getExternalResourceBindings()) {
            bindings.put(externalResourceBinding.getKey(), externalResourceBinding);
        }
        HashMap<String, ExternalResourceDescription> resources = new HashMap<String, ExternalResourceDescription>();
        for (ExternalResourceDescription r : extRes.getExternalResources()) {
            resources.put(r.getName(), r);
        }
        ExternalResourceBinding externalResourceBinding = ExternalResourceFactory.createExternalResourceBinding(aBindTo, aNestedRes);
        bindings.put(externalResourceBinding.getKey(), externalResourceBinding);
        resources.put(aNestedRes.getName(), aNestedRes);
        ExternalResourceFactory.bindNestedResources(aRes, bindings, resources);
        extRes.setExternalResourceBindings(bindings.values());
        extRes.setExternalResources(resources.values());
    }

    private static void bindNestedResources(ExternalResourceDescription aRes, Map<String, ExternalResourceBinding> aBindings, Map<String, ExternalResourceDescription> aResources) {
        if (aRes instanceof ExtendedExternalResourceDescription_impl) {
            ExtendedExternalResourceDescription_impl extRes = (ExtendedExternalResourceDescription_impl)aRes;
            if (ConfigurationParameterFactory.canParameterBeSet(extRes.getResourceSpecifier(), PARAM_RESOURCE_NAME)) {
                ConfigurationParameterFactory.setParameter(extRes.getResourceSpecifier(), PARAM_RESOURCE_NAME, aRes.getName());
            }
            HashMap<String, ExternalResourceDescription> res = new HashMap<String, ExternalResourceDescription>();
            for (ExternalResourceDescription r : extRes.getExternalResources()) {
                res.put(r.getName(), r);
            }
            for (ExternalResourceBinding b : extRes.getExternalResourceBindings()) {
                String key = b.getKey();
                if (!key.startsWith(aRes.getName() + PREFIX_SEPARATOR)) {
                    key = aRes.getName() + PREFIX_SEPARATOR + b.getKey();
                }
                if (aBindings.containsKey(key)) continue;
                aBindings.put(key, b);
                ExternalResourceDescription nestedRes = (ExternalResourceDescription)res.get(b.getResourceName());
                aResources.put(nestedRes.getName(), nestedRes);
                ExternalResourceFactory.bindNestedResources(nestedRes, aBindings, aResources);
                b.setKey(key);
            }
        }
    }

    public static void bindExternalResource(ResourceCreationSpecifier aDesc, String aBindTo, ExternalResourceDescription aRes) {
        ResourceManagerConfiguration resMgrCfg = aDesc.getResourceManagerConfiguration();
        if (resMgrCfg == null) {
            resMgrCfg = new ResourceManagerConfiguration_impl();
            aDesc.setResourceManagerConfiguration(resMgrCfg);
        }
        ExternalResourceFactory.bindExternalResource(resMgrCfg, aBindTo, aRes);
    }

    public static void bindExternalResource(ResourceManagerConfiguration aResMgrCfg, String aBindTo, String aRes) {
        ExternalResourceBinding extResBind = ExternalResourceFactory.createExternalResourceBinding(aBindTo, aRes);
        aResMgrCfg.addExternalResourceBinding(extResBind);
    }

    public static void bindExternalResource(ResourceCreationSpecifier aDesc, String aBindTo, String aRes) {
        ResourceManagerConfiguration resMgrCfg = aDesc.getResourceManagerConfiguration();
        if (resMgrCfg == null) {
            resMgrCfg = new ResourceManagerConfiguration_impl();
            aDesc.setResourceManagerConfiguration(resMgrCfg);
        }
        ExternalResourceFactory.bindExternalResource(resMgrCfg, aBindTo, aRes);
    }

    static String uniqueResourceKey(String aKey) {
        return aKey + '-' + DISAMBIGUATOR.getAndIncrement();
    }

    protected static String getImplementationName(ExternalResourceDescription aDesc) {
        if (aDesc.getResourceSpecifier() instanceof CustomResourceSpecifier) {
            return ((CustomResourceSpecifier)aDesc.getResourceSpecifier()).getResourceClassName();
        }
        return aDesc.getImplementationName();
    }

    protected static Map<String, ExternalResourceDescription> extractExternalResourceParameters(Object[] configurationData) {
        if (configurationData == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ExternalResourceDescription> extRes = new HashMap<String, ExternalResourceDescription>();
        for (int i = 0; i < configurationData.length - 1; i += 2) {
            String key = (String)configurationData[i];
            Object value = configurationData[i + 1];
            if (value == null) continue;
            ResourceValueType type = ExternalResourceFactory.getExternalResourceParameterType(value);
            if (type == ResourceValueType.PRIMITIVE) {
                ExternalResourceDescription description = (ExternalResourceDescription)value;
                extRes.put(key, description);
                continue;
            }
            if (!type.isMultiValued()) continue;
            List<ExternalResourceDescription> resList = type == ResourceValueType.ARRAY ? Arrays.asList((ExternalResourceDescription[])value) : (List<ExternalResourceDescription>)value;
            ArrayList<String> params = new ArrayList<String>();
            params.add("size");
            params.add(String.valueOf(resList.size()));
            int n = 0;
            for (ExternalResourceDescription res : resList) {
                params.add("ELEMENT[" + n + "]");
                params.add((String)res);
                ++n;
            }
            extRes.put(key, ExternalResourceFactory.createExternalResourceDescription(ResourceList.class, params.toArray()));
        }
        return extRes;
    }

    static ResourceValueType getExternalResourceParameterType(Object aValue) {
        boolean isResourceCollection;
        if (aValue == null) {
            return ResourceValueType.NO_RESOURCE;
        }
        boolean isResourcePrimitive = aValue instanceof ExternalResourceDescription;
        boolean isResourceArray = aValue.getClass().isArray() && ExternalResourceDescription.class.isAssignableFrom(aValue.getClass().getComponentType());
        boolean bl = isResourceCollection = Collection.class.isAssignableFrom(aValue.getClass()) && !((Collection)aValue).isEmpty() && ((Collection)aValue).iterator().next() instanceof ExternalResourceDescription;
        if (isResourcePrimitive) {
            return ResourceValueType.PRIMITIVE;
        }
        if (isResourceArray) {
            return ResourceValueType.ARRAY;
        }
        if (isResourceCollection) {
            return ResourceValueType.COLLECTION;
        }
        return ResourceValueType.NO_RESOURCE;
    }

    static enum ResourceValueType {
        NO_RESOURCE,
        PRIMITIVE,
        ARRAY,
        COLLECTION;


        public boolean isMultiValued() {
            return this == COLLECTION || this == ARRAY;
        }
    }
}

