/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.Checker;
import de.thetaphi.forbiddenapis.ClassMetadata;
import de.thetaphi.forbiddenapis.ClassPatternRule;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Signatures
implements Constants {
    private static final String BUNDLED_PREFIX = "@includeBundled ";
    private static final String DEFAULT_MESSAGE_PREFIX = "@defaultMessage ";
    private static final String IGNORE_UNRESOLVABLE_LINE = "@ignoreUnresolvable";
    private static final String IGNORE_MISSING_CLASSES_LINE = "@ignoreMissingClasses";
    private static final String WILDCARD_ARGS = "**";
    private static final Pattern PATTERN_WILDCARD_ARGS = Pattern.compile(String.format(Locale.ROOT, "%s\\s*%s\\s*%s", Pattern.quote("("), Pattern.quote("**"), Pattern.quote(")")));
    private final RelatedClassLookup lookup;
    private final Logger logger;
    private final boolean failOnUnresolvableSignatures;
    private final boolean ignoreSignaturesOfMissingClasses;
    final Map<String, String> signatures = new HashMap<String, String>();
    final Set<ClassPatternRule> classPatterns = new LinkedHashSet<ClassPatternRule>();
    private boolean forbidNonPortableRuntime = false;
    private int numberOfFiles = 0;

    public Signatures(Checker checker) {
        this(checker, checker.logger, checker.options.contains((Object)Checker.Option.IGNORE_SIGNATURES_OF_MISSING_CLASSES), checker.options.contains((Object)Checker.Option.FAIL_ON_UNRESOLVABLE_SIGNATURES));
    }

    public Signatures(RelatedClassLookup lookup, Logger logger, boolean ignoreSignaturesOfMissingClasses, boolean failOnUnresolvableSignatures) {
        this.lookup = lookup;
        this.logger = logger;
        this.ignoreSignaturesOfMissingClasses = ignoreSignaturesOfMissingClasses;
        this.failOnUnresolvableSignatures = failOnUnresolvableSignatures;
    }

    static String getKey(String internalClassName) {
        return "c\u0000" + internalClassName;
    }

    static String getKey(String internalClassName, String field) {
        return "f\u0000" + internalClassName + '\u0000' + field;
    }

    static String getKey(String internalClassName, Method method) {
        return "m\u0000" + internalClassName + '\u0000' + method;
    }

    private void addSignature(String line, String defaultMessage, UnresolvableReporting report, boolean localIgnoreMissingClasses, Set<String> missingClasses) throws ParseException, IOException {
        String printout;
        String field;
        Method method;
        String clazz;
        String signature;
        String message = null;
        int p = line.indexOf(64);
        if (p >= 0) {
            signature = line.substring(0, p).trim();
            message = line.substring(p + 1).trim();
        } else {
            signature = line;
            message = defaultMessage;
        }
        if (line.isEmpty()) {
            throw new ParseException("Empty signature");
        }
        p = signature.indexOf(35);
        if (p >= 0) {
            clazz = signature.substring(0, p);
            String methodOrField = signature.substring(p + 1);
            if ((p = methodOrField.indexOf(40)) >= 0) {
                if (p == 0) {
                    throw new ParseException("Invalid method signature (method name missing): " + signature);
                }
                if (PATTERN_WILDCARD_ARGS.matcher(methodOrField.substring(p)).matches()) {
                    method = new Method(methodOrField.substring(0, p).trim(), WILDCARD_ARGS);
                } else {
                    try {
                        method = Method.getMethod("void ".concat(methodOrField), true);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ParseException("Invalid method signature: " + signature);
                    }
                }
                field = null;
            } else {
                field = methodOrField;
                method = null;
            }
        } else {
            clazz = signature;
            method = null;
            field = null;
        }
        if (message != null && message.isEmpty()) {
            message = null;
        }
        String string = printout = message != null ? signature + " [" + message + "]" : signature;
        if (AsmUtils.isGlob(clazz)) {
            if (method != null || field != null) {
                throw new ParseException(String.format(Locale.ENGLISH, "Class level glob pattern cannot be combined with methods/fields: %s", signature));
            }
            this.classPatterns.add(new ClassPatternRule(clazz, message));
        } else {
            ClassMetadata c;
            try {
                c = this.lookup.getClassFromClassLoader(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                if (this.ignoreSignaturesOfMissingClasses || localIgnoreMissingClasses) {
                    return;
                }
                if (report.reportClassNotFound) {
                    report.parseFailed(this.logger, String.format(Locale.ENGLISH, "Class '%s' not found on classpath", cnfe.getMessage()), signature);
                } else {
                    missingClasses.add(clazz);
                }
                return;
            }
            if (method != null) {
                assert (field == null);
                boolean found = false;
                for (Method m : c.methods) {
                    if (!m.getName().equals(method.getName()) || !WILDCARD_ARGS.equals(method.getDescriptor()) && !Arrays.equals(m.getArgumentTypes(), method.getArgumentTypes())) continue;
                    found = true;
                    this.signatures.put(Signatures.getKey(c.className, m), printout);
                }
                if (!found) {
                    report.parseFailed(this.logger, "Method not found", signature);
                    return;
                }
            } else if (field != null) {
                assert (method == null);
                if (!c.fields.contains(field)) {
                    report.parseFailed(this.logger, "Field not found", signature);
                    return;
                }
                this.signatures.put(Signatures.getKey(c.className, field), printout);
            } else {
                assert (field == null && method == null);
                this.signatures.put(Signatures.getKey(c.className), printout);
            }
        }
    }

    private void reportMissingSignatureClasses(Set<String> missingClasses) {
        if (missingClasses.isEmpty()) {
            return;
        }
        this.logger.warn("Some signatures were ignored because the following classes were not found on classpath:");
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (String s : missingClasses) {
            sb.append(count == 0 ? "  " : ", ").append(s);
            ++count;
            if (sb.length() < 70) continue;
            int remaining = missingClasses.size() - count;
            if (remaining <= 0) break;
            sb.append(",... (and ").append(remaining).append(" more).");
            break;
        }
        this.logger.warn(sb.toString());
    }

    private void addBundledSignatures(String name, String jdkTargetVersion, boolean logging, Set<String> missingClasses) throws IOException, ParseException {
        if (!name.matches("[A-Za-z0-9\\-\\.]+")) {
            throw new ParseException("Invalid bundled signature reference: " + name);
        }
        if ("jdk-non-portable".equals(name)) {
            if (logging) {
                this.logger.info("Reading bundled API signatures: " + name);
            }
            ++this.numberOfFiles;
            this.forbidNonPortableRuntime = true;
            return;
        }
        name = Signatures.fixTargetVersion(name);
        InputStream in = Checker.class.getResourceAsStream("signatures/" + name + ".txt");
        if (in == null && jdkTargetVersion != null && name.startsWith("jdk-") && !name.matches(".*?\\-\\d+(\\.\\d+)*")) {
            name = name + "-" + jdkTargetVersion;
            name = Signatures.fixTargetVersion(name);
            in = Checker.class.getResourceAsStream("signatures/" + name + ".txt");
        }
        if (in == null) {
            throw new FileNotFoundException("Bundled signatures resource not found: " + name);
        }
        if (logging) {
            this.logger.info("Reading bundled API signatures: " + name);
        }
        this.parseSignaturesStream(in, true, missingClasses);
    }

    private void parseSignaturesStream(InputStream in, boolean isBundled, Set<String> missingClasses) throws IOException, ParseException {
        this.parseSignaturesFile(new InputStreamReader(in, StandardCharsets.UTF_8), isBundled, missingClasses);
    }

    private void parseSignaturesFile(Reader reader, boolean isBundled, Set<String> missingClasses) throws IOException, ParseException {
        ++this.numberOfFiles;
        try (BufferedReader r = new BufferedReader(reader);){
            String line;
            String defaultMessage = null;
            UnresolvableReporting reporter = this.failOnUnresolvableSignatures ? UnresolvableReporting.FAIL : UnresolvableReporting.WARNING;
            boolean localIgnoreMissingClasses = false;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("@")) {
                    if (isBundled && line.startsWith(BUNDLED_PREFIX)) {
                        String name = line.substring(BUNDLED_PREFIX.length()).trim();
                        this.addBundledSignatures(name, null, false, missingClasses);
                        continue;
                    }
                    if (line.startsWith(DEFAULT_MESSAGE_PREFIX)) {
                        defaultMessage = line.substring(DEFAULT_MESSAGE_PREFIX.length()).trim();
                        if (defaultMessage.length() != 0) continue;
                        defaultMessage = null;
                        continue;
                    }
                    if (line.equals(IGNORE_UNRESOLVABLE_LINE)) {
                        if (isBundled) {
                            reporter = UnresolvableReporting.SILENT;
                            continue;
                        }
                        this.logger.warn(String.format(Locale.ENGLISH, "'%s' inside signatures files is deprecated, prefer using '%s' to ignore signatures where the class is missing.", IGNORE_UNRESOLVABLE_LINE, IGNORE_MISSING_CLASSES_LINE));
                        reporter = UnresolvableReporting.WARNING;
                        continue;
                    }
                    if (line.equals(IGNORE_MISSING_CLASSES_LINE)) {
                        localIgnoreMissingClasses = true;
                        continue;
                    }
                    throw new ParseException("Invalid line in signature file: " + line);
                }
                this.addSignature(line, defaultMessage, reporter, localIgnoreMissingClasses, missingClasses);
            }
        }
    }

    public void addBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        TreeSet<String> missingClasses = new TreeSet<String>();
        this.addBundledSignatures(name, jdkTargetVersion, true, missingClasses);
        this.reportMissingSignatureClasses(missingClasses);
    }

    public void parseSignaturesStream(InputStream in, String name) throws IOException, ParseException {
        this.logger.info("Reading API signatures: " + name);
        TreeSet<String> missingClasses = new TreeSet<String>();
        this.parseSignaturesStream(in, false, missingClasses);
        this.reportMissingSignatureClasses(missingClasses);
    }

    public void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.logger.info("Reading inline API signatures...");
        TreeSet<String> missingClasses = new TreeSet<String>();
        this.parseSignaturesFile(new StringReader(signatures), false, missingClasses);
        this.reportMissingSignatureClasses(missingClasses);
    }

    public boolean hasNoSignatures() {
        return 0 == this.signatures.size() + this.classPatterns.size() + (this.forbidNonPortableRuntime ? 1 : 0);
    }

    public boolean noSignaturesFilesParsed() {
        return this.numberOfFiles == 0;
    }

    public boolean isNonPortableRuntimeForbidden() {
        return this.forbidNonPortableRuntime;
    }

    private static String formatTypePrintout(String printout, String what) {
        return String.format(Locale.ENGLISH, "Forbidden %s use: %s", what, printout);
    }

    public String checkType(Type type, String what) {
        if (type.getSort() != 10) {
            return null;
        }
        String printout = this.signatures.get(Signatures.getKey(type.getInternalName()));
        if (printout != null) {
            return Signatures.formatTypePrintout(printout, what);
        }
        String binaryClassName = type.getClassName();
        for (ClassPatternRule r : this.classPatterns) {
            if (!r.matches(binaryClassName)) continue;
            return Signatures.formatTypePrintout(r.getPrintout(binaryClassName), what);
        }
        return null;
    }

    public String checkMethod(String internalClassName, Method method) {
        String printout = this.signatures.get(Signatures.getKey(internalClassName, method));
        return printout == null ? null : "Forbidden method invocation: ".concat(printout);
    }

    public String checkField(String internalClassName, String field) {
        String printout = this.signatures.get(Signatures.getKey(internalClassName, field));
        return printout == null ? null : "Forbidden field access: ".concat(printout);
    }

    public static String fixTargetVersion(String name) throws ParseException {
        Matcher m = JDK_SIG_PATTERN.matcher(name);
        if (m.matches()) {
            if (m.group(4) == null) {
                int minor;
                String prefix = m.group(1);
                int major = Integer.parseInt(m.group(2));
                int n = minor = m.group(3) != null ? Integer.parseInt(m.group(3).substring(1)) : 0;
                if (major == 1 && minor >= 1 && minor < 9) {
                    return prefix + "1." + minor;
                }
                if (major > 1 && major < 9) {
                    if (minor == 0) {
                        return prefix + "1." + major;
                    }
                } else {
                    if (major >= 9 && minor > 0) {
                        return prefix + major + "." + minor;
                    }
                    if (major >= 9 && minor == 0) {
                        return prefix + major;
                    }
                }
            }
            throw new ParseException("Invalid bundled signature reference (JDK version is invalid): " + name);
        }
        return name;
    }

    private static enum UnresolvableReporting {
        FAIL(true){

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
                throw new ParseException(String.format(Locale.ENGLISH, "%s while parsing signature: %s", message, signature));
            }
        }
        ,
        WARNING(false){

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
                logger.warn(String.format(Locale.ENGLISH, "%s while parsing signature: %s [signature ignored]", message, signature));
            }
        }
        ,
        SILENT(true){

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
            }
        };

        public final boolean reportClassNotFound;

        private UnresolvableReporting(boolean reportClassNotFound) {
            this.reportClassNotFound = reportClassNotFound;
        }

        public abstract void parseFailed(Logger var1, String var2, String var3) throws ParseException;
    }
}

