/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.managedproperty;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.faces.annotation.ManagedProperty;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.myfaces.cdi.managedproperty.ManagedPropertyInfo;
import org.apache.myfaces.cdi.managedproperty.ManagedPropertyProducer;

public class ManagedPropertyExtension
implements Extension {
    private Set<ManagedPropertyInfo> types = new HashSet<ManagedPropertyInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        for (AnnotatedField<T> field : event.getAnnotatedBeanClass().getFields()) {
            this.addAnnotatedTypeIfNecessary(field);
        }
    }

    private void addAnnotatedTypeIfNecessary(Annotated annotated) {
        if (annotated.isAnnotationPresent(ManagedProperty.class)) {
            Type type = annotated.getBaseType();
            this.types.add(new ManagedPropertyInfo(type, annotated.getAnnotation(ManagedProperty.class).value()));
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (ManagedPropertyInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean(new ManagedPropertyProducer(beanManager, typeInfo));
        }
    }

    public void cleanup(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        this.types.clear();
    }
}

