/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.ViewScoped;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorageHolder;
import org.apache.myfaces.view.ViewScopeProxyMap;

@Typed
public class ViewScopeContext
implements Context {
    private BeanManager beanManager;
    private boolean passivatingScope;

    public ViewScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.passivatingScope = beanManager.isPassivatingScope(this.getScope());
    }

    protected ViewScopeContextualStorageHolder getStorageHolder(FacesContext facesContext) {
        return ViewScopeContextualStorageHolder.getInstance(facesContext, true);
    }

    public String getCurrentViewScopeId(boolean create) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewScopeProxyMap map = (ViewScopeProxyMap)facesContext.getViewRoot().getViewMap(create);
        if (map != null) {
            String id = map.getViewScopeId();
            if (id == null && create) {
                map.forceDelegateCreation(facesContext);
                id = map.getViewScopeId();
            }
            return id;
        }
        return null;
    }

    protected ContextualStorage getContextualStorage(FacesContext facesContext, boolean createIfNotExist) {
        String viewScopeId = this.getCurrentViewScopeId(createIfNotExist);
        if (createIfNotExist && viewScopeId == null) {
            throw new ContextNotActiveException(this.getClass().getSimpleName() + ": no viewScopeId set for the current view yet!");
        }
        if (viewScopeId != null) {
            return this.getStorageHolder(facesContext).getContextualStorage(viewScopeId, createIfNotExist);
        }
        return null;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    @Override
    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        return facesContext != null && facesContext.getViewRoot() != null;
    }

    @Override
    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        facesContext.getExternalContext().getSession(true);
        ContextualStorage storage = this.getContextualStorage(facesContext, false);
        if (storage == null) {
            return null;
        }
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return null;
        }
        return (T)contextualInstanceInfo.getContextualInstance();
    }

    @Override
    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (this.passivatingScope && !(bean instanceof PassivationCapable)) {
            throw new IllegalStateException(bean.toString() + " doesn't implement " + PassivationCapable.class.getName());
        }
        facesContext.getExternalContext().getSession(true);
        ContextualStorage storage = this.getContextualStorage(facesContext, true);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    public boolean destroy(Contextual bean) {
        ContextualStorage storage = this.getContextualStorage(FacesContext.getCurrentInstance(), false);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public static void destroyAll(FacesContext facesContext) {
        ViewScopeContextualStorageHolder storageHolder = ViewScopeContextualStorageHolder.getInstance(facesContext);
        if (storageHolder != null) {
            storageHolder.destroyAll(facesContext);
        }
    }

    public static void destroyAll(FacesContext facesContext, String viewScopeId) {
        ViewScopeContextualStorageHolder storageHolder = ViewScopeContextualStorageHolder.getInstance(facesContext);
        if (storageHolder != null) {
            storageHolder.destroyAll(facesContext, viewScopeId);
        }
    }
}

