/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIColumn;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIData;
import jakarta.faces.component.behavior.AjaxBehavior;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.LabelLayout;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.component.UIOut;
import org.apache.myfaces.tobago.component.UIPaginatorList;
import org.apache.myfaces.tobago.component.UIPaginatorPage;
import org.apache.myfaces.tobago.component.UIPaginatorRow;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.event.SortActionEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumn;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnNode;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnPanel;
import org.apache.myfaces.tobago.internal.component.AbstractUIColumnSelector;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.component.AbstractUIOut;
import org.apache.myfaces.tobago.internal.component.AbstractUIPaginator;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.component.AbstractUIRow;
import org.apache.myfaces.tobago.internal.component.AbstractUISheet;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.context.Nonce;
import org.apache.myfaces.tobago.internal.layout.Cell;
import org.apache.myfaces.tobago.internal.layout.Grid;
import org.apache.myfaces.tobago.internal.layout.OriginCell;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.JsonUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.layout.Arrows;
import org.apache.myfaces.tobago.layout.Measure;
import org.apache.myfaces.tobago.layout.MeasureList;
import org.apache.myfaces.tobago.layout.PaginatorMode;
import org.apache.myfaces.tobago.layout.ShowPosition;
import org.apache.myfaces.tobago.layout.TextAlign;
import org.apache.myfaces.tobago.model.Selectable;
import org.apache.myfaces.tobago.model.SheetState;
import org.apache.myfaces.tobago.model.SortedColumn;
import org.apache.myfaces.tobago.model.SortedColumnList;
import org.apache.myfaces.tobago.renderkit.RendererBase;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.HtmlInputTypes;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.util.ResourceUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SheetRenderer<T extends AbstractUISheet>
extends RendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SUFFIX_WIDTHS = "::widths";
    private static final String SUFFIX_COLUMN_RENDERED = "::rendered";
    private static final String SUFFIX_SCROLL_POSITION = "::scrollPosition";
    private static final String SUFFIX_SELECTED = "::selected";
    private static final String SUFFIX_LAZY = ":pageActionlazy";
    private static final String SUFFIX_LAZY_SCROLL_POSITION = "::lazyScrollPosition";
    private static final String SUFFIX_COLUMN_SELECTOR = "::columnSelector";

    @Override
    public void decodeInternal(FacesContext facesContext, T component) {
        String value;
        List<AbstractUIColumnBase> columns = ((AbstractUISheet)component).getAllColumns();
        String clientId = component.getClientId(facesContext);
        Object key = clientId + SUFFIX_WIDTHS;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        SheetState state = ((AbstractUISheet)component).getState();
        if (requestParameterMap.containsKey(key)) {
            String widths = (String)requestParameterMap.get(key);
            this.ensureColumnWidthsSize(state.getColumnWidths(), columns, JsonUtils.decodeIntegerArray(widths));
        }
        if (requestParameterMap.containsKey(key = clientId + SUFFIX_SELECTED)) {
            List<Integer> selectedRows;
            String selected = (String)requestParameterMap.get(key);
            if (LOG.isDebugEnabled()) {
                LOG.debug("selected = " + selected);
            }
            try {
                selectedRows = JsonUtils.decodeIntegerArray(selected);
            }
            catch (NumberFormatException e) {
                LOG.warn(selected, (Throwable)e);
                selectedRows = Collections.emptyList();
            }
            ComponentUtils.setAttribute(component, Attributes.selectedListString, selectedRows);
        }
        if (((AbstractUISheet)component).isLazy()) {
            String lazyScrollPosition;
            if (component.getRows() > 0) {
                component.setRows(0);
                LOG.warn("The 'rows' attribute must not be used for lazy sheets. Use 'lazyRows' instead. SheetId={}", (Object)component.getClientId(facesContext));
            }
            if ((lazyScrollPosition = (String)requestParameterMap.get(clientId + SUFFIX_LAZY_SCROLL_POSITION)) != null) {
                state.getLazyScrollPosition().update(lazyScrollPosition);
            }
            if (((AbstractUISheet)component).isLazyUpdate(facesContext)) {
                ((AbstractUISheet)component).setLazyUpdate(true);
                key = "tobago.sheet.lazyFirstRow";
                if (requestParameterMap.containsKey(key)) {
                    ((AbstractUISheet)component).setLazyFirstRow(Integer.parseInt((String)requestParameterMap.get(key)));
                }
                facesContext.renderResponse();
            }
        }
        if ((value = (String)requestParameterMap.get(clientId + SUFFIX_SCROLL_POSITION)) != null) {
            state.getScrollPosition().update(value);
        }
        RenderUtils.decodedStateOfTreeData(facesContext, component);
        this.decodeColumnAction(facesContext, columns);
    }

    private void decodeColumnAction(FacesContext facesContext, List<AbstractUIColumnBase> columns) {
        for (AbstractUIColumnBase column : columns) {
            boolean sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable);
            if (!sortable) continue;
            String sourceId = (String)facesContext.getExternalContext().getRequestParameterMap().get("jakarta.faces.source");
            String columnId = column.getClientId(facesContext);
            String sorterId = columnId + "_sorter";
            if (!sorterId.equals(sourceId)) continue;
            UIData data = (UIData)column.getParent();
            data.queueEvent((FacesEvent)new SortActionEvent(data, column));
        }
    }

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        String sheetId = component.getClientId(facesContext);
        Markup markup = component.getMarkup();
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        PaginatorMode paginator = ((AbstractUISheet)component).getPaginator();
        LOG.debug("paginator={}", (Object)paginator);
        switch (paginator) {
            case list: 
            case auto: {
                UIComponent after = SheetRenderer.ensureAfterFacetPaginator(facesContext, component);
                if (after.getChildCount() != 0) break;
                UIPaginatorList paginatorList = (UIPaginatorList)ComponentUtils.createComponent(facesContext, Tags.paginatorList.componentType(), RendererTypes.PaginatorList, "_paginator_list");
                after.getChildren().add(paginatorList);
                break;
            }
            case page: {
                UIComponent after = SheetRenderer.ensureAfterFacetPaginator(facesContext, component);
                if (after.getChildCount() != 0) break;
                UIPaginatorPage paginatorPage = (UIPaginatorPage)ComponentUtils.createComponent(facesContext, Tags.paginatorPage.componentType(), RendererTypes.PaginatorPage, "_paginator_page");
                after.getChildren().add(paginatorPage);
                break;
            }
            case row: {
                UIComponent after = SheetRenderer.ensureAfterFacetPaginator(facesContext, component);
                if (after.getChildCount() != 0) break;
                UIPaginatorRow paginatorRow = (UIPaginatorRow)ComponentUtils.createComponent(facesContext, Tags.paginatorRow.componentType(), RendererTypes.PaginatorRow, "_paginator_row");
                after.getChildren().add(paginatorRow);
                break;
            }
            case useShowAttributes: {
                ShowPosition pagePosition;
                ShowPosition listPosition;
                boolean initialized;
                boolean bl = initialized = component.getAttributes().get("useShowAttributesInitialized") != null;
                if (initialized) break;
                HashMap<ShowPosition, AbstractUIPaginator> paginatorMap = new HashMap<ShowPosition, AbstractUIPaginator>();
                ShowPosition rangePosition = ((AbstractUISheet)component).getShowRowRange();
                if (!ShowPosition.none.equals((Object)rangePosition) && ((AbstractUISheet)component).isPagingVisible()) {
                    UIPaginatorRow paginatorRow = (UIPaginatorRow)ComponentUtils.createComponent(facesContext, Tags.paginatorRow.componentType(), RendererTypes.PaginatorRow, "_paginator_row");
                    paginatorRow.setAlwaysVisible(((AbstractUISheet)component).isShowPagingAlways());
                    paginatorMap.put(rangePosition, paginatorRow);
                }
                if (!ShowPosition.none.equals((Object)(listPosition = ((AbstractUISheet)component).getShowDirectLinks())) && ((AbstractUISheet)component).isPagingVisible()) {
                    UIPaginatorList paginatorList = (UIPaginatorList)ComponentUtils.createComponent(facesContext, Tags.paginatorList.componentType(), RendererTypes.PaginatorList, "_paginator_list");
                    paginatorList.setAlwaysVisible(((AbstractUISheet)component).isShowPagingAlways());
                    paginatorList.setArrows(((AbstractUISheet)component).isShowDirectLinksArrows() ? Arrows.show : Arrows.hide);
                    paginatorList.setMax(((AbstractUISheet)component).getDirectLinkCount());
                    paginatorMap.put(listPosition, paginatorList);
                }
                if (!ShowPosition.none.equals((Object)(pagePosition = ((AbstractUISheet)component).getShowPageRange())) && ((AbstractUISheet)component).isPagingVisible()) {
                    UIPaginatorPage paginatorPage = (UIPaginatorPage)ComponentUtils.createComponent(facesContext, Tags.paginatorPage.componentType(), RendererTypes.PaginatorPage, "_paginator_page");
                    paginatorPage.setAlwaysVisible(((AbstractUISheet)component).isShowPagingAlways());
                    paginatorMap.put(pagePosition, paginatorPage);
                }
                if (!paginatorMap.isEmpty()) {
                    ShowPosition[] order;
                    UIComponent after = SheetRenderer.ensureAfterFacetPaginator(facesContext, component);
                    for (ShowPosition showPosition : order = new ShowPosition[]{ShowPosition.left, ShowPosition.center, ShowPosition.right}) {
                        if (paginatorMap.containsKey((Object)showPosition)) {
                            after.getChildren().add((UIComponent)paginatorMap.get((Object)showPosition));
                            continue;
                        }
                        UIOut space = (UIOut)ComponentUtils.createComponent(facesContext, Tags.out.componentType(), RendererTypes.Out, "_space_" + showPosition.name());
                        after.getChildren().add(space);
                    }
                }
                component.getAttributes().put("useShowAttributesInitialized", Boolean.TRUE);
                break;
            }
            case custom: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown paginator mode: " + String.valueOf((Object)paginator));
            }
        }
        UIComponent header = component.getHeader();
        if (header == null) {
            header = ComponentUtils.createComponent(facesContext, Tags.panel.componentType(), null, "_header");
            header.setTransient(true);
            List<AbstractUIColumnBase> columns = ((AbstractUISheet)component).getAllColumns();
            int i = 0;
            for (AbstractUIColumnBase column : columns) {
                if (!(column instanceof AbstractUIRow)) {
                    UIComponent labelFacet = ComponentUtils.getFacet((UIComponent)column, Facets.label);
                    AbstractUIOut out = (AbstractUIOut)ComponentUtils.createComponent(facesContext, Tags.out.componentType(), RendererTypes.Out, "_col" + i);
                    out.setTransient(true);
                    if (labelFacet == null) {
                        out.setValue(ComponentUtils.getAttribute((UIComponent)column, Attributes.label));
                    }
                    out.setRendered(column.isRendered());
                    out.setLabelLayout(LabelLayout.skip);
                    header.getChildren().add(out);
                }
                ++i;
            }
            component.setHeader(header);
        }
        ((AbstractUISheet)component).init(facesContext);
        this.insideBegin(facesContext, HtmlElements.TOBAGO_SHEET);
        writer.startElement(HtmlElements.TOBAGO_SHEET);
        writer.writeIdAttribute(sheetId);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        writer.writeClassAttribute(component.getCustomClass(), markup != null && markup.contains(Markup.SPREAD) ? TobagoClass.SPREAD : null);
        writer.writeAttribute(DataAttributes.SELECTION_MODE, ((AbstractUIData)component).getSelectable().name(), false);
        writer.writeAttribute(DataAttributes.FIRST, Integer.toString(component.getFirst()), false);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.ROWS, component.getRows());
        writer.writeAttribute(CustomAttributes.ROW_COUNT, Integer.toString(component.getRowCount()), false);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.LAZY, ((AbstractUISheet)component).isLazy());
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.LAZY_ROWS, ((AbstractUISheet)component).isLazy() ? ((AbstractUISheet)component).getLazyRows() : null);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.LAZY_UPDATE, ((AbstractUISheet)component).getLazyUpdate());
        boolean autoLayout = ((AbstractUISheet)component).isAutoLayout();
        if (!autoLayout) {
            writer.writeAttribute(DataAttributes.LAYOUT, JsonUtils.encode(((AbstractUISheet)component).getColumnLayout(), "columns"), true);
        }
        this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        AbstractUIReload reload = ComponentUtils.getReloadFacet(component);
        if (reload != null) {
            reload.encodeAll(facesContext);
        }
    }

    private static <T extends AbstractUISheet> UIComponent ensureAfterFacetPaginator(FacesContext facesContext, T component) {
        UIComponent after = component.getFacet("after");
        if (after == null) {
            after = ComponentUtils.createComponent(facesContext, Tags.paginatorPanel.componentType(), RendererTypes.PaginatorPanel, "_after");
            component.getFacets().put("after", after);
        }
        return after;
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        for (UIComponent child : component.getChildren()) {
            if (!(child instanceof AbstractUIStyle)) continue;
            child.encodeAll(facesContext);
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        UIComponent after;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        String sheetId = component.getClientId(facesContext);
        Selectable selectable = ((AbstractUIData)component).getSelectable();
        SheetState state = ((AbstractUISheet)component).getSheetState(facesContext);
        List<Integer> columnWidths = ((AbstractUISheet)component).getState().getColumnWidths();
        boolean definedColumnWidths = ((AbstractUISheet)component).getState().isDefinedColumnWidths();
        List<Integer> selectedRows = this.getSelectedRows((AbstractUISheet)component, state);
        List<AbstractUIColumnBase> columns = ((AbstractUISheet)component).getAllColumns();
        boolean autoLayout = ((AbstractUISheet)component).isAutoLayout();
        this.ensureColumnWidthsSize(columnWidths, columns, Collections.emptyList());
        if (!autoLayout) {
            this.encodeHiddenInput(writer, JsonUtils.encode(definedColumnWidths ? columnWidths : Collections.emptyList()), sheetId + SUFFIX_WIDTHS);
            ArrayList<Boolean> encodedRendered = new ArrayList<Boolean>();
            for (AbstractUIColumnBase column : columns) {
                if (column instanceof AbstractUIRow || column instanceof AbstractUIColumnPanel) continue;
                encodedRendered.add(column.isRendered());
            }
            this.encodeHiddenInput(writer, JsonUtils.encode(encodedRendered.toArray(new Boolean[0])), sheetId + SUFFIX_COLUMN_RENDERED);
        }
        this.encodeHiddenInput(writer, ((AbstractUISheet)component).getState().getScrollPosition().encode(), component.getClientId(facesContext) + SUFFIX_SCROLL_POSITION);
        this.encodeHiddenInput(writer, JsonUtils.encode(selectedRows), sheetId + SUFFIX_SELECTED);
        if (((AbstractUISheet)component).isLazy()) {
            this.encodeHiddenInput(writer, null, sheetId + SUFFIX_LAZY);
            this.encodeHiddenInput(writer, state.getLazyScrollPosition().encode(), sheetId + SUFFIX_LAZY_SCROLL_POSITION);
        }
        ArrayList<Integer> expandedValue = ((AbstractUIData)component).isTreeModel() ? new ArrayList<Integer>() : null;
        this.encodeTableHeader(facesContext, (AbstractUISheet)component, writer, columnWidths, columns, autoLayout);
        this.encodeTableBody(facesContext, (AbstractUISheet)component, writer, sheetId, selectable, columnWidths, selectedRows, columns, autoLayout, (List<Integer>)expandedValue);
        if (((AbstractUISheet)component).isPagingVisible()) {
            writer.startElement(HtmlElements.FOOTER);
            writer.endElement(HtmlElements.FOOTER);
        }
        if ((after = component.getFacet("after")) != null) {
            after.encodeAll(facesContext);
        }
        if (((AbstractUIData)component).isTreeModel()) {
            writer.startElement(HtmlElements.INPUT);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
            String expandedId = sheetId + "::expanded";
            writer.writeNameAttribute(expandedId);
            writer.writeIdAttribute(expandedId);
            writer.writeClassAttribute(TobagoClass.EXPANDED);
            writer.writeAttribute(HtmlAttributes.VALUE, JsonUtils.encode(expandedValue), false);
            writer.endElement(HtmlElements.INPUT);
        }
        writer.endElement(HtmlElements.TOBAGO_SHEET);
        UIComponent header = component.getHeader();
        if (header.isTransient()) {
            component.getFacets().remove("header");
        }
        this.insideEnd(facesContext, HtmlElements.TOBAGO_SHEET);
    }

    private void encodeTableHeader(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, List<Integer> columnWidths, List<AbstractUIColumnBase> columns, boolean autoLayout) throws IOException {
        boolean nonLazyUpdate;
        boolean showHeader = sheet.isShowHeader();
        Markup sheetMarkup = sheet.getMarkup() != null ? sheet.getMarkup() : Markup.NULL;
        boolean bl = nonLazyUpdate = !sheet.isLazyUpdate(facesContext);
        if (nonLazyUpdate) {
            UIComponent before = sheet.getFacet("before");
            if (before != null) {
                before.encodeAll(facesContext);
            }
            if (showHeader && !autoLayout) {
                writer.startElement(HtmlElements.HEADER);
                writer.startElement(HtmlElements.TABLE);
                writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
                writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
                writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
                writer.writeClassAttribute(BootstrapClass.TABLE, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, TobagoClass.TABLE_LAYOUT__FIXED);
                this.writeColgroup(facesContext, sheet, writer, columnWidths, columns, true);
                writer.startElement(HtmlElements.THEAD);
                this.encodeHeaderRows(facesContext, sheet, writer, columns);
                writer.endElement(HtmlElements.THEAD);
                writer.endElement(HtmlElements.TABLE);
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(TobagoClass.SCROLLBAR__FILLER, BootstrapClass.TABLE, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.HEADER);
            }
        }
    }

    private void encodeTableBody(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, String sheetId, Selectable selectable, List<Integer> columnWidths, List<Integer> selectedRows, List<AbstractUIColumnBase> columns, boolean autoLayout, List<Integer> expandedValue) throws IOException {
        int first;
        boolean showHeader = sheet.isShowHeader();
        Markup sheetMarkup = sheet.getMarkup() != null ? sheet.getMarkup() : Markup.NULL;
        boolean nonLazyUpdate = !sheet.isLazyUpdate(facesContext);
        writer.startElement(HtmlElements.DIV);
        writer.writeClassAttribute(TobagoClass.BODY);
        writer.startElement(HtmlElements.TABLE);
        writer.writeAttribute(HtmlAttributes.CELLSPACING, "0", false);
        writer.writeAttribute(HtmlAttributes.CELLPADDING, "0", false);
        writer.writeAttribute(HtmlAttributes.SUMMARY, "", false);
        writer.writeClassAttribute(BootstrapClass.TABLE, sheetMarkup.contains(Markup.DARK) ? BootstrapClass.TABLE_DARK : null, sheetMarkup.contains(Markup.STRIPED) ? BootstrapClass.TABLE_STRIPED : null, sheetMarkup.contains(Markup.BORDERED) ? BootstrapClass.TABLE_BORDERED : null, sheetMarkup.contains(Markup.HOVER) ? BootstrapClass.TABLE_HOVER : null, sheetMarkup.contains(Markup.SMALL) ? BootstrapClass.TABLE_SM : null, !autoLayout ? TobagoClass.TABLE_LAYOUT__FIXED : null);
        if (nonLazyUpdate) {
            if (showHeader && autoLayout) {
                writer.startElement(HtmlElements.THEAD);
                this.encodeHeaderRows(facesContext, sheet, writer, columns);
                writer.endElement(HtmlElements.THEAD);
            }
            if (!autoLayout) {
                this.writeColgroup(facesContext, sheet, writer, columnWidths, columns, false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("first = " + sheet.getFirst() + "   rows = " + sheet.getRows());
        }
        writer.startElement(HtmlElements.TBODY);
        String var = sheet.getVar();
        boolean emptySheet = true;
        int n = first = sheet.isLazy() ? sheet.getLazyFirstRow() : sheet.getFirst();
        int last = sheet.isLazy() ? sheet.getLazyFirstRow() + sheet.getLazyRows() : (sheet.isRowsUnlimited() ? Integer.MAX_VALUE : sheet.getFirst() + sheet.getRows());
        AbstractUIRow row = null;
        boolean[] columnRendered = new boolean[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = columns.get(i);
            if (!column.isRendered()) continue;
            columnRendered[i] = true;
            if (!(column instanceof AbstractUIRow)) continue;
            row = (AbstractUIRow)column;
        }
        for (int rowIndex = first; rowIndex < last; ++rowIndex) {
            sheet.setRowIndex(rowIndex);
            if (!sheet.isRowAvailable()) break;
            Object rowRendered = sheet.getAttributes().get("rowRendered");
            if (rowRendered instanceof Boolean && !((Boolean)rowRendered).booleanValue()) continue;
            emptySheet = false;
            if (LOG.isDebugEnabled()) {
                LOG.debug("var       " + var);
                LOG.debug("list      " + String.valueOf(sheet.getValue()));
            }
            if (sheet.isTreeModel() && sheet.isFolder() && sheet.getExpandedState().isExpanded(sheet.getPath())) {
                expandedValue.add(rowIndex);
            }
            writer.startElement(HtmlElements.TR);
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.ROW_INDEX, rowIndex);
            boolean bl = selectedRows.contains(rowIndex);
            String parentId = sheet.getRowParentClientId();
            if (parentId != null) {
                writer.writeAttribute(DataAttributes.TREE_PARENT, parentId, false);
            }
            writer.writeIdAttribute(row != null ? row.getClientId(facesContext) : sheet.getRowClientId());
            writer.writeClassAttribute(bl ? TobagoClass.SELECTED : null, bl ? BootstrapClass.TABLE_INFO : null, row != null ? row.getCustomClass() : null, sheet.isRowVisible() ? null : BootstrapClass.D_NONE);
            int colSpan = 0;
            AbstractUIColumnPanel panel = null;
            for (int i = 0; i < columns.size(); ++i) {
                AbstractUIColumnBase column = columns.get(i);
                if (!columnRendered[i]) continue;
                if (column instanceof AbstractUIColumn || column instanceof AbstractUIColumnSelector || column instanceof AbstractUIColumnNode) {
                    ++colSpan;
                    writer.startElement(HtmlElements.TD);
                    Markup markup = column.getMarkup();
                    if (markup == null) {
                        markup = Markup.NULL;
                    }
                    writer.writeClassAttribute(BootstrapClass.textAlign(column instanceof AbstractUIColumn ? ((AbstractUIColumn)column).getAlign() : null), BootstrapClass.verticalAlign(column instanceof AbstractUIColumn ? ((AbstractUIColumn)column).getVerticalAlign() : null), column.getCustomClass());
                    if (column instanceof AbstractUIColumnSelector) {
                        AbstractUIColumnSelector selector = (AbstractUIColumnSelector)column;
                        writer.startElement(HtmlElements.INPUT);
                        writer.writeNameAttribute(sheetId + "_data_row_selector_" + rowIndex);
                        Selectable currentSelectable = SheetRenderer.getSelectionMode(selectable, selector);
                        if (currentSelectable.isSingle()) {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.RADIO);
                        } else {
                            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                        }
                        writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.selectRow"), true);
                        writer.writeAttribute(Arias.LABEL, ResourceUtils.getString(facesContext, "sheet.selectRow"), true);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.CHECKED, bl);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, selector.isDisabled());
                        writer.writeClassAttribute(BootstrapClass.FORM_CHECK_INLINE, TobagoClass.SELECTED);
                        writer.endElement(HtmlElements.INPUT);
                    } else if (column instanceof AbstractUIColumnNode) {
                        column.encodeAll(facesContext);
                    } else {
                        int childCount = column.getChildCount();
                        if (childCount > 0) {
                            List children = column.getChildren();
                            for (int k = 0; k < childCount; ++k) {
                                ((UIComponent)children.get(k)).encodeAll(facesContext);
                            }
                        }
                    }
                    writer.endElement(HtmlElements.TD);
                    continue;
                }
                if (!(column instanceof AbstractUIColumnPanel)) continue;
                panel = (AbstractUIColumnPanel)column;
            }
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.writeClassAttribute(TobagoClass.ROW__FILLER);
                writer.endElement(HtmlElements.TD);
                ++colSpan;
            }
            writer.startElement(HtmlElements.TD);
            writer.writeClassAttribute(TobagoClass.BEHAVIOR__CONTAINER);
            this.encodeBehavior(writer, facesContext, row);
            writer.endElement(HtmlElements.TD);
            writer.endElement(HtmlElements.TR);
            if (panel == null) continue;
            writer.startElement(HtmlElements.TR);
            writer.writeNameAttribute(String.valueOf(rowIndex));
            writer.writeClassAttribute(TobagoClass.COLUMN__PANEL, panel.getCustomClass());
            writer.startElement(HtmlElements.TD);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, colSpan);
            panel.encodeAll(facesContext);
            writer.endElement(HtmlElements.TD);
            writer.endElement(HtmlElements.TR);
        }
        sheet.setRowIndex(-1);
        writer.endElement(HtmlElements.TBODY);
        if (emptySheet && showHeader) {
            writer.startElement(HtmlElements.TFOOT);
            writer.startElement(HtmlElements.TR);
            writer.writeClassAttribute(TobagoClass.NO__ENTRIES);
            int countColumns = 0;
            for (UIColumn uIColumn : columns) {
                if (uIColumn instanceof AbstractUIRow) continue;
                ++countColumns;
            }
            writer.startElement(HtmlElements.TD);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, countColumns);
            UIComponent emptyFacet = ComponentUtils.getFacet((UIComponent)sheet, Facets.empty);
            if (emptyFacet != null) {
                emptyFacet.encodeAll(facesContext);
            } else {
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(BootstrapClass.TEXT_CENTER);
                writer.writeText(ResourceUtils.getString(facesContext, "sheet.empty"));
                writer.endElement(HtmlElements.DIV);
            }
            writer.endElement(HtmlElements.TD);
            if (!autoLayout) {
                writer.startElement(HtmlElements.TD);
                writer.startElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.DIV);
                writer.endElement(HtmlElements.TD);
            }
            writer.endElement(HtmlElements.TR);
            writer.endElement(HtmlElements.TFOOT);
        }
        writer.endElement(HtmlElements.TABLE);
        writer.endElement(HtmlElements.DIV);
    }

    private static Selectable getSelectionMode(Selectable selectable, AbstractUIColumnSelector selector) {
        Selectable selectorSelectable;
        if (selectable == Selectable.none && (selectorSelectable = selector.getSelectable()) != null) {
            return selectorSelectable;
        }
        return selectable;
    }

    private void encodeHiddenInput(TobagoResponseWriter writer, String value, String idWithSuffix) throws IOException {
        writer.startElement(HtmlElements.INPUT);
        writer.writeIdAttribute(idWithSuffix);
        writer.writeNameAttribute(idWithSuffix);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
        writer.writeAttribute(HtmlAttributes.VALUE, value, false);
        writer.endElement(HtmlElements.INPUT);
    }

    private void ensureColumnWidthsSize(List<Integer> columnWidths, List<AbstractUIColumnBase> columns, List<Integer> samples) {
        int i = 0;
        int j = 0;
        for (AbstractUIColumnBase column : columns) {
            Integer newValue;
            if (column instanceof AbstractUIRow) continue;
            if (j < samples.size()) {
                newValue = samples.get(j);
                ++j;
            } else {
                newValue = null;
            }
            if (columnWidths.size() > i) {
                if (newValue != null) {
                    columnWidths.set(i, newValue);
                }
            } else {
                columnWidths.add(newValue != null ? newValue : -1);
            }
            ++i;
        }
    }

    private void encodeHeaderRows(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, List<AbstractUIColumnBase> columns) throws IOException {
        String sheetClientId = sheet.getClientId(facesContext);
        Selectable selectable = sheet.getSelectable();
        Grid grid = sheet.getHeaderGrid();
        boolean autoLayout = sheet.isAutoLayout();
        boolean multiHeader = grid.getRowCount() > 1;
        int offset = 0;
        for (int i = 0; i < grid.getRowCount(); ++i) {
            writer.startElement(HtmlElements.TR);
            AbstractUIRow row = ComponentUtils.findChild((UIComponent)sheet, AbstractUIRow.class);
            if (row != null) {
                writer.writeClassAttribute(row.getCustomClass());
            }
            for (int j = 0; j < columns.size(); ++j) {
                UIComponent bar;
                AbstractUIColumnBase column = columns.get(j);
                if (!column.isRendered() || column instanceof AbstractUIRow || column instanceof AbstractUIColumnPanel) {
                    ++offset;
                    continue;
                }
                Cell cell = grid.getCell(j - offset, i);
                if (!(cell instanceof OriginCell)) continue;
                writer.startElement(HtmlElements.TH);
                writer.writeIdAttribute(column.getClientId(facesContext) + (String)(multiHeader ? "::" + cell.getComponent().getId() : ""));
                if (cell.getColumnSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.COLSPAN, cell.getColumnSpan());
                }
                if (cell.getRowSpan() > 1) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.ROWSPAN, cell.getRowSpan());
                }
                UIComponent cellComponent = cell.getComponent();
                TextAlign align = multiHeader && cell.getColumnSpan() > 1 ? TextAlign.center : (column instanceof AbstractUIColumn ? ((AbstractUIColumn)column).getAlign() : null);
                writer.writeClassAttribute(BootstrapClass.textAlign(align), column.getCustomClass());
                writer.startElement(HtmlElements.SPAN);
                boolean sortable = false;
                boolean ascending = false;
                boolean descending = false;
                TobagoClass sortPosition = null;
                Object tip = ComponentUtils.getStringAttribute((UIComponent)column, Attributes.tip);
                CommandMap behaviorCommands = null;
                if (cell.getColumnSpan() == 1 && cellComponent instanceof AbstractUIOut && (sortable = ComponentUtils.getBooleanAttribute((UIComponent)column, Attributes.sortable))) {
                    AbstractUILink sortCommand = (AbstractUILink)ComponentUtils.getFacet((UIComponent)column, Facets.sorter);
                    if (sortCommand == null) {
                        column.getClientId(facesContext);
                        String sorterId = column.getId() + "_sorter";
                        sortCommand = (AbstractUILink)ComponentUtils.createComponent(facesContext, Tags.link.componentType(), RendererTypes.Link, sorterId);
                        sortCommand.setTransient(true);
                        AjaxBehavior reloadBehavior = sheet.createReloadBehavior(sheet);
                        sortCommand.addClientBehavior("click", (ClientBehavior)reloadBehavior);
                        ComponentUtils.setFacet((UIComponent)column, Facets.sorter, (UIComponent)sortCommand);
                    }
                    writer.writeIdAttribute(sortCommand.getClientId(facesContext));
                    behaviorCommands = this.getBehaviorCommands(facesContext, sortCommand);
                    ComponentUtils.removeFacet((UIComponent)column, Facets.sorter);
                    tip = tip == null ? "" : (String)tip + " - ";
                    tip = (String)tip + ResourceUtils.getString(facesContext, "sheet.sorting");
                    SheetState sheetState = sheet.getSheetState(facesContext);
                    SortedColumnList sortedColumnList = sheetState.getSortedColumnList();
                    int index = sortedColumnList.indexOf(column.getId());
                    if (index >= 0) {
                        if (sortedColumnList.isShowNumbers()) {
                            switch (index) {
                                case 0: {
                                    sortPosition = TobagoClass.CIRCLE__1;
                                    break;
                                }
                                case 1: {
                                    sortPosition = TobagoClass.CIRCLE__2;
                                    break;
                                }
                                case 2: {
                                    sortPosition = TobagoClass.CIRCLE__3;
                                    break;
                                }
                                case 3: {
                                    sortPosition = TobagoClass.CIRCLE__4;
                                    break;
                                }
                                case 4: {
                                    sortPosition = TobagoClass.CIRCLE__5;
                                    break;
                                }
                                case 5: {
                                    sortPosition = TobagoClass.CIRCLE__6;
                                    break;
                                }
                                case 6: {
                                    sortPosition = TobagoClass.CIRCLE__7;
                                    break;
                                }
                                case 7: {
                                    sortPosition = TobagoClass.CIRCLE__8;
                                    break;
                                }
                                case 8: {
                                    sortPosition = TobagoClass.CIRCLE__9;
                                    break;
                                }
                                default: {
                                    LOG.warn("Index {} not supported!", (Object)index);
                                }
                            }
                        }
                        SortedColumn sortedColumn = sortedColumnList.get(index);
                        if (Objects.equals(column.getId(), sortedColumn.getId())) {
                            String sortTitle;
                            if (sortedColumn.isAscending()) {
                                sortTitle = ResourceUtils.getString(facesContext, "sheet.ascending");
                                ascending = true;
                            } else {
                                sortTitle = ResourceUtils.getString(facesContext, "sheet.descending");
                                descending = true;
                            }
                            tip = (String)tip + " - " + sortTitle;
                        }
                    }
                }
                writer.writeClassAttribute(sortable ? TobagoClass.SORTABLE : null, ascending ? TobagoClass.ASCENDING : null, descending ? TobagoClass.DESCENDING : null, sortPosition);
                writer.writeAttribute(HtmlAttributes.TITLE, (String)tip, true);
                this.encodeBehavior(writer, behaviorCommands);
                if (column instanceof AbstractUIColumnSelector) {
                    AbstractUIColumnSelector selector = (AbstractUIColumnSelector)column;
                    Selectable currentSelectable = SheetRenderer.getSelectionMode(selectable, selector);
                    writer.startElement(HtmlElements.INPUT);
                    if (currentSelectable.isMulti()) {
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.CHECKBOX);
                        writer.writeAttribute(HtmlAttributes.TITLE, ResourceUtils.getString(facesContext, "sheet.selectAll"), true);
                        writer.writeAttribute(Arias.LABEL, ResourceUtils.getString(facesContext, "sheet.selectAll"), true);
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, selector.isDisabled());
                    } else {
                        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlInputTypes.HIDDEN);
                    }
                    writer.writeNameAttribute(sheetClientId + SUFFIX_COLUMN_SELECTOR);
                    writer.writeClassAttribute(TobagoClass.SELECTED);
                    writer.writeAttribute(DataAttributes.SELECTION_MODE, currentSelectable.name(), false);
                    writer.endElement(HtmlElements.INPUT);
                } else if (ComponentUtils.getFacet((UIComponent)column, Facets.label) == null) {
                    cellComponent.encodeAll(facesContext);
                }
                UIComponent label = ComponentUtils.getFacet((UIComponent)column, Facets.label);
                if (label != null) {
                    this.insideBegin(facesContext, Facets.label);
                    label.encodeAll(facesContext);
                    this.insideEnd(facesContext, Facets.label);
                }
                writer.endElement(HtmlElements.SPAN);
                if (!autoLayout && column.isResizable()) {
                    this.encodeResizing(writer, sheet, j - offset + cell.getColumnSpan() - 1);
                }
                if ((bar = ComponentUtils.getFacet((UIComponent)column, Facets.bar)) != null) {
                    this.insideBegin(facesContext, Facets.bar);
                    bar.encodeAll(facesContext);
                    this.insideEnd(facesContext, Facets.bar);
                }
                writer.endElement(HtmlElements.TH);
            }
            if (!autoLayout) {
                this.encodeHeaderFiller(writer, TobagoClass.ROW__FILLER);
            }
            this.encodeHeaderFiller(writer, TobagoClass.BEHAVIOR__CONTAINER);
            writer.endElement(HtmlElements.TR);
        }
    }

    private void encodeHeaderFiller(TobagoResponseWriter writer, CssItem cssItem) throws IOException {
        writer.startElement(HtmlElements.TH);
        writer.writeClassAttribute(cssItem);
        writer.startElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.SPAN);
        writer.endElement(HtmlElements.TH);
    }

    private void writeColgroup(FacesContext facesContext, AbstractUISheet sheet, TobagoResponseWriter writer, List<Integer> columnWidths, List<AbstractUIColumnBase> columns, boolean isHeader) throws IOException {
        writer.startElement(HtmlElements.COLGROUP);
        int numOfCols = 0;
        for (AbstractUIColumnBase column : columns) {
            if (column instanceof AbstractUIRow || column instanceof AbstractUIColumnPanel || !column.isRendered()) continue;
            this.writeCol(writer, null);
            ++numOfCols;
        }
        this.writeCol(writer, TobagoClass.ROW__FILLER);
        this.writeCol(writer, TobagoClass.BEHAVIOR__CONTAINER);
        writer.endElement(HtmlElements.COLGROUP);
        if (isHeader) {
            Measure measure2;
            MeasureList columnLayout = sheet.getColumnLayout();
            String sheetId = sheet.getClientId(facesContext);
            String encodedSheetId = StyleRenderUtils.encodeIdSelector(sheetId);
            boolean hasAutoOrFrValue = columnLayout.stream().anyMatch(measure -> measure.getUnit().equals((Object)Measure.Unit.AUTO) || measure.getUnit().equals((Object)Measure.Unit.FR));
            boolean columnWidthSetByUser = false;
            float fr = 0.0f;
            MeasureList tangibleMeasures = new MeasureList();
            int columnIndex = 0;
            int renderedColumnIndex = 0;
            for (AbstractUIColumnBase column : columns) {
                if (column instanceof AbstractUIRow || column instanceof AbstractUIColumnPanel) continue;
                if (column.isRendered()) {
                    int columnWidth = columnWidths.get(columnIndex);
                    if (columnWidth > -1) {
                        columnWidthSetByUser = true;
                        measure2 = new Measure(columnWidth, Measure.Unit.PX);
                    } else {
                        measure2 = columnLayout.get(columnIndex % columnLayout.getSize());
                    }
                    if (Measure.Unit.FR.equals((Object)measure2.getUnit())) {
                        fr += measure2.getValue();
                    } else {
                        if (Measure.Unit.AUTO.equals((Object)measure2.getUnit())) {
                            tangibleMeasures.add(new Measure(100.0 / (double)(numOfCols + 2), Measure.Unit.PERCENT));
                        } else {
                            tangibleMeasures.add(measure2);
                        }
                        this.encodeColStyle(facesContext, encodedSheetId, null, (Integer)renderedColumnIndex, measure2);
                    }
                    ++renderedColumnIndex;
                }
                ++columnIndex;
            }
            if (fr > 0.0f) {
                columnIndex = 0;
                renderedColumnIndex = 0;
                for (AbstractUIColumnBase column : columns) {
                    if (column instanceof AbstractUIRow || column instanceof AbstractUIColumnPanel) continue;
                    if (column.isRendered()) {
                        measure2 = columnLayout.get(columnIndex % columnLayout.getSize());
                        if (Measure.Unit.FR.equals((Object)measure2.getUnit())) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append("calc((100%");
                            for (Measure tangibleMeasure : tangibleMeasures) {
                                stringBuilder.append(" - ");
                                stringBuilder.append(tangibleMeasure.getValue());
                                stringBuilder.append(tangibleMeasure.getUnit().getValue());
                            }
                            stringBuilder.append(") / ");
                            stringBuilder.append(fr);
                            stringBuilder.append(" * ");
                            stringBuilder.append(measure2.getValue());
                            stringBuilder.append(")");
                            this.encodeColStyle(facesContext, writer, encodedSheetId, (Integer)renderedColumnIndex, stringBuilder.toString());
                        }
                        ++renderedColumnIndex;
                    }
                    ++columnIndex;
                }
            }
            Measure zeroPixel = new Measure(0, Measure.Unit.PX);
            this.encodeColStyle(facesContext, encodedSheetId, TobagoClass.ROW__FILLER, null, columnWidthSetByUser || !hasAutoOrFrValue ? Measure.AUTO : zeroPixel);
            this.encodeColStyle(facesContext, encodedSheetId, TobagoClass.BEHAVIOR__CONTAINER, null, zeroPixel);
        }
    }

    private void writeCol(TobagoResponseWriter writer, CssItem cssItem) throws IOException {
        writer.startElement(HtmlElements.COL);
        writer.writeClassAttribute(cssItem);
        writer.endElement(HtmlElements.COL);
    }

    private void encodeColStyle(FacesContext facesContext, String encodedSheetId, CssItem cssItem, Integer colIndex, Measure measure) throws IOException {
        AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
        style.setTransient(true);
        StringBuilder stringBuilder = new StringBuilder();
        if (cssItem != null) {
            stringBuilder.append(encodedSheetId);
            stringBuilder.append(" > header > table > colgroup > col.");
            stringBuilder.append(cssItem.getName());
            stringBuilder.append(", ");
            stringBuilder.append(encodedSheetId);
            stringBuilder.append(" > .tobago-body > table > colgroup > col.");
            stringBuilder.append(cssItem.getName());
        } else {
            stringBuilder.append(encodedSheetId);
            stringBuilder.append(" > header > table > colgroup > col:nth-child(");
            stringBuilder.append(colIndex + 1);
            stringBuilder.append(")");
            stringBuilder.append(", ");
            stringBuilder.append(encodedSheetId);
            stringBuilder.append(" > .tobago-body > table > colgroup > col:nth-child(");
            stringBuilder.append(colIndex + 1);
            stringBuilder.append(")");
        }
        style.setSelector(stringBuilder.toString());
        style.setWidth(measure);
        style.encodeAll(facesContext);
    }

    private void encodeColStyle(FacesContext facesContext, TobagoResponseWriter writer, String encodedSheetId, Integer colIndex, String widthCalc) throws IOException {
        writer.startElement(HtmlElements.STYLE);
        writer.writeAttribute(HtmlAttributes.NONCE, Nonce.getNonce(facesContext), false);
        String selector = encodedSheetId + " > header > table > colgroup > col:nth-child(" + (colIndex + 1) + "), " + encodedSheetId + " > .tobago-body > table > colgroup > col:nth-child(" + (colIndex + 1) + ")";
        StyleRenderUtils.writeSelector(writer, selector);
        writer.writeText("{width:");
        writer.writeText(widthCalc);
        writer.writeText(";}");
        writer.endElement(HtmlElements.STYLE);
    }

    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getSelectedRows(AbstractUISheet data, SheetState state) {
        List<Integer> selected = (List<Integer>)ComponentUtils.getAttribute((UIComponent)data, Attributes.selectedListString);
        if (selected == null && state != null) {
            selected = state.getSelectedRows();
        }
        if (selected == null) {
            selected = Collections.emptyList();
        }
        return selected;
    }

    private void encodeResizing(TobagoResponseWriter writer, AbstractUISheet sheet, int columnIndex) throws IOException {
        writer.startElement(HtmlElements.SPAN);
        writer.writeClassAttribute(TobagoClass.RESIZE);
        writer.writeAttribute(DataAttributes.COLUMN_INDEX, Integer.toString(columnIndex), false);
        writer.write("&nbsp;&nbsp;");
        writer.endElement(HtmlElements.SPAN);
    }
}

