/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.InstantEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.StringEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.StringQueryResult;

public class InstantFormatEvaluator
extends StringEvaluator {
    private final InstantEvaluator subject;
    private final Evaluator<String> format;
    private final Evaluator<String> timeZone;

    public InstantFormatEvaluator(InstantEvaluator subject, Evaluator<String> format, Evaluator<String> timeZone) {
        this.subject = subject;
        this.format = format;
        this.timeZone = timeZone;
    }

    @Override
    public QueryResult<String> evaluate(EvaluationContext evaluationContext) {
        Instant subjectValue = (Instant)this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new StringQueryResult(null);
        }
        QueryResult<String> formatResult = this.format.evaluate(evaluationContext);
        String format = formatResult.getValue();
        if (format == null) {
            return null;
        }
        QueryResult<String> tzResult = this.timeZone.evaluate(evaluationContext);
        String tz = tzResult.getValue();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format, Locale.US).withZone(ZoneId.of(tz));
        return new StringQueryResult(dtf.format(subjectValue));
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

