/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.ParseException;
import org.apache.nifi.registry.client.ExtensionRepoClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.registry.ExtensionRepoVersionSummariesResult;

public class ListBundleVersions
extends AbstractNiFiRegistryCommand<ExtensionRepoVersionSummariesResult> {
    public ListBundleVersions() {
        super("list-bundle-versions", ExtensionRepoVersionSummariesResult.class);
    }

    @Override
    public String getDescription() {
        return "Lists the versions of the specified extension bundle.";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_NAME.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_GROUP.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_ARTIFACT.createOption());
    }

    @Override
    public ExtensionRepoVersionSummariesResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        String bucketName = this.getRequiredArg(properties, CommandOption.BUCKET_NAME);
        String groupId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_GROUP);
        String artifactId = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_ARTIFACT);
        ExtensionRepoClient repoClient = client.getExtensionRepoClient();
        List bundleVersions = repoClient.getVersions(bucketName, groupId, artifactId);
        return new ExtensionRepoVersionSummariesResult(this.getResultType(properties), bundleVersions);
    }
}

