/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.zstd.okio;

import com.squareup.zstd.Zstd;
import com.squareup.zstd.ZstdCompressor;
import com.squareup.zstd.okio.OkioZstd;
import java.io.Closeable;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.Sink;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/squareup/zstd/okio/ZstdCompressSink;", "Lokio/Sink;", "sink", "Lokio/BufferedSink;", "compressor", "Lcom/squareup/zstd/ZstdCompressor;", "<init>", "(Lokio/BufferedSink;Lcom/squareup/zstd/ZstdCompressor;)V", "inputBuffer", "Lokio/Buffer;", "inputCursor", "Lokio/Buffer$UnsafeCursor;", "outputCursor", "closed", "", "write", "", "source", "byteCount", "", "flush", "close", "compress", "mode", "", "timeout", "Lokio/Timeout;", "zstd-kmp-okio"})
@SourceDebugExtension(value={"SMAP\nZstdCompressSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZstdCompressSink.kt\ncom/squareup/zstd/okio/ZstdCompressSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,149:1\n1#2:150\n72#3:151\n58#3,22:152\n72#3:174\n58#3,4:175\n72#3:179\n58#3,22:180\n66#3,10:202\n62#3,3:212\n77#3,3:215\n*S KotlinDebug\n*F\n+ 1 ZstdCompressSink.kt\ncom/squareup/zstd/okio/ZstdCompressSink\n*L\n79#1:151\n79#1:152,22\n99#1:174\n99#1:175,4\n105#1:179\n105#1:180,22\n99#1:202,10\n99#1:212,3\n99#1:215,3\n*E\n"})
public final class ZstdCompressSink
implements Sink {
    @JvmField
    @NotNull
    public final BufferedSink sink;
    @NotNull
    private final ZstdCompressor compressor;
    @NotNull
    private final Buffer inputBuffer;
    @NotNull
    private final Buffer.UnsafeCursor inputCursor;
    @NotNull
    private final Buffer.UnsafeCursor outputCursor;
    @JvmField
    public boolean closed;

    public ZstdCompressSink(@NotNull BufferedSink sink, @NotNull ZstdCompressor compressor) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)compressor, (String)"compressor");
        this.sink = sink;
        this.compressor = compressor;
        this.inputBuffer = new Buffer();
        this.inputCursor = new Buffer.UnsafeCursor();
        this.outputCursor = new Buffer.UnsafeCursor();
    }

    public void write(@NotNull Buffer source, long byteCount) throws IOException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        this.inputBuffer.write(source, byteCount);
        this.compress(0);
    }

    public void flush() throws IOException {
        if (!(!this.closed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
        this.compress(1);
        this.sink.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        Unit unit;
        Throwable thrown$iv;
        block21: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Closeable $this$use$iv = (Closeable)this.sink;
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSink it = (BufferedSink)$this$use$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)this.compressor;
                Throwable throwable = null;
                try {
                    ZstdCompressor it2 = (ZstdCompressor)autoCloseable;
                    boolean bl2 = false;
                    this.compress(2);
                    it2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                unit = Unit.INSTANCE;
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    unit = null;
                    break block21;
                }
                catch (Throwable throwable3) {
                    throw throwable3;
                }
                finally {
                    block22: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block22;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        Unit result$iv = unit;
        Throwable throwable = thrown$iv;
        if (throwable == null) return;
        throw throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void compress(int mode) {
        boolean bl;
        boolean finished;
        long l;
        long inputRemaining = 0L;
        if (mode == 0) {
            long l2;
            long it = l2 = this.inputBuffer.completeSegmentByteCount();
            boolean bl2 = false;
            if (it == 0L) {
                return;
            }
            l = l2;
        } else {
            l = this.inputBuffer.size();
        }
        inputRemaining = l;
        do {
            Long l3;
            Throwable thrown$iv;
            Object $this$use$iv;
            long result;
            block42: {
                result = 0L;
                $this$use$iv = (Closeable)this.sink.getBuffer().readAndWriteUnsafe(this.outputCursor);
                boolean $i$f$use = false;
                thrown$iv = null;
                try {
                    Buffer.UnsafeCursor outputCursor = (Buffer.UnsafeCursor)$this$use$iv;
                    boolean bl3 = false;
                    long outputSizeBefore = this.sink.getBuffer().size();
                    outputCursor.expandBuffer(1);
                    if (inputRemaining > 0L) {
                        Unit unit;
                        Throwable thrown$iv2;
                        block40: {
                            Closeable $this$use$iv2 = (Closeable)this.inputBuffer.readUnsafe(this.inputCursor);
                            boolean $i$f$use2 = false;
                            thrown$iv2 = null;
                            try {
                                Buffer.UnsafeCursor inputCursor = (Buffer.UnsafeCursor)$this$use$iv2;
                                boolean bl4 = false;
                                inputCursor.next();
                                Intrinsics.checkNotNull((Object)outputCursor.data);
                                int n = outputCursor.end;
                                int n2 = outputCursor.start;
                                Intrinsics.checkNotNull((Object)inputCursor.data);
                                result = this.compressor.compressStream2(outputCursor.data, n, n2, inputCursor.data, inputCursor.end, inputCursor.start, mode);
                                unit = Unit.INSTANCE;
                            }
                            catch (Throwable t$iv) {
                                try {
                                    thrown$iv2 = t$iv;
                                    unit = null;
                                    break block40;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    block41: {
                                        try {
                                            Closeable closeable = $this$use$iv2;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                        }
                                        catch (Throwable t$iv2) {
                                            if (thrown$iv2 == null) {
                                                thrown$iv2 = t$iv2;
                                                break block41;
                                            }
                                            ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv2);
                                        }
                                    }
                                }
                            }
                            try {
                                Closeable closeable = $this$use$iv2;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv) {
                                thrown$iv2 = t$iv;
                            }
                        }
                        Unit result$iv = unit;
                        Throwable throwable = thrown$iv2;
                        if (throwable != null) {
                            throw throwable;
                        }
                        inputRemaining -= (long)this.compressor.inputBytesProcessed;
                        this.inputBuffer.skip((long)this.compressor.inputBytesProcessed);
                    } else {
                        Intrinsics.checkNotNull((Object)outputCursor.data);
                        result = this.compressor.compressStream2(outputCursor.data, outputCursor.end, outputCursor.start, OkioZstd.getEmptyByteArray(), 0, 0, mode);
                    }
                    l3 = outputCursor.resizeBuffer(outputSizeBefore + (long)this.compressor.outputBytesProcessed);
                }
                catch (Throwable t$iv) {
                    try {
                        thrown$iv = t$iv;
                        l3 = null;
                        break block42;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block43: {
                            try {
                                Closeable closeable = $this$use$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv3) {
                                if (thrown$iv == null) {
                                    thrown$iv = t$iv3;
                                    break block43;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv3);
                            }
                        }
                    }
                }
                try {
                    Object object = $this$use$iv;
                    if (object != null) {
                        object.close();
                    }
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
            }
            Long result$iv = l3;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            this.sink.emitCompleteSegments();
            $this$use$iv = Zstd.getErrorName((long)result);
            if ($this$use$iv != null) {
                Object errorName = $this$use$iv;
                boolean bl5 = false;
                throw new IOException("zstd compress failed: " + (String)errorName);
            }
            if (mode == 0) {
                if (inputRemaining == 0L) {
                    return;
                }
                bl = false;
                continue;
            }
            if (inputRemaining == 0L && result == 0L) {
                return;
            }
            bl = false;
        } while (!(finished = bl));
    }

    @NotNull
    public Timeout timeout() {
        return this.sink.timeout();
    }
}

