/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.snapshot.RawSnapshotWriter;
import org.slf4j.Logger;

public class FollowerState
implements EpochState {
    private final int fetchTimeoutMs;
    private final int epoch;
    private final int leaderId;
    private final Set<Integer> voters;
    private final Timer fetchTimer;
    private Optional<LogOffsetMetadata> highWatermark;
    private Optional<RawSnapshotWriter> fetchingSnapshot;
    private final Logger log;

    public FollowerState(Time time, int epoch, int leaderId, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, int fetchTimeoutMs, LogContext logContext) {
        this.fetchTimeoutMs = fetchTimeoutMs;
        this.epoch = epoch;
        this.leaderId = leaderId;
        this.voters = voters;
        this.fetchTimer = time.timer((long)fetchTimeoutMs);
        this.highWatermark = highWatermark;
        this.fetchingSnapshot = Optional.empty();
        this.log = logContext.logger(FollowerState.class);
    }

    @Override
    public ElectionState election() {
        return new ElectionState(this.epoch, OptionalInt.of(this.leaderId), OptionalInt.empty(), this.voters);
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Follower";
    }

    public long remainingFetchTimeMs(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.remainingMs();
    }

    public int leaderId() {
        return this.leaderId;
    }

    public boolean hasFetchTimeoutExpired(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        return this.fetchTimer.isExpired();
    }

    public void resetFetchTimeout(long currentTimeMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset((long)this.fetchTimeoutMs);
    }

    public void overrideFetchTimeout(long currentTimeMs, long timeoutMs) {
        this.fetchTimer.update(currentTimeMs);
        this.fetchTimer.reset(timeoutMs);
    }

    public boolean updateHighWatermark(OptionalLong newHighWatermark) {
        if (!newHighWatermark.isPresent() && this.highWatermark.isPresent()) {
            throw new IllegalArgumentException(String.format("Attempt to overwrite current high watermark %s with unknown value", this.highWatermark));
        }
        if (this.highWatermark.isPresent()) {
            long previousHighWatermark = this.highWatermark.get().offset;
            long updatedHighWatermark = newHighWatermark.getAsLong();
            if (updatedHighWatermark < 0L) {
                throw new IllegalArgumentException(String.format("Illegal negative (%d) high watermark update", updatedHighWatermark));
            }
            if (previousHighWatermark > updatedHighWatermark) {
                throw new IllegalArgumentException(String.format("Non-monotonic update of high watermark from %d to %d", previousHighWatermark, updatedHighWatermark));
            }
            if (previousHighWatermark == updatedHighWatermark) {
                return false;
            }
        }
        Optional<LogOffsetMetadata> oldHighWatermark = this.highWatermark;
        this.highWatermark = newHighWatermark.isPresent() ? Optional.of(new LogOffsetMetadata(newHighWatermark.getAsLong())) : Optional.empty();
        this.logHighWatermarkUpdate(oldHighWatermark, this.highWatermark);
        return true;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    public Optional<RawSnapshotWriter> fetchingSnapshot() {
        return this.fetchingSnapshot;
    }

    public void setFetchingSnapshot(Optional<RawSnapshotWriter> newSnapshot) {
        this.fetchingSnapshot.ifPresent(RawSnapshotWriter::close);
        this.fetchingSnapshot = newSnapshot;
    }

    @Override
    public boolean canGrantVote(int candidateId, boolean isLogUpToDate) {
        this.log.debug("Rejecting vote request from candidate {} since we already have a leader {} in epoch {}", new Object[]{candidateId, this.leaderId(), this.epoch});
        return false;
    }

    public String toString() {
        return "FollowerState(fetchTimeoutMs=" + this.fetchTimeoutMs + ", epoch=" + this.epoch + ", leaderId=" + this.leaderId + ", voters=" + this.voters + ", highWatermark=" + this.highWatermark + ", fetchingSnapshot=" + this.fetchingSnapshot + ')';
    }

    @Override
    public void close() {
        this.fetchingSnapshot.ifPresent(RawSnapshotWriter::close);
    }

    private void logHighWatermarkUpdate(Optional<LogOffsetMetadata> oldHighWatermark, Optional<LogOffsetMetadata> newHighWatermark) {
        if (!oldHighWatermark.equals(newHighWatermark)) {
            if (oldHighWatermark.isPresent()) {
                this.log.trace("High watermark set to {} from {} for epoch {}", new Object[]{newHighWatermark, oldHighWatermark.get(), this.epoch});
            } else {
                this.log.info("High watermark set to {} for the first time for epoch {}", newHighWatermark, (Object)this.epoch);
            }
        }
    }
}

