/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.exchange;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExchangeConfig {
    private final String id;
    private final String clazz;
    private final String[] writersIDs;
    private final Map<String, String> parameters;

    private ExchangeConfig(String id, String clazz, String[] writersIDs, Map<String, String> parameters) {
        this.id = id;
        this.clazz = clazz;
        this.writersIDs = writersIDs;
        this.parameters = parameters;
    }

    public static ExchangeConfig getInstance(Element element) {
        String id = element.getAttribute("id");
        String clazz = element.getAttribute("class");
        NodeList writerList = element.getElementsByTagName("writer");
        String[] writers = new String[writerList.getLength()];
        for (int i = 0; i < writerList.getLength(); ++i) {
            writers[i] = ((Element)writerList.item(i)).getAttribute("id");
        }
        NodeList paramList = element.getElementsByTagName("param");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        for (int i = 0; i < paramList.getLength(); ++i) {
            Element param = (Element)paramList.item(i);
            paramsMap.put(param.getAttribute("name"), param.getAttribute("value"));
        }
        return new ExchangeConfig(id, clazz, writers, paramsMap);
    }

    public String getId() {
        return this.id;
    }

    public String getClazz() {
        return this.clazz;
    }

    String[] getWritersIDs() {
        return this.writersIDs;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }
}

