/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.service.NutchReader;

public class SequenceReader
implements NutchReader {
    public List<List<String>> read(String path) throws FileNotFoundException {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        Path file = new Path(path);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            while (reader.next(key, value)) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(key.toString());
                row.add(value.toString());
                rows.add(row);
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    public List<List<String>> head(String path, int nrows) throws FileNotFoundException {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        Path file = new Path(path);
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            for (int i = 0; reader.next(key, value) && i < nrows; ++i) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(key.toString());
                row.add(value.toString());
                rows.add(row);
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    public List<List<String>> slice(String path, int start, int end) throws FileNotFoundException {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        Path file = new Path(path);
        try {
            int i;
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            for (i = 0; i < start && reader.next(key, value); ++i) {
            }
            while (reader.next(key, value) && i < end) {
                ArrayList<String> row = new ArrayList<String>();
                row.add(key.toString());
                row.add(value.toString());
                rows.add(row);
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return rows;
    }

    @Override
    public int count(String path) throws FileNotFoundException {
        Path file = new Path(path);
        int i = 0;
        try {
            SequenceFile.Reader reader = new SequenceFile.Reader(conf, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)file)});
            Writable key = (Writable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
            while (reader.next(key, value)) {
                ++i;
            }
            reader.close();
        }
        catch (FileNotFoundException fne) {
            throw new FileNotFoundException();
        }
        catch (IOException e) {
            LOG.error("Error occurred while reading file {} : {}", (Object)file, (Object)StringUtils.stringifyException((Throwable)e));
            throw new WebApplicationException();
        }
        return i;
    }
}

