/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.util.OptionalInt;
import java.util.function.IntSupplier;
import org.apache.bval.util.Validate;

public class LazyInt
implements IntSupplier {
    private int value;
    private volatile IntSupplier init;

    public LazyInt(IntSupplier init) {
        this.init = Validate.notNull(init);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAsInt() {
        if (this.init != null) {
            LazyInt lazyInt = this;
            synchronized (lazyInt) {
                if (this.init != null) {
                    this.value = this.init.getAsInt();
                    this.init = null;
                }
            }
        }
        return this.value;
    }

    public synchronized OptionalInt optional() {
        return this.init == null ? OptionalInt.of(this.value) : OptionalInt.empty();
    }
}

