/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.impl.DBMutator;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class TableMutator
extends DBMutator {
    private ColumnOffsets _colOffsets;

    protected TableMutator(DatabaseImpl database) {
        super(database);
    }

    public void setColumnOffsets(int fixedOffset, int varOffset, int longVarOffset) {
        if (this._colOffsets == null) {
            this._colOffsets = new ColumnOffsets();
        }
        this._colOffsets.set(fixedOffset, varOffset, longVarOffset);
    }

    public ColumnOffsets getColumnOffsets() {
        return this._colOffsets;
    }

    public IndexImpl.ForeignKeyReference getForeignKey(IndexBuilder idx) {
        return null;
    }

    protected void validateColumn(Set<String> colNames, ColumnBuilder column) {
        if (column.getType() == DataType.COMPLEX_TYPE) {
            throw new UnsupportedOperationException(this.withErrorContext("Complex column creation is not yet implemented"));
        }
        column.validate(this.getFormat());
        if (!colNames.add(DatabaseImpl.toLookupName(column.getName()))) {
            throw new IllegalArgumentException(this.withErrorContext("duplicate column name: " + column.getName()));
        }
        this.setColumnSortOrder(column);
    }

    protected void validateIndex(Set<String> colNames, Set<String> idxNames, boolean[] foundPk, IndexBuilder index) {
        index.validate(colNames, this.getFormat());
        if (!idxNames.add(DatabaseImpl.toLookupName(index.getName()))) {
            throw new IllegalArgumentException(this.withErrorContext("duplicate index name: " + index.getName()));
        }
        if (index.isPrimaryKey()) {
            if (foundPk[0]) {
                throw new IllegalArgumentException(this.withErrorContext("found second primary key index: " + index.getName()));
            }
            foundPk[0] = true;
        } else if (index.getType() == 2 && this.getForeignKey(index) == null) {
            throw new IllegalArgumentException(this.withErrorContext("missing foreign key info for " + index.getName()));
        }
    }

    protected void validateAutoNumberColumn(Set<DataType> autoTypes, ColumnBuilder column) {
        if (!column.getType().isMultipleAutoNumberAllowed() && !autoTypes.add(column.getType())) {
            throw new IllegalArgumentException(this.withErrorContext("Can have at most one AutoNumber column of type " + (Object)((Object)column.getType()) + " per table"));
        }
    }

    private void setColumnSortOrder(ColumnBuilder column) {
        if (column.getType().isTextual() && column.getTextSortOrder() == null) {
            column.setTextSortOrder(this.getDbSortOrder());
        }
    }

    abstract String getTableName();

    public abstract int getTdefPageNumber();

    abstract short getColumnNumber(String var1);

    public abstract ColumnState getColumnState(ColumnBuilder var1);

    public abstract IndexDataState getIndexDataState(IndexBuilder var1);

    protected abstract String withErrorContext(String var1);

    static final class IndexDataState {
        private final List<IndexBuilder> _indexes = new ArrayList<IndexBuilder>();
        private int _indexDataNumber;
        private byte _umapRowNumber;
        private int _umapPageNumber;
        private int _rootPageNumber;

        IndexDataState() {
        }

        public IndexBuilder getFirstIndex() {
            return this._indexes.get(0);
        }

        public List<IndexBuilder> getIndexes() {
            return this._indexes;
        }

        public void addIndex(IndexBuilder idx) {
            this._indexes.add(idx);
        }

        public int getIndexDataNumber() {
            return this._indexDataNumber;
        }

        public void setIndexDataNumber(int newIndexDataNumber) {
            this._indexDataNumber = newIndexDataNumber;
        }

        public byte getUmapRowNumber() {
            return this._umapRowNumber;
        }

        public void setUmapRowNumber(byte newUmapRowNumber) {
            this._umapRowNumber = newUmapRowNumber;
        }

        public int getUmapPageNumber() {
            return this._umapPageNumber;
        }

        public void setUmapPageNumber(int newUmapPageNumber) {
            this._umapPageNumber = newUmapPageNumber;
        }

        public int getRootPageNumber() {
            return this._rootPageNumber;
        }

        public void setRootPageNumber(int newRootPageNumber) {
            this._rootPageNumber = newRootPageNumber;
        }
    }

    static final class ColumnState {
        private byte _umapOwnedRowNumber;
        private byte _umapFreeRowNumber;
        private int _umapPageNumber;

        ColumnState() {
        }

        public byte getUmapOwnedRowNumber() {
            return this._umapOwnedRowNumber;
        }

        public void setUmapOwnedRowNumber(byte newUmapOwnedRowNumber) {
            this._umapOwnedRowNumber = newUmapOwnedRowNumber;
        }

        public byte getUmapFreeRowNumber() {
            return this._umapFreeRowNumber;
        }

        public void setUmapFreeRowNumber(byte newUmapFreeRowNumber) {
            this._umapFreeRowNumber = newUmapFreeRowNumber;
        }

        public int getUmapPageNumber() {
            return this._umapPageNumber;
        }

        public void setUmapPageNumber(int newUmapPageNumber) {
            this._umapPageNumber = newUmapPageNumber;
        }
    }

    static final class ColumnOffsets {
        private short _fixedOffset;
        private short _varOffset;
        private short _longVarOffset;

        ColumnOffsets() {
        }

        public void set(int fixedOffset, int varOffset, int longVarOffset) {
            this._fixedOffset = (short)fixedOffset;
            this._varOffset = (short)varOffset;
            this._longVarOffset = (short)longVarOffset;
        }

        public short getNextVariableOffset(ColumnBuilder col) {
            if (!col.isVariableLength()) {
                return this._varOffset;
            }
            if (!col.getType().isLongValue()) {
                short s = this._varOffset;
                this._varOffset = (short)(s + 1);
                return s;
            }
            short s = this._longVarOffset;
            this._longVarOffset = (short)(s + 1);
            return s;
        }

        public short getNextFixedOffset(ColumnBuilder col) {
            if (col.storeInNullMask()) {
                return 0;
            }
            short offset = this._fixedOffset;
            this._fixedOffset = (short)(this._fixedOffset + col.getFixedDataSize());
            return offset;
        }
    }
}

