/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;

public abstract class MessageProcessor {
    private static StackLogger logger = CommonLogger.getLogger(MessageProcessor.class);
    protected static final String IN_ADDR_ANY = "0.0.0.0";
    protected static final String IN6_ADDR_ANY = "::0";
    private String sentBy;
    private HostPort sentByHostPort;
    private String savedIpAddress;
    private InetAddress ipAddress;
    private int port;
    protected String transport;
    private ListeningPointImpl listeningPoint;
    private boolean sentBySet;
    protected SIPTransactionStack sipStack;

    protected MessageProcessor(String transport) {
        this.transport = transport;
    }

    protected MessageProcessor(InetAddress ipAddress, int port, String transport, SIPTransactionStack transactionStack) {
        this(transport);
        this.initialize(ipAddress, port, transactionStack);
    }

    public final void initialize(InetAddress ipAddress, int port, SIPTransactionStack transactionStack) {
        this.sipStack = transactionStack;
        this.savedIpAddress = ipAddress.getHostAddress();
        this.ipAddress = ipAddress;
        this.port = port;
        this.sentByHostPort = new HostPort();
        this.sentByHostPort.setHost(new Host(ipAddress.getHostAddress()));
        this.sentByHostPort.setPort(port);
    }

    public String getTransport() {
        return this.transport;
    }

    public int getPort() {
        return this.port;
    }

    public Via getViaHeader() {
        try {
            Via via = new Via();
            if (this.sentByHostPort != null) {
                via.setSentBy(this.sentByHostPort);
                via.setTransport(this.getTransport());
            } else {
                Host host = new Host();
                host.setHostname(this.getIpAddress().getHostAddress());
                via.setHost(host);
                via.setPort(this.getPort());
                via.setTransport(this.getTransport());
            }
            return via;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (InvalidArgumentException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public ListeningPointImpl getListeningPoint() {
        if (this.listeningPoint == null && logger.isLoggingEnabled()) {
            logger.logError("getListeningPoint" + this + " returning null listeningpoint");
        }
        return this.listeningPoint;
    }

    public void setListeningPoint(ListeningPointImpl lp) {
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("setListeningPoint" + this + " listeningPoint = " + lp);
        }
        if (lp.getPort() != this.getPort()) {
            InternalErrorHandler.handleException("lp mismatch with provider", logger);
        }
        this.listeningPoint = lp;
    }

    public String getSavedIpAddress() {
        return this.savedIpAddress;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    protected void setIpAddress(InetAddress ipAddress) {
        this.sentByHostPort.setHost(new Host(ipAddress.getHostAddress()));
        this.ipAddress = ipAddress;
    }

    public void setSentBy(String sentBy) throws ParseException {
        int ind = sentBy.indexOf(":");
        if (ind == -1) {
            this.sentByHostPort = new HostPort();
            this.sentByHostPort.setHost(new Host(sentBy));
        } else {
            this.sentByHostPort = new HostPort();
            this.sentByHostPort.setHost(new Host(sentBy.substring(0, ind)));
            String portStr = sentBy.substring(ind + 1);
            try {
                int port = Integer.parseInt(portStr);
                this.sentByHostPort.setPort(port);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Bad format encountered at ", ind);
            }
        }
        this.sentBySet = true;
        this.sentBy = sentBy;
    }

    public String getSentBy() {
        if (this.sentBy == null && this.sentByHostPort != null) {
            this.sentBy = this.sentByHostPort.toString();
        }
        return this.sentBy;
    }

    public abstract SIPTransactionStack getSIPStack();

    public abstract MessageChannel createMessageChannel(HostPort var1) throws IOException;

    public abstract MessageChannel createMessageChannel(InetAddress var1, int var2) throws IOException;

    public abstract void start() throws IOException;

    public abstract void stop();

    public abstract int getDefaultTargetPort();

    public abstract boolean isSecure();

    public abstract int getMaximumMessageSize();

    public abstract boolean inUse();

    public boolean isSentBySet() {
        return this.sentBySet;
    }

    public static int getDefaultPort(String transport) {
        return transport.equalsIgnoreCase("TLS") ? 5061 : 5060;
    }
}

