/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.methods;

import com.github.caldav4j.CalDAVConstants;
import com.github.caldav4j.exceptions.CalDAV4JException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpResponse;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.security.AclProperty;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class HttpPropFindMethod
extends HttpPropfind {
    private static final Logger log = LoggerFactory.getLogger(HttpPropFindMethod.class);

    public HttpPropFindMethod(URI uri, int propfindType, DavPropertyNameSet names, int depth) throws IOException {
        super(uri, propfindType, names, depth);
    }

    public HttpPropFindMethod(URI uri, DavPropertyNameSet names, int depth) throws IOException {
        super(uri, names, depth);
    }

    public HttpPropFindMethod(URI uri, int propfindType, int depth) throws IOException {
        super(uri, propfindType, depth);
    }

    public HttpPropFindMethod(String uri, DavPropertyNameSet names, int depth) throws IOException {
        super(uri, names, depth);
    }

    public HttpPropFindMethod(String uri, int propfindType, DavPropertyNameSet propNameSet, int depth) throws IOException {
        super(uri, propfindType, propNameSet, depth);
    }

    public HttpPropFindMethod(String uri, int propfindType, int depth) throws IOException {
        super(uri, propfindType, depth);
    }

    public AclProperty getAcl(HttpResponse httpResponse, String urlPath) {
        DavProperty p = this.getDavProperty(httpResponse, urlPath, CalDAVConstants.DNAME_ACL);
        if (p != null) {
            try {
                return AclProperty.createFromXml((Element)p.toXml(DomUtil.createDocument()));
            }
            catch (ParserConfigurationException | DavException e) {
                log.warn("Unable to create AclProperty");
            }
        }
        return null;
    }

    public List<AclProperty.Ace> getAces(HttpResponse httpResponse, String urlPath) throws CalDAV4JException {
        if (this.succeeded(httpResponse)) {
            AclProperty acls = this.getAcl(httpResponse, urlPath);
            return acls.getValue();
        }
        throw new CalDAV4JException("Error getting ACLs. PROPFIND status is: " + httpResponse.getStatusLine().getStatusCode());
    }

    public String getCalendarDescription(HttpResponse httpResponse, String urlPath) {
        DavProperty p = this.getDavProperty(httpResponse, urlPath, CalDAVConstants.DNAME_CALENDAR_DESCRIPTION);
        if (p != null && p.getValue() != null) {
            return p.getValue().toString();
        }
        return "";
    }

    public String getDisplayName(HttpResponse httpResponse, String urlPath) {
        DavProperty p = this.getDavProperty(httpResponse, urlPath, DavPropertyName.DISPLAYNAME);
        if (p != null && p.getValue() != null) {
            return p.getValue().toString();
        }
        return "";
    }

    public DavProperty getDavProperty(HttpResponse httpResponse, String urlPath, DavPropertyName property) {
        try {
            MultiStatusResponse[] responses = this.getResponseBodyAsMultiStatus(httpResponse).getResponses();
            if (responses != null && this.succeeded(httpResponse)) {
                for (MultiStatusResponse r : responses) {
                    if (!r.getHref().equals(urlPath)) continue;
                    DavPropertySet props = r.getProperties(200);
                    return props.get(property);
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to get MultiStatusResponse. Status: " + httpResponse.getStatusLine().getStatusCode());
        }
        log.warn("Can't find object at: " + urlPath);
        return null;
    }

    public Collection<DavProperty> getDavProperties(HttpResponse httpResponse, DavPropertyName property) {
        ArrayList<DavProperty> set = new ArrayList<DavProperty>();
        try {
            MultiStatusResponse[] responses = this.getResponseBodyAsMultiStatus(httpResponse).getResponses();
            if (responses != null && this.succeeded(httpResponse)) {
                for (MultiStatusResponse r : responses) {
                    DavPropertySet props = r.getProperties(200);
                    if (props.isEmpty()) continue;
                    set.add(props.get(property));
                }
            }
        }
        catch (Exception e) {
            log.warn("Unable to get MultiStatusResponse. Status: " + httpResponse.getStatusLine().getStatusCode());
        }
        return set;
    }

    public MultiStatusResponse getResponseBodyAsMultiStatusResponse(HttpResponse httpResponse, String uri) throws DavException {
        MultiStatusResponse[] responses;
        for (MultiStatusResponse response : responses = this.getResponseBodyAsMultiStatus(httpResponse).getResponses()) {
            if (!response.getHref().equals(uri)) continue;
            return response;
        }
        log.warn("No Response found for uri: " + uri);
        return null;
    }
}

