/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.wicket.MetaDataEntry;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.page.IManageablePage;
import org.apache.wicket.pageStore.DelegatingPageStore;
import org.apache.wicket.pageStore.IPageContext;
import org.apache.wicket.pageStore.IPageStore;
import org.apache.wicket.util.string.Strings;

public abstract class GroupingPageStore
extends DelegatingPageStore {
    private static final String DEFAULT_GROUP = "default";
    private static final MetaDataKey<SessionData> KEY = new MetaDataKey<SessionData>(){
        private static final long serialVersionUID = 1L;
    };
    private final int maxGroups;
    private boolean stableGroups = false;

    public GroupingPageStore(IPageStore delegate, int maxGroups) {
        super(delegate);
        this.maxGroups = maxGroups;
    }

    public GroupingPageStore withStableGroups() {
        this.stableGroups = true;
        return this;
    }

    protected String getGroup(IManageablePage page) {
        return DEFAULT_GROUP;
    }

    private String getGroupInternal(IManageablePage page) {
        String group = this.getGroup(page);
        if (Strings.isEmpty((String)group)) {
            throw new WicketRuntimeException("group must not be empy");
        }
        return group;
    }

    @Override
    public void addPage(IPageContext context, IManageablePage page) {
        SessionData sessionData = this.getSessionData(context, true);
        sessionData.addPage(context, page, this.getGroupInternal(page), this.maxGroups, this.stableGroups, this.getDelegate());
    }

    @Override
    public void removePage(IPageContext context, IManageablePage page) {
        SessionData sessionData = this.getSessionData(context, false);
        if (sessionData == null) {
            return;
        }
        sessionData.removePage(context, page, this.getDelegate());
    }

    @Override
    public void removeAllPages(IPageContext context) {
        SessionData sessionData = this.getSessionData(context, false);
        if (sessionData == null) {
            return;
        }
        sessionData.removeAllPages(context, this.getDelegate());
    }

    @Override
    public IManageablePage getPage(IPageContext context, int id) {
        SessionData sessionData = this.getSessionData(context, false);
        if (sessionData == null) {
            return null;
        }
        return sessionData.getPage(context, id, this.getDelegate());
    }

    private SessionData getSessionData(IPageContext context, boolean create) {
        return context.getSessionData(KEY, create ? () -> new SessionData() : null);
    }

    static class SessionData
    implements Serializable {
        private final LinkedList<String> groups = new LinkedList();
        private final Map<String, MetaDataEntry<?>[]> metaData = new HashMap<String, MetaDataEntry<?>[]>();

        SessionData() {
        }

        public synchronized <T> void setMetaData(String group, MetaDataKey<T> key, T value) {
            this.metaData.put(group, key.set(this.metaData.get(group), value));
        }

        public synchronized <T> T getMetaData(String group, MetaDataKey<T> key) {
            return key.get(this.metaData.get(group));
        }

        public synchronized void addPage(IPageContext context, IManageablePage page, String group, int maxGroups, boolean stableGroups, IPageStore delegate) {
            if (!stableGroups) {
                for (String other : this.groups) {
                    delegate.removePage(new GroupContext(context, this, other), page);
                }
            }
            this.groups.remove(group);
            this.groups.addLast(group);
            delegate.addPage(new GroupContext(context, this, group), page);
            while (this.groups.size() > maxGroups) {
                String first = this.groups.removeFirst();
                delegate.removeAllPages(new GroupContext(context, this, first));
            }
        }

        public IManageablePage getPage(IPageContext context, int id, IPageStore delegate) {
            for (String group : this.groups) {
                IManageablePage page = delegate.getPage(new GroupContext(context, this, group), id);
                if (page == null) continue;
                return page;
            }
            return null;
        }

        public synchronized void removePage(IPageContext context, IManageablePage page, IPageStore delegate) {
            for (String group : this.groups) {
                delegate.removePage(new GroupContext(context, this, group), page);
            }
        }

        public synchronized void removeAllPages(IPageContext context, IPageStore delegate) {
            for (String group : this.groups) {
                delegate.removeAllPages(new GroupContext(context, this, group));
            }
        }
    }

    static class GroupContext
    implements IPageContext {
        private final IPageContext context;
        private final SessionData sessionData;
        private final String group;

        public GroupContext(IPageContext context, SessionData sessionData, String group) {
            this.context = context;
            this.sessionData = sessionData;
            this.group = group;
        }

        @Override
        public String getSessionId(boolean bind) {
            return this.context.getSessionId(true) + "_" + this.group;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T extends Serializable> T getSessionData(MetaDataKey<T> key, Supplier<T> defaultValue) {
            SessionData sessionData = this.sessionData;
            synchronized (sessionData) {
                Serializable data = (Serializable)this.sessionData.getMetaData(this.group, key);
                if (data == null && (data = (Serializable)defaultValue.get()) != null) {
                    this.sessionData.setMetaData(this.group, key, data);
                }
                return (T)data;
            }
        }

        @Override
        public <T extends Serializable> T getSessionAttribute(String key, Supplier<T> defaultValue) {
            return this.context.getSessionAttribute(key + "_" + this.group, defaultValue);
        }

        @Override
        public <T> T getRequestData(MetaDataKey<T> key, Supplier<T> defaultValue) {
            throw new WicketRuntimeException("no request available for group");
        }
    }
}

