/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.cycle;

import org.apache.wicket.MetaDataKey;
import org.apache.wicket.core.request.handler.IPageRequestHandler;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;

public class PageRequestHandlerTracker
implements IRequestCycleListener {
    public static final MetaDataKey<IPageRequestHandler> FIRST_HANDLER_KEY = new MetaDataKey<IPageRequestHandler>(){};
    public static final MetaDataKey<IPageRequestHandler> LAST_HANDLER_KEY = new MetaDataKey<IPageRequestHandler>(){};

    @Override
    public void onRequestHandlerResolved(RequestCycle cycle, IRequestHandler handler) {
        this.registerFirstHandler(cycle, handler);
        this.registerLastHandler(cycle, handler);
    }

    private void registerLastHandler(RequestCycle cycle, IRequestHandler handler) {
        IPageRequestHandler pageRequestHandler = this.findPageRequestHandler(handler);
        if (pageRequestHandler != null) {
            cycle.setMetaData((MetaDataKey)LAST_HANDLER_KEY, pageRequestHandler);
        }
    }

    private void registerFirstHandler(RequestCycle cycle, IRequestHandler handler) {
        IPageRequestHandler pageRequestHandler;
        if (PageRequestHandlerTracker.getFirstHandler(cycle) == null && (pageRequestHandler = this.findPageRequestHandler(handler)) != null) {
            cycle.setMetaData((MetaDataKey)FIRST_HANDLER_KEY, pageRequestHandler);
        }
    }

    private IPageRequestHandler findPageRequestHandler(IRequestHandler handler) {
        if (handler instanceof IPageRequestHandler) {
            return (IPageRequestHandler)handler;
        }
        if (handler instanceof IRequestHandlerDelegate) {
            return this.findPageRequestHandler(((IRequestHandlerDelegate)handler).getDelegateHandler());
        }
        return null;
    }

    public static IPageRequestHandler getLastHandler(RequestCycle cycle) {
        return cycle.getMetaData(LAST_HANDLER_KEY);
    }

    public static IPageRequestHandler getFirstHandler(RequestCycle cycle) {
        return cycle.getMetaData(FIRST_HANDLER_KEY);
    }
}

