/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.mediaserver;

import com.github.openjson.JSONObject;
import jakarta.inject.Inject;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.IWsClient;
import org.apache.openmeetings.mediaserver.AbstractStream;
import org.apache.openmeetings.mediaserver.KurentoHandler;
import org.apache.openmeetings.mediaserver.TestStreamProcessor;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.injection.Injector;
import org.kurento.client.Continuation;
import org.kurento.client.IceCandidate;
import org.kurento.client.MediaElement;
import org.kurento.client.MediaPipeline;
import org.kurento.client.MediaProfileSpecType;
import org.kurento.client.MediaType;
import org.kurento.client.PlayerEndpoint;
import org.kurento.client.RecorderEndpoint;
import org.kurento.client.WebRtcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KTestStream
extends AbstractStream {
    private static final Logger log = LoggerFactory.getLogger(KTestStream.class);
    private static final Map<String, String> TAGS = Map.of("mode", "test", "roomId", "test");
    @Inject
    private KurentoHandler kHandler;
    @Inject
    private TestStreamProcessor processor;
    private MediaPipeline pipeline;
    private WebRtcEndpoint webRtcEndpoint;
    private PlayerEndpoint player;
    private RecorderEndpoint recorder;
    private String recPath = null;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> recHandle;
    private int recTime;

    public KTestStream(IWsClient c, JSONObject msg) {
        super(null, c.getUid());
        Injector.get().inject((Object)this);
        this.createPipeline(() -> this.startTestRecording(c, msg));
    }

    private void startTestRecording(final IWsClient c, JSONObject msg) {
        this.webRtcEndpoint = KTestStream.createWebRtcEndpoint(this.pipeline, null, this.kHandler.getCertificateType());
        this.webRtcEndpoint.connect((MediaElement)this.webRtcEndpoint);
        MediaProfileSpecType profile = KTestStream.getProfile(msg);
        this.initRecPath();
        this.recorder = KTestStream.createRecorderEndpoint(this.pipeline, this.recPath, profile);
        this.recorder.addRecordingListener(evt -> {
            this.recTime = 0;
            this.recHandle = this.scheduler.scheduleAtFixedRate(() -> WebSocketHelper.sendClient((IWsClient)c, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"recording").put("time", this.recTime++)), 0L, 1L, TimeUnit.SECONDS);
            this.scheduler.schedule(() -> {
                this.recorder.stop();
                this.recHandle.cancel(true);
            }, 5L, TimeUnit.SECONDS);
        });
        this.recorder.addStoppedListener(evt -> {
            WebSocketHelper.sendClient((IWsClient)c, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"recStopped"));
            this.releaseRecorder();
        });
        switch (profile) {
            case WEBM: {
                this.webRtcEndpoint.connect((MediaElement)this.recorder, MediaType.AUDIO);
                this.webRtcEndpoint.connect((MediaElement)this.recorder, MediaType.VIDEO);
                break;
            }
            case WEBM_AUDIO_ONLY: {
                this.webRtcEndpoint.connect((MediaElement)this.recorder, MediaType.AUDIO);
                break;
            }
            case WEBM_VIDEO_ONLY: {
                this.webRtcEndpoint.connect((MediaElement)this.recorder, MediaType.VIDEO);
                break;
            }
        }
        String sdpOffer = msg.getString("sdpOffer");
        String sdpAnswer = this.webRtcEndpoint.processOffer(sdpOffer);
        this.addIceListener(c);
        WebSocketHelper.sendClient((IWsClient)c, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"startResponse").put("sdpAnswer", (Object)sdpAnswer));
        this.webRtcEndpoint.gatherCandidates();
        this.recorder.record((Continuation)new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                log.info("Recording started successfully");
            }

            public void onError(Throwable cause) throws Exception {
                KurentoHandler.sendError(c, "Failed to start recording");
                log.error("Failed to start recording", cause);
            }
        });
    }

    public void play(IWsClient inClient, JSONObject msg) {
        this.createPipeline(() -> {
            this.webRtcEndpoint = KTestStream.createWebRtcEndpoint(this.pipeline, true, this.kHandler.getCertificateType());
            this.player = KTestStream.createPlayerEndpoint(this.pipeline, this.recPath);
            this.player.connect((MediaElement)this.webRtcEndpoint);
            this.webRtcEndpoint.addMediaSessionStartedListener(evt -> {
                log.info("Media session started {}", (Object)evt);
                this.player.addErrorListener(event -> {
                    log.info("ErrorEvent for player with uid '{}': {}", (Object)inClient.getUid(), (Object)event.getDescription());
                    this.sendPlayEnd(inClient);
                });
                this.player.addEndOfStreamListener(event -> {
                    log.info("EndOfStreamEvent for player with uid '{}'", (Object)inClient.getUid());
                    this.sendPlayEnd(inClient);
                });
                this.player.play();
            });
            this.addIceListener(inClient);
            WebSocketHelper.sendClient((IWsClient)inClient, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"playResponse").put("sdpAnswer", (Object)this.webRtcEndpoint.processOffer(msg.getString("sdpOffer"))));
            this.webRtcEndpoint.gatherCandidates();
        });
    }

    public void addCandidate(IceCandidate cand) {
        if (this.webRtcEndpoint != null) {
            this.webRtcEndpoint.addIceCandidate(cand);
        }
    }

    private void createPipeline(final Runnable action) {
        this.release(false);
        this.pipeline = this.kHandler.createPipiline(TAGS, new Continuation<Void>(){

            public void onSuccess(Void result) throws Exception {
                action.run();
            }

            public void onError(Throwable cause) throws Exception {
                log.warn("Unable to create pipeline for test stream", cause);
            }
        });
    }

    private void addIceListener(IWsClient inClient) {
        this.webRtcEndpoint.addIceCandidateFoundListener(evt -> {
            IceCandidate cand = evt.getCandidate();
            WebSocketHelper.sendClient((IWsClient)inClient, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"iceCandidate").put("candidate", (Object)new JSONObject().put("candidate", (Object)cand.getCandidate()).put("sdpMid", (Object)cand.getSdpMid()).put("sdpMLineIndex", cand.getSdpMLineIndex())));
        });
    }

    private void sendPlayEnd(IWsClient inClient) {
        WebSocketHelper.sendClient((IWsClient)inClient, (JSONObject)TestStreamProcessor.newTestKurentoMsg().put("id", (Object)"playStopped"));
        this.releasePlayer();
    }

    private static MediaProfileSpecType getProfile(JSONObject msg) {
        boolean a = msg.getBoolean("audio");
        boolean v = msg.getBoolean("video");
        if (a && v) {
            return MediaProfileSpecType.WEBM;
        }
        if (v) {
            return MediaProfileSpecType.WEBM_VIDEO_ONLY;
        }
        return MediaProfileSpecType.WEBM_AUDIO_ONLY;
    }

    private void initRecPath() {
        File f = new File(OmFileHelper.getStreamsDir(), String.format("%s%s.%s", "TEST_SETUP_", UUID.randomUUID(), "webm"));
        this.recPath = OmFileHelper.getRecUri((File)f);
    }

    private void releaseEndpoint() {
        if (this.webRtcEndpoint != null) {
            this.webRtcEndpoint.release();
            this.webRtcEndpoint = null;
        }
    }

    private void releasePipeline() {
        if (this.pipeline != null) {
            this.pipeline.release();
            this.pipeline = null;
        }
    }

    private void releaseRecorder() {
        this.releaseEndpoint();
        if (this.recorder != null) {
            this.recorder.release();
            this.recorder = null;
        }
        this.releasePipeline();
    }

    private void releasePlayer() {
        this.releaseEndpoint();
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
        this.releasePipeline();
    }

    @Override
    public void release(boolean remove) {
        this.releasePlayer();
        this.releaseRecorder();
        if (remove) {
            this.processor.release(this);
        }
    }
}

