/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ListLongCodec {
    private ListLongCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Long> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 8]);
        Iterator<Long> iterator = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            FixedSizeTypesCodec.encodeLong(frame.content, i * 8, iterator.next());
        }
        clientMessage.add(frame);
    }

    public static List<Long> decode(ClientMessage.ForwardFrameIterator iterator) {
        return ListLongCodec.decode(iterator.next());
    }

    public static List<Long> decode(ClientMessage.Frame frame) {
        int itemCount = frame.content.length / 8;
        ArrayList<Long> result = new ArrayList<Long>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            result.add(FixedSizeTypesCodec.decodeLong(frame.content, i * 8));
        }
        return result;
    }
}

