/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.MapCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.KubernetesConfig;
import java.util.Map;

public final class KubernetesConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int USE_PUBLIC_IP_FIELD_OFFSET = 1;
    private static final int INITIAL_FRAME_SIZE = 2;

    private KubernetesConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, KubernetesConfig kubernetesConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[2]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, kubernetesConfig.isEnabled());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 1, kubernetesConfig.isUsePublicIp());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, kubernetesConfig.getTag());
        MapCodec.encode(clientMessage, kubernetesConfig.getProperties(), StringCodec::encode, StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static KubernetesConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        boolean usePublicIp = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 1);
        String tag = StringCodec.decode(iterator);
        Map<String, String> properties = MapCodec.decode(iterator, StringCodec::decode, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new KubernetesConfig(tag, enabled, usePublicIp, properties);
    }
}

