/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.dynamicconfig;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.DynamicConfigAddMapConfigCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.AbstractAddConfigMessageTask;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueryCacheConfigHolder;
import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MetadataPolicy;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeExtension;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.dynamicconfig.DynamicConfigurationAwareConfig;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.spi.impl.NodeEngine;
import java.security.Permission;
import java.util.ArrayList;

public class AddMapConfigMessageTask
extends AbstractAddConfigMessageTask<DynamicConfigAddMapConfigCodec.RequestParameters> {
    public AddMapConfigMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    protected AddMapConfigMessageTask(ClientMessage clientMessage, ILogger logger, NodeEngine nodeEngine, InternalSerializationService serializationService, ClientEngine clientEngine, Connection connection, NodeExtension nodeExtension, BuildInfo buildInfo, Config config, ClusterServiceImpl clusterService) {
        super(clientMessage, logger, nodeEngine, serializationService, clientEngine, connection, nodeExtension, buildInfo, config, clusterService);
    }

    @Override
    protected DynamicConfigAddMapConfigCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return DynamicConfigAddMapConfigCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return DynamicConfigAddMapConfigCodec.encodeResponse();
    }

    @Override
    protected IdentifiedDataSerializable getConfig() {
        MapConfig config = new MapConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).name);
        config.setAsyncBackupCount(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).asyncBackupCount);
        config.setBackupCount(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).backupCount);
        config.setCacheDeserializedValues(CacheDeserializedValues.valueOf(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).cacheDeserializedValues));
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).listenerConfigs != null && !((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).listenerConfigs.isEmpty()) {
            config.setEntryListenerConfigs(this.adaptListenerConfigs(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).listenerConfigs, ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace));
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).merkleTreeConfig != null) {
            config.setMerkleTreeConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).merkleTreeConfig);
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).eventJournalConfig != null) {
            config.setEventJournalConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).eventJournalConfig);
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).hotRestartConfig != null) {
            config.setHotRestartConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).hotRestartConfig);
        }
        config.setInMemoryFormat(InMemoryFormat.valueOf(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).inMemoryFormat));
        config.setAttributeConfigs(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).attributeConfigs);
        config.setReadBackupData(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).readBackupData);
        config.setStatisticsEnabled(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).statisticsEnabled);
        config.setPerEntryStatsEnabled(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).perEntryStatsEnabled);
        config.setIndexConfigs(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).indexConfigs);
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).mapStoreConfig != null) {
            config.setMapStoreConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).mapStoreConfig.asMapStoreConfig(this.serializationService, ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace));
        }
        config.setTimeToLiveSeconds(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).timeToLiveSeconds);
        config.setMaxIdleSeconds(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).maxIdleSeconds);
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).evictionConfig != null) {
            config.setEvictionConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).evictionConfig.asEvictionConfig(this.serializationService));
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).mergePolicy != null) {
            config.setMergePolicyConfig(this.mergePolicyConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).mergePolicy, ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).mergeBatchSize));
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).nearCacheConfig != null) {
            config.setNearCacheConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).nearCacheConfig.asNearCacheConfig(this.serializationService));
        }
        config.setPartitioningStrategyConfig(this.getPartitioningStrategyConfig());
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitionLostListenerConfigs != null && !((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitionLostListenerConfigs.isEmpty()) {
            config.setPartitionLostListenerConfigs(this.adaptListenerConfigs(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitionLostListenerConfigs, ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace));
        }
        config.setSplitBrainProtectionName(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).splitBrainProtectionName);
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).queryCacheConfigs != null && !((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).queryCacheConfigs.isEmpty()) {
            ArrayList<QueryCacheConfig> queryCacheConfigs = new ArrayList<QueryCacheConfig>(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).queryCacheConfigs.size());
            for (QueryCacheConfigHolder holder : ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).queryCacheConfigs) {
                queryCacheConfigs.add(holder.asQueryCacheConfig(this.serializationService, ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace));
            }
            config.setQueryCacheConfigs(queryCacheConfigs);
        }
        config.setWanReplicationRef(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).wanReplicationRef);
        config.setMetadataPolicy(MetadataPolicy.getById(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).metadataPolicy));
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).isDataPersistenceConfigExists) {
            config.setDataPersistenceConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).dataPersistenceConfig);
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).isTieredStoreConfigExists) {
            config.setTieredStoreConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).tieredStoreConfig);
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).isPartitioningAttributeConfigsExists) {
            config.setPartitioningAttributeConfigs(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitioningAttributeConfigs);
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).isUserCodeNamespaceExists) {
            config.setUserCodeNamespace(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace);
        }
        return config;
    }

    private PartitioningStrategyConfig getPartitioningStrategyConfig() {
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitioningStrategyClassName != null) {
            return new PartitioningStrategyConfig(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitioningStrategyClassName);
        }
        if (((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitioningStrategyImplementation != null) {
            PartitioningStrategy partitioningStrategy = (PartitioningStrategy)this.serializationService.toObject(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).partitioningStrategyImplementation);
            return new PartitioningStrategyConfig(partitioningStrategy);
        }
        return null;
    }

    @Override
    public Permission getUserCodeNamespacePermission() {
        return ((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace != null ? new UserCodeNamespacePermission(((DynamicConfigAddMapConfigCodec.RequestParameters)this.parameters).userCodeNamespace, "use") : null;
    }

    @Override
    public String getMethodName() {
        return "addMapConfig";
    }

    @Override
    protected boolean checkStaticConfigDoesNotExist(IdentifiedDataSerializable config) {
        DynamicConfigurationAwareConfig nodeConfig = (DynamicConfigurationAwareConfig)this.nodeEngine.getConfig();
        MapConfig mapConfig = (MapConfig)config;
        return DynamicConfigurationAwareConfig.checkStaticConfigDoesNotExist(nodeConfig.getStaticConfig().getMapConfigs(), mapConfig.getName(), mapConfig);
    }
}

