/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config.override;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.override.ConfigProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class ConfigOverrideValidator {
    private static final ILogger LOGGER = Logger.getLogger(ConfigOverrideValidator.class);

    private ConfigOverrideValidator() {
    }

    static void validate(Set<ConfigProvider> providers) {
        Set<String> sharedKeys = ConfigOverrideValidator.findDuplicateEntries(providers);
        if (!sharedKeys.isEmpty()) {
            LOGGER.severe("Discovered conflicting entries: " + String.join((CharSequence)",", sharedKeys));
            throw new InvalidConfigurationException("Discovered conflicting configuration entries");
        }
    }

    private static Set<String> findDuplicateEntries(Set<ConfigProvider> providers) {
        return providers.stream().flatMap(p -> p.properties().keySet().stream()).map(e -> e.replace("-", "")).collect(Collectors.groupingBy(i -> i, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

