/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.metricsets;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.Preconditions;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;

public final class ClassLoadingMetricSet {
    private ClassLoadingMetricSet() {
    }

    public static void register(MetricsRegistry metricsRegistry) {
        Preconditions.checkNotNull(metricsRegistry, "metricsRegistry");
        ClassLoadingMXBean mxBean = ManagementFactory.getClassLoadingMXBean();
        metricsRegistry.registerStaticProbe(mxBean, "classloading.loadedClassesCount", ProbeLevel.MANDATORY, ClassLoadingMXBean::getLoadedClassCount);
        metricsRegistry.registerStaticProbe(mxBean, "classloading.totalLoadedClassesCount", ProbeLevel.MANDATORY, ClassLoadingMXBean::getTotalLoadedClassCount);
        metricsRegistry.registerStaticProbe(mxBean, "classloading.unloadedClassesCount", ProbeLevel.MANDATORY, ClassLoadingMXBean::getUnloadedClassCount);
    }
}

