/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.collection;

import com.hazelcast.internal.util.ExceptionUtil;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DefaultedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> map;
    private final V missingValuePlaceholder;
    private final Function<K, V> missingValueComputer;

    private DefaultedMap(Map<K, V> map, V missingValuePlaceholder, Function<K, V> missingValueComputer) {
        this.map = map;
        this.missingValuePlaceholder = missingValuePlaceholder;
        this.missingValueComputer = missingValueComputer;
    }

    public DefaultedMap(Map<K, V> map, V defaultValue) {
        this(map, defaultValue, null);
    }

    public V getOrDefault(Object key) {
        V value = this.map.getOrDefault(key, this.missingValuePlaceholder);
        if (value == this.missingValuePlaceholder && this.missingValueComputer != null) {
            return this.missingValueComputer.apply(key);
        }
        return value;
    }

    public <K2, V2> DefaultedMap<K2, V2> mapKeysAndValues(Function<K, K2> keyMapper, Function<V, V2> valueMapper) {
        assert (this.missingValueComputer == null);
        return new DefaultedMap<Object, Object>(this.map.entrySet().stream().collect(Collectors.toMap(e -> keyMapper.apply(e.getKey()), e -> valueMapper.apply(e.getValue()))), valueMapper.apply(this.missingValuePlaceholder));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(@Nonnull Map<? extends K, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach(action);
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.map.replaceAll(function);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.map.putIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.map.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.map.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return this.map.replace(key, value);
    }

    @Override
    public V computeIfAbsent(K key, @Nonnull Function<? super K, ? extends V> mappingFunction) {
        return this.map.computeIfAbsent((K)key, mappingFunction);
    }

    @Override
    public V computeIfPresent(K key, @Nonnull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V compute(K key, @Nonnull BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.map.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
    }

    @Override
    public V merge(K key, @Nonnull V value, @Nonnull BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.map.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
    }

    public static class DefaultedMapBuilder<K, V> {
        private final Map<K, V> map;
        private V missingValuePlaceholder;

        public DefaultedMapBuilder(Map<K, V> map) {
            this.map = map;
        }

        public DefaultedMapBuilder<K, V> missingValuePlaceholder(V missingValuePlaceholder) {
            this.missingValuePlaceholder = missingValuePlaceholder;
            return this;
        }

        public DefaultedMap<K, V> orElse(V defaultValue) {
            return new DefaultedMap<K, V>(this.map, defaultValue);
        }

        public DefaultedMap<K, V> orElseGet(Function<K, V> missingValueComputer) {
            return new DefaultedMap<K, V>(this.map, this.missingValuePlaceholder, missingValueComputer);
        }

        public DefaultedMap<K, V> orElseThrow(Function<K, Throwable> keyNotFoundException) {
            return new DefaultedMap<Object, Object>(this.map, this.missingValuePlaceholder, key -> {
                throw ExceptionUtil.rethrow((Throwable)keyNotFoundException.apply(key));
            });
        }
    }
}

