/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.Metric;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

@SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
class CloudInfoProvider
implements MetricsProvider {
    static final HazelcastProperty AWS_ENDPOINT = new HazelcastProperty("hazelcast.phonehome.endpoint.aws", "http://169.254.169.254/latest/meta-data");
    static final HazelcastProperty AZURE_ENDPOINT = new HazelcastProperty("hazelcast.phonehome.endpoint.azure", "http://169.254.169.254/metadata/instance/compute?api-version=2018-02-01");
    static final HazelcastProperty GCP_ENDPOINT = new HazelcastProperty("hazelcast.phonehome.endpoint.gcp", "http://metadata.google.internal");
    static final HazelcastProperty KUBERNETES_TOKEN_PATH = new HazelcastProperty("hazelcast.phonehome.path.kubernetes.token", "/var/run/secrets/kubernetes.io/serviceaccount/token");
    static final HazelcastProperty DOCKER_FILE_PATH = new HazelcastProperty("hazelcast.phonehome.path.docker.file", "/.dockerenv");
    static final String CLOUD_ENVIRONMENT_ENV_VAR = "HZ_CLOUD_ENVIRONMENT";
    private volatile Map<Metric, String> environmentInfo;

    CloudInfoProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        if (this.environmentInfo != null) {
            this.environmentInfo.forEach(context::collect);
            return;
        }
        HazelcastProperties props = node.getProperties();
        HashMap<Metric, String> info = new HashMap<Metric, String>(2);
        if (MetricsProvider.fetchWebService(props.getString(AWS_ENDPOINT))) {
            info.put(PhoneHomeMetrics.CLOUD, "A");
        } else if (MetricsProvider.fetchWebService(props.getString(AZURE_ENDPOINT))) {
            info.put(PhoneHomeMetrics.CLOUD, "Z");
        } else if (MetricsProvider.fetchWebService(props.getString(GCP_ENDPOINT))) {
            info.put(PhoneHomeMetrics.CLOUD, "G");
        } else if (MetricsProvider.fetchWebService(props.getString(AWS_ENDPOINT), 401)) {
            info.put(PhoneHomeMetrics.CLOUD, "A");
        } else {
            info.put(PhoneHomeMetrics.CLOUD, "N");
        }
        try {
            Paths.get(props.getString(DOCKER_FILE_PATH), new String[0]).toRealPath(new LinkOption[0]);
            try {
                Paths.get(props.getString(KUBERNETES_TOKEN_PATH), new String[0]).toRealPath(new LinkOption[0]);
                info.put(PhoneHomeMetrics.DOCKER, "K");
            }
            catch (IOException e) {
                info.put(PhoneHomeMetrics.DOCKER, "D");
            }
        }
        catch (IOException e) {
            info.put(PhoneHomeMetrics.DOCKER, "N");
        }
        String cloudEnv = System.getenv(CLOUD_ENVIRONMENT_ENV_VAR);
        if (cloudEnv != null) {
            info.put(PhoneHomeMetrics.VIRIDIAN, cloudEnv);
        }
        this.environmentInfo = info;
        this.environmentInfo.forEach(context::collect);
    }
}

