/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.phonehome.MetricsCollectionContext;
import com.hazelcast.internal.util.phonehome.MetricsProvider;
import com.hazelcast.internal.util.phonehome.PhoneHomeMetrics;
import com.hazelcast.jet.config.JetConfig;
import com.hazelcast.jet.impl.JetServiceBackend;

class JetMetricsProvider
implements MetricsProvider {
    JetMetricsProvider() {
    }

    @Override
    public void provideMetrics(Node node, MetricsCollectionContext context) {
        JetConfig jetConfig = node.getNodeEngine().getConfig().getJetConfig();
        boolean isJetEnabled = jetConfig.isEnabled();
        context.collect(PhoneHomeMetrics.JET_ENABLED, isJetEnabled);
        context.collect(PhoneHomeMetrics.JET_RESOURCE_UPLOAD_ENABLED, jetConfig.isResourceUploadEnabled());
        if (isJetEnabled) {
            JetServiceBackend jetServiceBackend = (JetServiceBackend)node.getNodeEngine().getService("hz:impl:jetService");
            long jobSubmittedCount = jetServiceBackend.getJobCoordinationService().getJobSubmittedCount();
            context.collect(PhoneHomeMetrics.JET_JOBS_SUBMITTED, jobSubmittedCount);
        }
    }
}

