/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core.processor;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.PredicateEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.WriteLoggerP;
import com.hazelcast.jet.impl.processor.PeekWrappedP;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.impl.util.WrappingProcessorMetaSupplier;
import com.hazelcast.jet.impl.util.WrappingProcessorSupplier;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class DiagnosticProcessors {
    public static final FunctionEx<Object, String> PEEK_DEFAULT_TO_STRING = o -> {
        if (o instanceof Object[]) {
            Object[] objectArray = (Object[])o;
            return Arrays.deepToString(objectArray);
        }
        if (o instanceof byte[]) {
            byte[] byteArray = (byte[])o;
            return Arrays.toString(byteArray);
        }
        if (o instanceof short[]) {
            short[] shortArray = (short[])o;
            return Arrays.toString(shortArray);
        }
        if (o instanceof int[]) {
            int[] intArray = (int[])o;
            return Arrays.toString(intArray);
        }
        if (o instanceof long[]) {
            long[] longArray = (long[])o;
            return Arrays.toString(longArray);
        }
        if (o instanceof float[]) {
            float[] floatArray = (float[])o;
            return Arrays.toString(floatArray);
        }
        if (o instanceof double[]) {
            double[] doubleArray = (double[])o;
            return Arrays.toString(doubleArray);
        }
        if (o instanceof boolean[]) {
            boolean[] booleanArray = (boolean[])o;
            return Arrays.toString(booleanArray);
        }
        return Objects.toString(o);
    };

    private DiagnosticProcessors() {
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier writeLoggerP(@Nonnull FunctionEx<T, ? extends CharSequence> toStringFn) {
        Util.checkSerializable(toStringFn, "toStringFn");
        return ProcessorMetaSupplier.preferLocalParallelismOne(() -> new WriteLoggerP(toStringFn));
    }

    @Nonnull
    public static ProcessorMetaSupplier writeLoggerP() {
        return DiagnosticProcessors.writeLoggerP(PEEK_DEFAULT_TO_STRING);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier peekInputP(@Nonnull FunctionEx<T, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<T> shouldLogFn, @Nonnull ProcessorMetaSupplier wrapped) {
        return new WrappingProcessorMetaSupplier(wrapped, p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, true, false, false));
    }

    @Nonnull
    public static <T> ProcessorSupplier peekInputP(@Nonnull FunctionEx<T, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<T> shouldLogFn, @Nonnull ProcessorSupplier wrapped) {
        return new WrappingProcessorSupplier(wrapped, p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, true, false, false));
    }

    @Nonnull
    public static <T> SupplierEx<Processor> peekInputP(@Nonnull FunctionEx<T, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<T> shouldLogFn, @Nonnull SupplierEx<Processor> wrapped) {
        return wrapped.andThen(p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, true, false, false));
    }

    @Nonnull
    public static ProcessorMetaSupplier peekInputP(@Nonnull ProcessorMetaSupplier wrapped) {
        return DiagnosticProcessors.peekInputP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static ProcessorSupplier peekInputP(@Nonnull ProcessorSupplier wrapped) {
        return DiagnosticProcessors.peekInputP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static SupplierEx<Processor> peekInputP(@Nonnull SupplierEx<Processor> wrapped) {
        return DiagnosticProcessors.peekInputP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static <T> ProcessorMetaSupplier peekOutputP(@Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<? super T> shouldLogFn, @Nonnull ProcessorMetaSupplier wrapped) {
        return new WrappingProcessorMetaSupplier(wrapped, p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, false, true, false));
    }

    @Nonnull
    public static <T> ProcessorSupplier peekOutputP(@Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<? super T> shouldLogFn, @Nonnull ProcessorSupplier wrapped) {
        return new WrappingProcessorSupplier(wrapped, p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, false, true, false));
    }

    @Nonnull
    public static <T> SupplierEx<Processor> peekOutputP(@Nonnull FunctionEx<? super T, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<? super T> shouldLogFn, @Nonnull SupplierEx<Processor> wrapped) {
        return wrapped.andThen(p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, false, true, false));
    }

    @Nonnull
    public static ProcessorMetaSupplier peekOutputP(@Nonnull ProcessorMetaSupplier wrapped) {
        return DiagnosticProcessors.peekOutputP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static ProcessorSupplier peekOutputP(@Nonnull ProcessorSupplier wrapped) {
        return DiagnosticProcessors.peekOutputP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static SupplierEx<Processor> peekOutputP(@Nonnull SupplierEx<Processor> wrapped) {
        return DiagnosticProcessors.peekOutputP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static <K, V> ProcessorMetaSupplier peekSnapshotP(@Nonnull FunctionEx<? super Map.Entry<K, V>, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<? super Map.Entry<K, V>> shouldLogFn, @Nonnull ProcessorMetaSupplier wrapped) {
        return new WrappingProcessorMetaSupplier(wrapped, p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, false, false, true));
    }

    @Nonnull
    public static <K, V> ProcessorSupplier peekSnapshotP(@Nonnull FunctionEx<? super Map.Entry<K, V>, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<? super Map.Entry<K, V>> shouldLogFn, @Nonnull ProcessorSupplier wrapped) {
        return new WrappingProcessorSupplier(wrapped, p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, false, false, true));
    }

    @Nonnull
    public static <K, V> SupplierEx<Processor> peekSnapshotP(@Nonnull FunctionEx<? super Map.Entry<K, V>, ? extends CharSequence> toStringFn, @Nonnull PredicateEx<? super Map.Entry<K, V>> shouldLogFn, @Nonnull SupplierEx<Processor> wrapped) {
        return wrapped.andThen(p -> new PeekWrappedP((Processor)p, toStringFn, shouldLogFn, false, false, true));
    }

    @Nonnull
    public static SupplierEx<Processor> peekSnapshotP(@Nonnull SupplierEx<Processor> wrapped) {
        return DiagnosticProcessors.peekSnapshotP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static ProcessorMetaSupplier peekSnapshotP(@Nonnull ProcessorMetaSupplier wrapped) {
        return DiagnosticProcessors.peekSnapshotP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }

    @Nonnull
    public static ProcessorSupplier peekSnapshotP(@Nonnull ProcessorSupplier wrapped) {
        return DiagnosticProcessors.peekSnapshotP(PEEK_DEFAULT_TO_STRING, PredicateEx.alwaysTrue(), wrapped);
    }
}

