/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.submitjob.memberside.validator;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.submitjob.memberside.JobMetaDataParameterObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public final class JarOnMemberValidator {
    private JarOnMemberValidator() {
    }

    public static void validate(JobMetaDataParameterObject parameterObject) {
        Path jarPath = parameterObject.getJarPath();
        JarOnMemberValidator.validateJarPathNotNull(jarPath);
        JarOnMemberValidator.validateFileSizeIsNotZero(jarPath);
        JarOnMemberValidator.validateFileExtension(jarPath);
        JarOnMemberValidator.validateJobParameters(parameterObject.getJobParameters());
    }

    static void validateJarPathNotNull(Path jarPath) {
        if (Objects.isNull(jarPath)) {
            throw new JetException("File path can not be null");
        }
    }

    static void validateFileExtension(Path jarPath) {
        String fileName = jarPath.getFileName().toString();
        if (!fileName.endsWith(".jar")) {
            throw new JetException("File name extension should be .jar");
        }
    }

    static void validateFileSizeIsNotZero(Path jarPath) {
        try {
            long jarSize = Files.size(jarPath);
            if (jarSize == 0L) {
                throw new JetException("File size can not be 0");
            }
        }
        catch (IOException exception) {
            throw new JetException("File is not accessible ", exception);
        }
    }

    static void validateJobParameters(List<String> jobParameters) {
        if (Objects.isNull(jobParameters)) {
            throw new JetException("jobParameters can not be null");
        }
    }
}

