/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.file;

import com.hazelcast.jet.pipeline.file.FileFormat;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;

public class LinesTextFileFormat
implements FileFormat<String> {
    public static final String FORMAT_LINES = "lines";
    private static final long serialVersionUID = 1L;
    private final String charset;

    LinesTextFileFormat() {
        this(StandardCharsets.UTF_8);
    }

    LinesTextFileFormat(@Nonnull Charset charset) {
        this.charset = Objects.requireNonNull(charset, "charset must not be null").name();
    }

    public Charset charset() {
        return Charset.forName(this.charset);
    }

    @Override
    @Nonnull
    public String format() {
        return FORMAT_LINES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinesTextFileFormat that = (LinesTextFileFormat)o;
        return Objects.equals(this.charset, that.charset);
    }

    public int hashCode() {
        return Objects.hash(this.charset);
    }
}

