/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.partition.IPartitionLostEvent;
import com.hazelcast.internal.partition.PartitionAwareService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceSegment;
import java.util.Set;

class MapPartitionAwareService
implements PartitionAwareService {
    private final MapServiceContext mapServiceContext;
    private final NodeEngine nodeEngine;
    private final EventServiceImpl eventService;

    MapPartitionAwareService(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.eventService = (EventServiceImpl)this.nodeEngine.getEventService();
    }

    @Override
    public void onPartitionLost(IPartitionLostEvent partitionLostEvent) {
        Address thisAddress = this.nodeEngine.getThisAddress();
        int partitionId = partitionLostEvent.getPartitionId();
        EventServiceSegment eventServiceSegment = this.eventService.getSegment("hz:impl:mapService", false);
        if (eventServiceSegment == null) {
            return;
        }
        Set maps = eventServiceSegment.getRegistrations().keySet();
        for (String mapName : maps) {
            int totalBackupCount = this.nodeEngine.getConfig().getMapConfig(mapName).getTotalBackupCount();
            if (totalBackupCount > partitionLostEvent.getLostReplicaIndex()) continue;
            this.mapServiceContext.getMapEventPublisher().publishMapPartitionLostEvent(thisAddress, mapName, partitionId);
        }
    }
}

