/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConcurrentReferenceHashMap;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.SampleableConcurrentHashMap;
import com.hazelcast.query.impl.getters.Getter;
import com.hazelcast.query.impl.getters.GetterCache;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class EvictableGetterCache
implements GetterCache {
    private final SampleableConcurrentHashMap<Class<?>, SampleableConcurrentHashMap<String, Getter>> getterCache;
    private final ConstructorFunction<Class<?>, SampleableConcurrentHashMap<String, Getter>> getterCacheConstructor;
    private final int maxClassCount;
    private final int afterEvictionClassCount;
    private final int maxGetterPerClassCount;
    private final int afterEvictionGetterPerClassCount;

    public EvictableGetterCache(int maxClassCount, int maxGetterPerClassCount, float evictPercentage, boolean strongReferences) {
        ConcurrentReferenceHashMap.ReferenceType referenceType = strongReferences ? ConcurrentReferenceHashMap.ReferenceType.STRONG : ConcurrentReferenceHashMap.ReferenceType.SOFT;
        this.getterCache = new SampleableConcurrentHashMap(maxClassCount, referenceType, referenceType);
        this.getterCacheConstructor = arg -> new SampleableConcurrentHashMap(maxGetterPerClassCount);
        this.maxClassCount = maxClassCount;
        this.afterEvictionClassCount = (int)((float)maxClassCount * (1.0f - evictPercentage));
        this.maxGetterPerClassCount = maxGetterPerClassCount;
        this.afterEvictionGetterPerClassCount = (int)((float)maxGetterPerClassCount * (1.0f - evictPercentage));
    }

    @Override
    @Nullable
    public Getter getGetter(Class<?> clazz, String attributeName) {
        ConcurrentMap cache = (ConcurrentMap)this.getterCache.get(clazz);
        if (cache == null) {
            return null;
        }
        return (Getter)cache.get(attributeName);
    }

    @Override
    public Getter putGetter(Class<?> clazz, String attributeName, Getter getter) {
        SampleableConcurrentHashMap<String, Getter> cache = ConcurrencyUtil.getOrPutIfAbsent(this.getterCache, clazz, this.getterCacheConstructor);
        Getter foundGetter = cache.putIfAbsent(attributeName, getter);
        this.evictOnPut(cache);
        return foundGetter == null ? getter : foundGetter;
    }

    private void evictOnPut(SampleableConcurrentHashMap<String, Getter> getterPerClassCache) {
        this.evictMap(getterPerClassCache, this.maxGetterPerClassCount, this.afterEvictionGetterPerClassCount);
        this.evictMap(this.getterCache, this.maxClassCount, this.afterEvictionClassCount);
    }

    private void evictMap(SampleableConcurrentHashMap<?, ?> map, int triggeringEvictionSize, int afterEvictionSize) {
        map.purgeStaleEntries();
        int mapSize = map.size();
        if (mapSize - triggeringEvictionSize >= 0) {
            for (SampleableConcurrentHashMap.SamplingEntry entry : map.getRandomSamples(mapSize - afterEvictionSize)) {
                map.remove(entry.getEntryKey());
            }
        }
    }

    int getClassCacheSize() {
        return this.getterCache.size();
    }

    int getGetterPerClassCacheSize(Class<?> clazz) {
        SampleableConcurrentHashMap cacheForClass = (SampleableConcurrentHashMap)this.getterCache.get(clazz);
        return cacheForClass != null ? cacheForClass.size() : -1;
    }
}

