/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.operations;

import com.hazelcast.core.IFunction;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.operations.AbstractRingBufferOperation;
import com.hazelcast.spi.impl.operationservice.BlockingOperation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.WaitNotifyKey;
import java.io.IOException;

public class ReadManyOperation<O>
extends AbstractRingBufferOperation
implements BlockingOperation,
ReadonlyOperation {
    transient long sequence;
    private int minSize;
    private int maxSize;
    private long startSequence;
    private IFunction<O, Boolean> filter;
    private transient ReadResultSetImpl<O, O> resultSet;

    public ReadManyOperation() {
    }

    public ReadManyOperation(String name, long startSequence, int minSize, int maxSize, IFunction<O, Boolean> filter) {
        super(name);
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.startSequence = startSequence;
        this.filter = filter;
    }

    @Override
    public void beforeRun() {
    }

    @Override
    public boolean shouldWait() {
        RingbufferContainer ringbuffer = this.getRingBufferContainerOrNull();
        if (this.resultSet == null) {
            this.resultSet = new ReadResultSetImpl(this.minSize, this.maxSize, this.getNodeEngine().getSerializationService(), this.filter);
            this.sequence = this.startSequence;
        }
        if (ringbuffer == null) {
            return this.minSize > 0;
        }
        this.sequence = ringbuffer.clampReadSequenceToBounds(this.sequence);
        if (this.minSize == 0) {
            if (this.sequence < ringbuffer.tailSequence() + 1L) {
                this.readMany(ringbuffer);
            }
            return false;
        }
        if (this.resultSet.isMinSizeReached()) {
            return false;
        }
        if (this.sequence == ringbuffer.tailSequence() + 1L) {
            return true;
        }
        this.readMany(ringbuffer);
        return !this.resultSet.isMinSizeReached();
    }

    private void readMany(RingbufferContainer ringbuffer) {
        this.sequence = ringbuffer.readMany(this.sequence, this.resultSet);
        this.resultSet.setNextSequenceToReadFrom(this.sequence);
    }

    @Override
    public void run() throws Exception {
    }

    @Override
    public void afterRun() throws Exception {
        this.reportReliableTopicReceived(this.resultSet.size());
    }

    @Override
    public Object getResponse() {
        return this.resultSet;
    }

    @Override
    public WaitNotifyKey getWaitKey() {
        return this.getRingbufferWaitNotifyKey();
    }

    @Override
    public void onWaitExpire() {
    }

    @Override
    public int getClassId() {
        return 6;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.startSequence);
        out.writeInt(this.minSize);
        out.writeInt(this.maxSize);
        out.writeObject(this.filter);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.startSequence = in.readLong();
        this.minSize = in.readInt();
        this.maxSize = in.readInt();
        String namespace = this.getUserCodeNamespace();
        this.filter = NamespaceUtil.callWithNamespace(this.getNodeEngine(), namespace, in::readObject);
    }
}

