/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.pages.auth;

import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.spinner.SpinnerAjaxButton;
import jakarta.inject.Inject;
import java.io.Serializable;
import org.apache.openmeetings.core.util.StrongPasswordValidator;
import org.apache.openmeetings.db.dao.user.IUserManager;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.Captcha;
import org.apache.openmeetings.web.common.OmModalCloseButton;
import org.apache.openmeetings.web.pages.PrivacyPage;
import org.apache.openmeetings.web.pages.auth.SignInDialog;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.validation.validator.RfcCompliantEmailAddressValidator;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.StringValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterDialog
extends Modal<String> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(RegisterDialog.class);
    private static final String FLD_EMAIL = "email";
    private final NotificationPanel feedback = new NotificationPanel("feedback");
    private final IModel<String> tzModel = Model.of((Serializable)((Object)WebSession.get().getClientTZCode()));
    private final RegisterForm form = new RegisterForm("form");
    private Captcha captcha;
    private String firstName;
    private String lastName;
    private String login;
    private String password;
    private String email;
    private String country;
    private Long lang;
    private boolean wasRegistered = false;
    @Inject
    private IUserManager userManager;
    @Inject
    private UserDao userDao;

    public RegisterDialog(String id) {
        super(id);
    }

    protected void onInitialize() {
        this.header((IModel)new ResourceModel("113"));
        this.setUseCloseHandler(true);
        this.addButton((Component)new SpinnerAjaxButton("button", (IModel)new ResourceModel("121"), (Form)this.form, Buttons.Type.Outline_Primary));
        this.addButton((Component)OmModalCloseButton.of());
        this.add(new Component[]{this.form});
        this.add(new Component[]{new Label("register", (Serializable)((Object)this.getString("121"))).setRenderBodyOnly(true), new BookmarkablePageLink("link", PrivacyPage.class)});
        this.reset(null);
        super.onInitialize();
    }

    public void setClientTimeZone() {
        this.tzModel.setObject((Object)WebSession.get().getClientTZCode());
    }

    public void reset(IPartialPageRequestHandler handler) {
        this.wasRegistered = false;
        this.firstName = null;
        this.lastName = null;
        this.login = null;
        this.password = null;
        this.form.confirmPassword.setModelObject(null);
        this.email = null;
        this.lang = WebSession.get().getLanguageByLocale();
        this.country = WebSession.get().getLocale().getCountry();
        this.captcha.refresh(handler);
    }

    public Modal<String> show(IPartialPageRequestHandler handler) {
        String baseURL = OpenmeetingsVariables.getBaseUrl();
        boolean sendEmailAtRegister = OpenmeetingsVariables.isSendRegisterEmail();
        boolean sendConfirmation = !Strings.isEmpty((String)baseURL) && OpenmeetingsVariables.isSendVerificationEmail();
        String messageCode = "account.created";
        if (sendConfirmation && sendEmailAtRegister) {
            messageCode = "warn.notverified";
        }
        Modal<String> registerInfo = this.getRegisterInfo();
        registerInfo.setModelObject((Object)this.getString(messageCode));
        handler.add(new Component[]{registerInfo.get("content")});
        this.reset(handler);
        handler.add(new Component[]{this.form});
        return super.show(handler);
    }

    public void onClose(IPartialPageRequestHandler handler) {
        if (!this.wasRegistered) {
            SignInDialog signin = (SignInDialog)this.getPage().get("signin");
            signin.show(handler);
        }
    }

    protected void onDetach() {
        this.tzModel.detach();
        super.onDetach();
    }

    private Modal<String> getRegisterInfo() {
        return (Modal)this.getPage().get("registerInfo");
    }

    class RegisterForm
    extends StatelessForm<Void> {
        private static final long serialVersionUID = 1L;
        private PasswordTextField confirmPassword;
        private PasswordTextField passwordField;
        private RequiredTextField<String> emailField;
        private RequiredTextField<String> loginField;

        public RegisterForm(String id) {
            super(id);
            this.setOutputMarkupId(true);
        }

        protected void onInitialize() {
            super.onInitialize();
            this.add(new Component[]{RegisterDialog.this.feedback.setOutputMarkupId(true)});
            RequiredTextField firstNameField = new RequiredTextField("firstName", (IModel)new PropertyModel((Object)RegisterDialog.this, "firstName"));
            RequiredTextField lastNameField = new RequiredTextField("lastName", (IModel)new PropertyModel((Object)RegisterDialog.this, "lastName"));
            this.add(new Component[]{firstNameField.setLabel((IModel)new ResourceModel("117"))});
            this.add(new Component[]{lastNameField.setLabel((IModel)new ResourceModel("136"))});
            this.loginField = new RequiredTextField("login", (IModel)new PropertyModel((Object)RegisterDialog.this, "login"));
            this.add(new Component[]{this.loginField.add((IValidator)StringValidator.minimumLength((int)OpenmeetingsVariables.getMinLoginLength())).setLabel((IModel)new ResourceModel("114"))});
            this.passwordField = new PasswordTextField("password", (IModel)new PropertyModel((Object)RegisterDialog.this, "password"));
            this.add(new Component[]{this.passwordField.setResetPassword(true).add((IValidator)new StrongPasswordValidator(new User()){
                private static final long serialVersionUID = 1L;

                public void validate(IValidatable<String> pass) {
                    User u = new User();
                    u.setLogin(RegisterForm.this.loginField.getRawInput());
                    u.setAddress(new Address());
                    u.getAddress().setEmail(RegisterForm.this.emailField.getRawInput());
                    this.setUser(u);
                    super.validate(pass);
                }
            }).setLabel((IModel)new ResourceModel("110"))});
            this.confirmPassword = new PasswordTextField("confirmPassword", (IModel)new Model()).setResetPassword(true);
            this.add(new Component[]{this.confirmPassword.setLabel((IModel)new ResourceModel("116"))});
            this.emailField = new RequiredTextField<String>(RegisterDialog.FLD_EMAIL, (IModel)new PropertyModel((Object)RegisterDialog.this, RegisterDialog.FLD_EMAIL)){
                private static final long serialVersionUID = 1L;

                protected String[] getInputTypes() {
                    return new String[]{RegisterDialog.FLD_EMAIL};
                }
            };
            this.add(new Component[]{this.emailField.add((IValidator)RfcCompliantEmailAddressValidator.getInstance()).setLabel((IModel)new ResourceModel("119"))});
            Component[] componentArray = new Component[1];
            RegisterDialog.this.captcha = new Captcha("captcha");
            componentArray[0] = RegisterDialog.this.captcha;
            this.add(componentArray);
            this.loginField.add((IValidator)StringValidator.minimumLength((int)OpenmeetingsVariables.getMinLoginLength())).setLabel((IModel)new ResourceModel("114"));
            AjaxButton ab = new AjaxButton("submit"){
                private static final long serialVersionUID = 1L;
            };
            this.add(new Component[]{ab});
            this.setDefaultButton((IFormSubmittingComponent)ab);
        }

        protected void onValidate() {
            if (this.passwordField.getConvertedInput() == null || !((String)this.passwordField.getConvertedInput()).equals(this.confirmPassword.getConvertedInput())) {
                this.error((Serializable)((Object)this.getString("232")));
            }
            if (!RegisterDialog.this.userDao.checkEmail((String)this.emailField.getConvertedInput(), User.Type.USER, null, null)) {
                this.error((Serializable)((Object)this.getString("error.email.inuse")));
            }
            if (!RegisterDialog.this.userDao.checkLogin((String)this.loginField.getConvertedInput(), User.Type.USER, null, null)) {
                this.error((Serializable)((Object)this.getString("error.login.inuse")));
            }
            if (this.hasErrorMessage()) {
                SignInDialog.penalty();
            }
        }

        protected void onError() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onError);
        }

        private void onError(AjaxRequestTarget target) {
            target.add(new Component[]{RegisterDialog.this.feedback});
        }

        protected void onSubmit() {
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(this::onSubmit);
        }

        private void onSubmit(AjaxRequestTarget target) {
            Modal<String> registerInfo = RegisterDialog.this.getRegisterInfo();
            RegisterDialog.this.wasRegistered = true;
            try {
                Object o = RegisterDialog.this.userManager.registerUser(RegisterDialog.this.login, RegisterDialog.this.password, RegisterDialog.this.lastName, RegisterDialog.this.firstName, RegisterDialog.this.email, RegisterDialog.this.country, RegisterDialog.this.lang.longValue(), (String)RegisterDialog.this.tzModel.getObject());
                if (o instanceof String) {
                    String str = (String)o;
                    registerInfo.setModelObject((Object)this.getString(str));
                    target.add(new Component[]{registerInfo.get("content")});
                }
            }
            catch (Exception e) {
                log.error("[registerUser]", (Throwable)e);
            }
            RegisterDialog.this.close((IPartialPageRequestHandler)target);
            registerInfo.show((IPartialPageRequestHandler)target);
        }
    }
}

