# mapResponse

@@@ div { .group-scala }

## Signature

@@signature [BasicDirectives.scala](/http/src/main/scala/org/apache/pekko/http/scaladsl/server/directives/BasicDirectives.scala) { #mapResponse }

@@@

## Description

The `mapResponse` directive is used as a building block for @ref[Custom Directives](../custom-directives.md) to transform a response that
was generated by the inner route. This directive transforms complete responses.

See also @ref[mapResponseHeaders](mapResponseHeaders.md) or @ref[mapResponseEntity](mapResponseEntity.md) for more specialized variants and
@ref[Response Transforming Directives](index.md#response-transforming-directives) for similar directives.

## Example: Override status

Scala
:  @@snip [BasicDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/BasicDirectivesExamplesSpec.scala) { #mapResponse0 }

Java
:  @@snip [BasicDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/BasicDirectivesExamplesTest.java) { #mapResponse }

## Example: Default to empty JSON response on errors

Scala
:  @@snip [BasicDirectivesExamplesSpec.scala](/docs/src/test/scala/docs/http/scaladsl/server/directives/BasicDirectivesExamplesSpec.scala) { #mapResponse1-advanced }

Java
:  @@snip [BasicDirectivesExamplesTest.java](/docs/src/test/java/docs/http/javadsl/server/directives/BasicDirectivesExamplesTest.java) { #mapResponse-advanced }
