/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import * as React from 'react';
import SvgIcon, { SvgIconProps } from '@material-ui/core/SvgIcon';

export default (props: any) => {
  if(props.fulllogo === 'true'){
    return (
      <SvgIcon style={{ width: 105, height: 40 }} width="105" height="40" viewBox="0 0 105 40" {...props}>
        <path d="M12.4159 0.305775C12.049 0.672747 12.0245 1.08865 12.367 1.51678C12.8685 2.1651 13.7003 1.79813 13.7003 0.94186C13.7003 0.0855913 12.9786 -0.269149 12.4159 0.305775Z" fill="white" />
        <path d="M6.18959 2.51987C5.71252 2.99693 5.84708 3.8165 6.44647 4.04892C7.16818 4.31803 7.8165 3.15595 7.26604 2.55656C7.00916 2.27522 6.44647 2.25075 6.18959 2.51987Z" fill="white" />
        <path d="M12.3792 3.62078C12.1101 3.80426 12.1101 3.82873 12.1101 7.37613C12.1101 11.3394 12.0856 11.4985 11.3762 11.4985C10.7034 11.4985 10.6422 11.3027 10.6422 9.22322C10.6422 7.35167 10.6422 7.3272 10.3242 7.02139C10.0917 6.77674 9.94496 6.72781 9.68808 6.78897C9.03976 6.94799 9.05199 6.85014 9.05199 10.948V14.7645L9.73701 14.4098C10.3119 14.1284 10.5933 14.0673 11.3272 14.0673C13.052 14.0673 14.3364 15.0826 14.7523 16.7829C14.9358 17.5046 14.9358 17.6391 14.7523 18.3486C14.422 19.6208 13.4924 20.6116 12.3058 20.9296C11.5229 21.1376 10.3976 21.0153 9.67585 20.6483L9.05199 20.318V22.0917C9.05199 23.8165 9.03976 23.8777 8.74618 24.159C8.58716 24.3303 8.36698 24.4648 8.25689 24.4648C8.1468 24.4648 7.92661 24.3303 7.76759 24.159L7.46178 23.8654L7.46178 14.8257L7.46178 5.78591L7.15597 5.65136C6.82569 5.50457 6.54435 5.5535 6.21407 5.84707C6.04282 5.98163 5.99389 6.22628 5.99389 6.81343L5.99389 7.58408H4.58716H3.1682L2.94802 8.09784C2.72783 8.63606 0.83181 15.3517 0.342513 17.3088C0.134562 18.1774 0.0856323 18.7645 0.0856323 20.1223C0.0856323 22.1162 0.318048 23.1804 1.08869 24.7706C2.18961 27.0581 3.74312 28.5382 6.55658 29.9449C8.08563 30.7156 8.42814 30.9969 8.85628 31.8654C9.30888 32.7951 9.50459 33.7981 9.67585 36.1223C9.79817 37.7492 9.78594 38.0917 9.65138 38.214C9.55352 38.2997 8.37921 38.7156 7.03364 39.1315C5.68808 39.5596 4.5627 39.9266 4.53823 39.951C4.51377 39.9755 7.09481 40 10.2875 39.9877C13.7125 39.9877 15.9633 39.9388 15.7798 39.8777C15.6086 39.8165 14.4098 39.4251 13.1009 39.0214L10.7278 38.263L10.8012 36.526C10.8869 34.4954 11.0336 33.4923 11.4006 32.4403C11.8165 31.2538 12.2569 30.8379 14.0184 29.9449C17.3211 28.2813 19.2049 26.2997 20.0612 23.5474C20.4526 22.3241 20.526 20.0734 20.2447 18.2874C19.8532 15.7553 17.6881 8.02444 17.2844 7.7431C17.1499 7.63301 16.5505 7.58408 15.3884 7.58408H13.7003V5.74922C13.7003 4.07338 13.6758 3.88989 13.4557 3.6697C13.1621 3.37613 12.7584 3.35167 12.3792 3.62078Z" fill="white" />
        <path d="M9.25998 3.7676C8.97864 4.07341 8.99087 4.80736 9.27222 5.052C9.50463 5.27219 9.99393 5.32112 10.2263 5.1621C10.471 5.00308 10.6667 4.50155 10.5933 4.2202C10.4343 3.57188 9.66365 3.315 9.25998 3.7676Z" fill="white" />
        <path d="M10.3976 15.9266C9.72481 16.3914 9.48016 16.8196 9.48016 17.5535C9.48016 18.5933 10.1652 19.3272 11.2172 19.4128C12.3303 19.4985 13.211 18.6544 13.211 17.4924C13.211 16.0734 11.5352 15.156 10.3976 15.9266Z" fill="white" />
        <path d="M50.1228 7.47518C49.301 7.90702 48.8902 8.57711 48.8141 9.54503C48.7532 10.5129 49.1032 11.1681 49.9858 11.7489C50.7162 12.2403 52.0097 12.2254 52.7554 11.734C54.201 10.781 54.1706 8.63668 52.7097 7.57942C52.1162 7.14758 50.838 7.08802 50.1228 7.47518Z" fill="white" />
        <path d="M98.2563 13.5352V16.5505H97.5073H96.7584V18.3597V20.1689H97.5073H98.2563L98.2862 26.6066L98.3312 33.0594L100.248 33.1046L102.151 33.1498V26.6518V20.1689H103.124H104.098V18.3597V16.5505H103.124H102.151V13.5352V10.5199H100.203H98.2563V13.5352Z" fill="white" />
        <path d="M64.596 16.4721C63.8441 16.7413 62.8465 17.3097 62.3248 17.7734L61.9718 18.0726V17.3845V16.6815H59.9767H57.9817V24.9082V33.1349H59.9614H61.9411L62.0025 27.8548C62.0792 21.9615 62.1559 21.453 63.1228 20.5107C63.7366 19.9123 64.8723 19.5982 65.9926 19.7179C67.4659 19.8974 68.1411 20.6004 68.4174 22.3056C68.5094 22.7992 68.5708 25.4317 68.5708 28.169V33.1498L70.5352 33.105L72.4842 33.0601L72.5302 27.8249C72.5609 24.624 72.4995 22.0962 72.4075 21.3184C72.1005 18.9999 71.1184 17.564 69.2614 16.7264C68.4787 16.3824 68.0951 16.3076 66.806 16.2776C65.6857 16.2477 65.0871 16.2926 64.596 16.4721Z" fill="white" />
        <path d="M82.8772 16.4602C81.3955 16.8233 80.1103 17.5799 78.9007 18.8055C77.0863 20.6364 76.3303 22.4219 76.3303 24.9488C76.3303 30.169 80.5185 34.088 85.7046 33.74C87.2317 33.6341 88.3506 33.3314 89.4846 32.7111C91.3746 31.6519 92.8261 29.9723 93.5367 28.0053C93.8845 27.052 93.945 26.6889 93.945 25.0244C93.945 23.4357 93.8845 22.9666 93.5972 22.1192C92.6447 19.3805 90.2708 17.2016 87.4434 16.4753C86.3699 16.203 83.981 16.203 82.8772 16.4602ZM86.5839 19.9168C87.6189 20.2242 88.5321 20.8543 89.0648 21.6227C90.526 23.7435 90.2977 27.2013 88.593 28.984C87.7255 29.8907 86.5839 30.3364 85.138 30.3364C83.8443 30.321 83.1441 30.1059 82.1396 29.3989C80.511 28.2617 79.7652 25.2035 80.5719 22.8982C81.4394 20.424 84.0269 19.1484 86.5839 19.9168Z" fill="white" />
        <path d="M49.4189 24.8855V33.1498L51.4062 33.1048L53.378 33.0598L53.4246 24.8405L53.4556 16.6361H51.4373H49.4189V24.8855Z" fill="white" />
        <path d="M34.932 16.9102C34.0837 17.0461 32.7508 17.5293 32.251 17.8766C31.7966 18.1938 31.7057 18.1636 31.7057 17.6501V17.1971H29.7366H27.7676L27.7676 28.5985V40H29.7366H31.7057V36.4663V32.9175L32.5842 33.3705C33.8111 33.9897 35.038 34.2615 36.6284 34.2615C39.2639 34.2615 41.3087 33.4461 43.0506 31.6943C44.7925 29.9577 45.5044 28.1908 45.5044 25.5481C45.5195 22.9356 44.7925 21.1536 42.99 19.3566C40.8695 17.2424 38.0673 16.3816 34.932 16.9102ZM38.1743 20.4091C40.297 20.9406 41.6067 23.112 41.4562 25.8453C41.3508 27.5613 40.9443 28.5179 39.9055 29.4898C38.8668 30.4312 37.8129 30.7805 36.2924 30.6894C34.4407 30.5679 33.0858 29.6416 32.318 28.0016C31.9718 27.2424 31.9266 26.969 31.9266 25.4809C31.9266 23.9928 31.9718 23.7194 32.318 22.9754C32.8449 21.8517 33.3267 21.2898 34.2601 20.7887C35.4494 20.1357 36.6387 20.0143 38.1743 20.4091Z" fill="white" />
      </SvgIcon>
    );
  }
  return (
    <SvgIcon style={{ width: 40, height: 40, fill: '#ffffff' }} viewBox="0 0 166.2 326.7" {...props}>
      <path id="Path" d="M100.8,2.3c-3,3-3.2,6.4-0.4,9.9c4.1,5.3,10.9,2.3,10.9-4.7S105.4-2.4,100.8,2.3z" />
      <path d="M49.9,20.4C46,24.3,47.1,31,52,32.9c5.9,2.2,11.2-7.3,6.7-12.2C56.6,18.4,52,18.2,49.9,20.4z" />
      <path d="M100.5,29.4c-2.2,1.5-2.2,1.7-2.2,30.7c0,32.4-0.2,33.7-6,33.7c-5.5,0-6-1.6-6-18.6c0-15.3,0-15.5-2.6-18
          c-1.9-2-3.1-2.4-5.2-1.9c-5.3,1.3-5.2,0.5-5.2,34v31.2l5.6-2.9c4.7-2.3,7-2.8,13-2.8c14.1,0,24.6,8.3,28,22.2c1.5,5.9,1.5,7,0,12.8
          c-2.7,10.4-10.3,18.5-20,21.1c-6.4,1.7-15.6,0.7-21.5-2.3l-5.1-2.7v14.5c0,14.1-0.1,14.6-2.5,16.9c-1.3,1.4-3.1,2.5-4,2.5
          s-2.7-1.1-4-2.5l-2.5-2.4V121V47.1L57.8,46c-2.7-1.2-5-0.8-7.7,1.6c-1.4,1.1-1.8,3.1-1.8,7.9v6.3H36.8H25.2L23.4,66
          c-1.8,4.4-17.3,59.3-21.3,75.3c-1.7,7.1-2.1,11.9-2.1,23c0,16.3,1.9,25,8.2,38c9,18.7,21.7,30.8,44.7,42.3
          c12.5,6.3,15.3,8.6,18.8,15.7c3.7,7.6,5.3,15.8,6.7,34.8c1,13.3,0.9,16.1-0.2,17.1c-0.8,0.7-10.4,4.1-21.4,7.5
          c-11,3.5-20.2,6.5-20.4,6.7c-0.2,0.2,20.9,0.4,47,0.3c28,0,46.4-0.4,44.9-0.9c-1.4-0.5-11.2-3.7-21.9-7L87,312.6l0.6-14.2
          c0.7-16.6,1.9-24.8,4.9-33.4c3.4-9.7,7-13.1,21.4-20.4c27-13.6,42.4-29.8,49.4-52.3c3.2-10,3.8-28.4,1.5-43
          c-3.2-20.7-20.9-83.9-24.2-86.2c-1.1-0.9-6-1.3-15.5-1.3h-13.8v-15c0-13.7-0.2-15.2-2-17C106.9,27.4,103.6,27.2,100.5,29.4z"
      />
      <path d="M75,30.6c-2.3,2.5-2.2,8.5,0.1,10.5c1.9,1.8,5.9,2.2,7.8,0.9c2-1.3,3.6-5.4,3-7.7C84.6,29,78.3,26.9,75,30.6z" />
      <path d="M84.3,130c-5.5,3.8-7.5,7.3-7.5,13.3c0,8.5,5.6,14.5,14.2,15.2c9.1,0.7,16.3-6.2,16.3-15.7C107.3,131.2,93.6,123.7,84.3,130
          z"
      />
    </SvgIcon>
  );

};
