/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpFindNewest
implements AsyncCallbacks.ReadEntryCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpFindNewest.class);
    private final ManagedCursorImpl cursor;
    private final ManagedLedgerImpl ledger;
    private final PositionImpl startPosition;
    private final AsyncCallbacks.FindEntryCallback callback;
    private final Predicate<Entry> condition;
    private final Object ctx;
    PositionImpl searchPosition;
    long min;
    long max;
    long mid;
    Position lastMatchedPosition = null;
    State state;

    public OpFindNewest(ManagedCursorImpl cursor, PositionImpl startPosition, Predicate<Entry> condition, long numberOfEntries, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        this.cursor = cursor;
        this.ledger = cursor.ledger;
        this.startPosition = startPosition;
        this.callback = callback;
        this.condition = condition;
        this.ctx = ctx;
        this.min = 0L;
        this.max = numberOfEntries;
        this.mid = this.mid();
        this.searchPosition = startPosition;
        this.state = State.checkFirst;
    }

    public OpFindNewest(ManagedLedgerImpl ledger, PositionImpl startPosition, Predicate<Entry> condition, long numberOfEntries, AsyncCallbacks.FindEntryCallback callback, Object ctx) {
        this.cursor = null;
        this.ledger = ledger;
        this.startPosition = startPosition;
        this.callback = callback;
        this.condition = condition;
        this.ctx = ctx;
        this.min = 0L;
        this.max = numberOfEntries;
        this.searchPosition = startPosition;
        this.state = State.checkFirst;
    }

    @Override
    public void readEntryComplete(Entry entry, Object ctx) {
        Position position = entry.getPosition();
        switch (this.state) {
            case checkFirst: {
                if (!this.condition.test(entry)) {
                    this.callback.findEntryComplete(null, this.ctx);
                    return;
                }
                this.lastMatchedPosition = position;
                this.state = State.checkLast;
                PositionImpl lastPosition = this.ledger.getLastPosition();
                this.searchPosition = this.ledger.getPositionAfterN(this.searchPosition, this.max, ManagedLedgerImpl.PositionBound.startExcluded);
                if (lastPosition.compareTo(this.searchPosition) < 0) {
                    if (log.isDebugEnabled()) {
                        log.debug("first position {} matches, last should be {}, but moving to lastPos {}", new Object[]{position, this.searchPosition, lastPosition});
                    }
                    this.searchPosition = lastPosition;
                }
                this.find();
                break;
            }
            case checkLast: {
                if (this.condition.test(entry)) {
                    this.callback.findEntryComplete(position, this.ctx);
                    return;
                }
                this.state = State.searching;
                this.mid = this.mid();
                this.searchPosition = this.ledger.getPositionAfterN(this.startPosition, this.mid, ManagedLedgerImpl.PositionBound.startExcluded);
                this.find();
                break;
            }
            case searching: {
                if (this.condition.test(entry)) {
                    this.lastMatchedPosition = position;
                    this.min = this.mid;
                } else {
                    this.max = this.mid - 1L;
                }
                this.mid = this.mid();
                if (this.max <= this.min) {
                    this.callback.findEntryComplete(this.lastMatchedPosition, this.ctx);
                    return;
                }
                this.searchPosition = this.ledger.getPositionAfterN(this.startPosition, this.mid, ManagedLedgerImpl.PositionBound.startExcluded);
                this.find();
            }
        }
    }

    @Override
    public void readEntryFailed(ManagedLedgerException exception, Object ctx) {
        if (exception instanceof ManagedLedgerException.NonRecoverableLedgerException && this.ledger.getConfig().isAutoSkipNonRecoverableData()) {
            try {
                log.info("[{}] Ledger {} is not recoverable, skip non-recoverable data, state:{}", new Object[]{this.ledger.getName(), this.searchPosition, this.state});
                Preconditions.checkArgument((this.state == State.checkFirst || this.state == State.checkLast || this.state == State.searching ? 1 : 0) != 0);
                if (this.state == State.checkFirst) {
                    PositionImpl nextPosition = this.findNextValidPosition(this.searchPosition, exception);
                    if (nextPosition != null && nextPosition.getEntryId() != -1L) {
                        long numberOfEntries = this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.closedOpen((Comparable)this.searchPosition, (Comparable)nextPosition));
                        this.searchPosition = nextPosition;
                        this.min += numberOfEntries;
                        this.find();
                        return;
                    }
                } else if (this.state == State.checkLast) {
                    PositionImpl prevPosition = this.findPreviousValidPosition(this.searchPosition, exception);
                    if (prevPosition != null && prevPosition.getEntryId() != -1L) {
                        long numberOfEntries = this.ledger.getNumberOfEntries((Range<PositionImpl>)Range.openClosed((Comparable)prevPosition, (Comparable)this.searchPosition));
                        this.searchPosition = prevPosition;
                        this.max -= numberOfEntries;
                        this.find();
                        return;
                    }
                } else if (this.state == State.searching) {
                    PositionImpl nextPosition = this.findNextValidPosition(this.searchPosition, exception);
                    if (nextPosition != null && nextPosition.getEntryId() != -1L) {
                        this.searchPosition = nextPosition;
                        this.find();
                        return;
                    }
                    PositionImpl prevPosition = this.findPreviousValidPosition(this.searchPosition, exception);
                    if (prevPosition != null && prevPosition.getEntryId() != -1L) {
                        this.searchPosition = prevPosition;
                        this.find();
                        return;
                    }
                }
                log.warn("[{}] Failed to find next valid entry. Returning last matched position: {}", (Object)this.ledger.getName(), (Object)this.lastMatchedPosition);
                this.callback.findEntryComplete(this.lastMatchedPosition, this.ctx);
                return;
            }
            catch (Exception e) {
                this.callback.findEntryFailed(new ManagedLedgerException("Failed to skip non-recoverable data during search position", e), Optional.ofNullable(this.searchPosition), this.ctx);
                return;
            }
        }
        this.callback.findEntryFailed(exception, Optional.ofNullable(this.searchPosition), this.ctx);
    }

    private PositionImpl findPreviousValidPosition(PositionImpl searchPosition, ManagedLedgerException exception) {
        PositionImpl minPosition;
        PositionImpl prevPosition = exception instanceof ManagedLedgerException.LedgerNotExistException ? this.ledger.getPreviousPosition(PositionImpl.get(searchPosition.getLedgerId(), -1L)) : this.ledger.getPreviousPosition(searchPosition);
        if (prevPosition.getEntryId() != -1L && (minPosition = this.ledger.getPositionAfterN(this.startPosition, this.min, ManagedLedgerImpl.PositionBound.startExcluded)).compareTo(prevPosition) > 0) {
            prevPosition = null;
        }
        return prevPosition;
    }

    private PositionImpl findNextValidPosition(PositionImpl searchPosition, Exception exception) {
        PositionImpl maxPosition;
        PositionImpl nextPosition = null;
        if (exception instanceof ManagedLedgerException.LedgerNotExistException) {
            Boolean nonEmptyLedger;
            Long nextLedgerId = this.ledger.getNextValidLedger(searchPosition.getLedgerId());
            if (nextLedgerId != null && (nonEmptyLedger = this.ledger.getOptionalLedgerInfo(nextLedgerId).map(ledgerInfo -> ledgerInfo.getEntries() > 0L).orElse(false)).booleanValue()) {
                nextPosition = PositionImpl.get(nextLedgerId, 0L);
            }
        } else {
            nextPosition = this.ledger.getNextValidPosition(searchPosition);
        }
        if (nextPosition != null && (maxPosition = this.ledger.getPositionAfterN(this.startPosition, this.max, ManagedLedgerImpl.PositionBound.startExcluded)).compareTo(nextPosition) < 0) {
            nextPosition = null;
        }
        return nextPosition;
    }

    public void find() {
        if (this.cursor != null ? this.cursor.hasMoreEntries(this.searchPosition) : this.ledger.hasMoreEntries(this.searchPosition)) {
            this.ledger.asyncReadEntry(this.searchPosition, this, null);
        } else {
            this.callback.findEntryComplete(this.lastMatchedPosition, this.ctx);
        }
    }

    private long mid() {
        return this.min + Math.max((this.max - this.min) / 2L, 1L);
    }

    static enum State {
        checkFirst,
        checkLast,
        searching;

    }
}

