/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.util;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.jspecify.annotations.Nullable;

@InterfaceStability.Evolving
public class ManagedLedgerUtils {
    public static final long NO_MAX_SIZE_LIMIT = -1L;

    public static CompletableFuture<ManagedCursor> openCursor(ManagedLedger ml, String cursorName) {
        final CompletableFuture<ManagedCursor> future = new CompletableFuture<ManagedCursor>();
        ml.asyncOpenCursor(cursorName, new AsyncCallbacks.OpenCursorCallback(){

            @Override
            public void openCursorComplete(ManagedCursor cursor, Object ctx) {
                future.complete(cursor);
            }

            @Override
            public void openCursorFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }

    public static CompletableFuture<List<Entry>> readEntries(ManagedCursor cursor, int numberOfEntriesToRead, Position maxPosition) {
        return ManagedLedgerUtils.readEntries(cursor, numberOfEntriesToRead, -1L, maxPosition);
    }

    public static CompletableFuture<List<Entry>> readEntries(ManagedCursor cursor, int numberOfEntriesToRead, long maxBytes, Position maxPosition) {
        final CompletableFuture<List<Entry>> future = new CompletableFuture<List<Entry>>();
        cursor.asyncReadEntries(numberOfEntriesToRead, maxBytes, new AsyncCallbacks.ReadEntriesCallback(){

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                future.complete(entries);
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null, (PositionImpl)maxPosition);
        return future;
    }

    public static CompletableFuture<List<Entry>> readEntriesWithSkipOrWait(ManagedCursor cursor, int maxEntries, long maxSizeBytes, PositionImpl maxPosition, @Nullable Predicate<PositionImpl> skipCondition) {
        final CompletableFuture<List<Entry>> future = new CompletableFuture<List<Entry>>();
        cursor.asyncReadEntriesWithSkipOrWait(maxEntries, maxSizeBytes, new AsyncCallbacks.ReadEntriesCallback(){

            @Override
            public void readEntriesComplete(List<Entry> entries, Object ctx) {
                future.complete(entries);
            }

            @Override
            public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null, maxPosition, skipCondition);
        return future;
    }

    public static CompletableFuture<Void> markDelete(ManagedCursor cursor, Position position, Map<String, Long> properties) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        cursor.asyncMarkDelete(position, properties, new AsyncCallbacks.MarkDeleteCallback(){

            @Override
            public void markDeleteComplete(Object ctx) {
                future.complete(null);
            }

            @Override
            public void markDeleteFailed(ManagedLedgerException exception, Object ctx) {
                future.completeExceptionally(exception);
            }
        }, null);
        return future;
    }
}

